---
generated_at: 2026-01-27 18:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-インクリメンタルビジュアライザ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/DevServer.zig` 行3608-3621（emitVisualizerMessageIfNeeded関数）
- E-02: `src/bake/DevServer.zig` 行3705-3749（writeVisualizerMessage関数）
- E-03: `src/bake/DevServer.zig` 行3925-3960（HmrTopic列挙型）
- E-04: `src/bake/DevServer.zig` 行68-69（client_graph, server_graph定義）
- E-05: `src/bake/DevServer.zig` 行221-223（emit_incremental_visualizer_events定義）
- E-06: `src/bake/DevServer.zig` 行3846-3865（MessageId.visualizerのドキュメント）
- E-07: `src/bake/DevServer/HmrSocket.zig` 行62-106（subscribeメッセージ処理）
- E-08: `src/bake/DevServer/HmrSocket.zig` 行78-82（incremental_visualizerのon-subscribeフック）
- E-09: `src/bake/DevServer/HmrSocket.zig` 行223-235（onUnsubscribe関数）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行23（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インクリメンタルビルドの状態をビジュアライザに送信 | E-01, E-02 | ○ |
| C-02 | デバッグ機能として使用される | E-10 | ○ |
| C-03 | WebSocket経由で送信 | E-01 | ○ |
| C-04 | incremental_visualizerトピックにパブリッシュ | E-01, E-03 | ○ |
| C-05 | emit_incremental_visualizer_eventsで参照カウント | E-05, E-08 | ○ |
| C-06 | bake_debugging_featuresフラグで制御 | E-01 | ○ |
| C-07 | MessageId.visualizerがメッセージID | E-02, E-06 | ○ |
| C-08 | クライアントグラフとサーバーグラフの両方を送信 | E-02 | ○ |
| C-09 | ファイルパス、状態フラグを含む | E-02, E-06 | ○ |
| C-10 | エッジ情報（依存関係）を含む | E-02, E-06 | ○ |
| C-11 | バイナリ形式で送信 | E-01 | ○ |
| C-12 | Little-endian形式 | E-06 | ○ |
| C-13 | サブスクライブ時に初回メッセージ送信 | E-08 | ○ |
| C-14 | アンサブスクライブ時に参照カウント減少 | E-09 | ○ |
| C-15 | スタックフォールバックバッファを使用 | E-01 | ○ |
| C-16 | OOM時は処理を中断 | E-01 | ○ |
| C-17 | リトライなし | E-01 | ○ |
| C-18 | /_bun/incremental_visualizerでアクセス | E-06 | ○ |
| C-19 | u32でファイル数を表現 | E-06 | ○ |
| C-20 | is_stale, is_rsc, is_ssr等のフラグを含む | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目に根拠あり、ソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] DevServer.zigの行番号が現在のソースと一致しているか確認
- [ ] HmrSocket.zigの行番号が現在のソースと一致しているか確認
- [ ] メッセージフォーマットの説明がソースコードのコメントと一致しているか確認
