---
generated_at: 2026-01-27 18:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-メモリビジュアライザ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/DevServer.zig` 行3638-3648（emitMemoryVisualizerMessage関数）
- E-02: `src/bake/DevServer.zig` 行3651-3703（writeMemoryVisualizerMessage関数）
- E-03: `src/bake/DevServer.zig` 行3623-3630（emitMemoryVisualizerMessageTimer関数）
- E-04: `src/bake/DevServer.zig` 行3632-3636（emitMemoryVisualizerMessageIfNeeded関数）
- E-05: `src/bake/DevServer.zig` 行3866-3879（MessageId.memory_visualizerのドキュメント）
- E-06: `src/bake/DevServer.zig` 行222-224（emit_memory_visualizer_events、memory_visualizer_timer定義）
- E-07: `src/bake/DevServer.zig` 行3930（HmrTopic.memory_visualizer定義）
- E-08: `src/bake/DevServer/HmrSocket.zig` 行83-93（memory_visualizerのon-subscribeフック）
- E-09: `src/bake/DevServer/HmrSocket.zig` 行228-234（onUnsubscribe関数）
- E-10: `src/bake/DevServer/SourceMapStore.zig` 行483（emitMemoryVisualizerMessageIfNeeded呼び出し）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行24（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メモリ使用状況をビジュアライザに送信 | E-01, E-02 | ○ |
| C-02 | デバッグ機能として使用される | E-11 | ○ |
| C-03 | WebSocket経由で送信 | E-01 | ○ |
| C-04 | memory_visualizerトピックにパブリッシュ | E-01, E-07 | ○ |
| C-05 | emit_memory_visualizer_eventsで参照カウント | E-06, E-08 | ○ |
| C-06 | bake_debugging_featuresフラグで制御 | E-01, E-03 | ○ |
| C-07 | MessageId.memory_visualizerがメッセージID | E-01, E-05 | ○ |
| C-08 | 1秒間隔のタイマーで定期送信 | E-03, E-08 | ○ |
| C-09 | incremental_graph_client/serverを含む | E-02, E-05 | ○ |
| C-10 | js_code、source_maps、assetsを含む | E-02, E-05 | ○ |
| C-11 | process_used、system_used、system_totalを含む | E-02, E-05 | ○ |
| C-12 | ソースマップエントリの詳細を含む | E-02 | ○ |
| C-13 | バイナリ形式で送信 | E-01 | ○ |
| C-14 | Little-endian形式 | E-02 | ○ |
| C-15 | サブスクライブ時に初回メッセージ送信 | E-08 | ○ |
| C-16 | 初回サブスクライバ時にタイマー開始 | E-08 | ○ |
| C-17 | 全サブスクライバ切断時にタイマー停止 | E-09 | ○ |
| C-18 | ソースマップunref時にも送信可能 | E-10 | ○ |
| C-19 | ref_countとweak_ref_countを含む | E-02 | ○ |
| C-20 | expire（有効期限）を含む | E-02 | ○ |
| C-21 | スタックフォールバックバッファを使用 | E-01 | ○ |
| C-22 | OOM時は処理を中断 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目に根拠あり、ソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] DevServer.zigの行番号が現在のソースと一致しているか確認
- [ ] HmrSocket.zigの行番号が現在のソースと一致しているか確認
- [ ] Fieldsのフィールド順序がコードと一致しているか確認
- [ ] タイマー間隔（1000ms）がコードと一致しているか確認
