---
generated_at: 2026-01-27 18:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-CSSリロード通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/css-reloader.ts` 行1-17（ファイル冒頭コメント）
- E-02: `src/bake/client/css-reloader.ts` 行18-25（CSS interface、cssStore定義）
- E-03: `src/bake/client/css-reloader.ts` 行33-56（activateCss、deactivateCss関数）
- E-04: `src/bake/client/css-reloader.ts` 行59-107（headObserver MutationObserver）
- E-05: `src/bake/client/css-reloader.ts` 行109-135（maybeAddCssLink関数）
- E-06: `src/bake/client/css-reloader.ts` 行146-169（editCssArray関数）
- E-07: `src/bake/client/css-reloader.ts` 行171-187（editCssContent関数）
- E-08: `src/bake/hmr-runtime-client.ts` 行118-196（hot_updateハンドラ）
- E-09: `src/bake/hmr-runtime-client.ts` 行138-168（CSS処理部分）
- E-10: `src/bake/DevServer.zig` 行3784-3821（MessageId.hot_updateドキュメント）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行25（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSSファイル変更時にホットリロード通知 | E-01, E-11 | ○ |
| C-02 | ページ全体のリロードなしにスタイル更新可能 | E-01, E-07 | ○ |
| C-03 | hot_updateメッセージの一部として送信 | E-08, E-10 | ○ |
| C-04 | editCssArray関数でルートのCSSリストを更新 | E-06 | ○ |
| C-05 | editCssContent関数でCSSコンテンツを更新 | E-07 | ○ |
| C-06 | CSSStyleSheetオブジェクトを使用 | E-07 | ○ |
| C-07 | document.adoptedStyleSheetsに追加 | E-07 | ○ |
| C-08 | 元のlink要素を無効化 | E-07 | ○ |
| C-09 | cssStoreでCSS状態を管理 | E-02 | ○ |
| C-10 | CSS識別子は16バイトhex | E-05, E-06, E-09 | ○ |
| C-11 | MutationObserverでhead要素を監視 | E-04 | ○ |
| C-12 | childListとattributes変更を監視 | E-04 | ○ |
| C-13 | /_bun/asset/で始まるhrefを検出 | E-05 | ○ |
| C-14 | activateCss/deactivateCssでCSS有効化/無効化 | E-03 | ○ |
| C-15 | SSRでlink要素が生成されることを前提 | E-01 | ○ |
| C-16 | sheet.disabled属性で無効化 | E-03 | ○ |
| C-17 | List 2でルートごとのCSSリストを送信 | E-09, E-10 | ○ |
| C-18 | List 3でCSS内容更新を送信 | E-09, E-10 | ○ |
| C-19 | currentRouteIndexでフィルタリング | E-08 | ○ |
| C-20 | registeredLinkTagsでlink要素を追跡 | E-04, E-05 | ○ |
| C-21 | バイナリ形式で送信 | E-08 | ○ |
| C-22 | DataViewReaderでパース | E-08 | ○ |
| C-23 | validateCssIdで識別子を検証 | E-06 | ○ |
| C-24 | 新しいCSSStyleSheetを作成してreplace | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目に根拠あり、ソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] css-reloader.tsの行番号が現在のソースと一致しているか確認
- [ ] hmr-runtime-client.tsの行番号が現在のソースと一致しているか確認
- [ ] CSS識別子のフォーマット（16文字hex）がコードと一致しているか確認
- [ ] hot_updateメッセージフォーマットがDevServer.zigのコメントと一致しているか確認
