---
generated_at: 2026-01-27 18:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-ソースマップ参照解除通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/DevServer/HmrSocket.zig` 行207-218（unref_source_map処理）
- E-02: `src/bake/DevServer/HmrSocket.zig` 行11（referenced_source_mapsフィールド）
- E-03: `src/bake/DevServer/HmrSocket.zig` 行237-262（onClose関数）
- E-04: `src/bake/DevServer/HmrSocket.zig` 行255-259（切断時の参照解除処理）
- E-05: `src/bake/DevServer/SourceMapStore.zig` 行374-376（unref関数）
- E-06: `src/bake/DevServer/SourceMapStore.zig` 行378-381（unrefCount関数）
- E-07: `src/bake/DevServer/SourceMapStore.zig` 行384-394（unrefAtIndex関数）
- E-08: `src/bake/DevServer/SourceMapStore.zig` 行10-70（Key、Entry構造体）
- E-09: `src/bake/DevServer/SourceMapStore.zig` 行14-29（WeakRef、weak_refs）
- E-10: `src/bake/DevServer.zig` 行3912-3914（IncomingMessageId.unref_source_map定義）
- E-11: `src/bake/client/stack-trace.ts` 行165-168（revokeObjectURL関数）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 行26（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソースマップの参照カウントを減らす通知 | E-01, E-05 | ○ |
| C-02 | クライアントからサーバーへ送信 | E-01, E-10 | ○ |
| C-03 | メッセージIDは'u' | E-01, E-10 | ○ |
| C-04 | ペイロードはu64のキー | E-01, E-08 | ○ |
| C-05 | Little-endian形式 | E-01 | ○ |
| C-06 | referenced_source_mapsから削除 | E-01 | ○ |
| C-07 | source_maps.unref呼び出し | E-01, E-05 | ○ |
| C-08 | ref_countが0で解放 | E-07 | ○ |
| C-09 | entries.swapRemoveAtで削除 | E-07 | ○ |
| C-10 | WebSocket切断時に自動処理 | E-03, E-04 | ○ |
| C-11 | keyIteratorで全キーをunref | E-04 | ○ |
| C-12 | 存在しないキーは警告ログ | E-01 | ○ |
| C-13 | fixedBufferStreamでパース | E-01 | ○ |
| C-14 | readInt(u64, .little)で読み取り | E-01 | ○ |
| C-15 | WeakRef機構による自動解放あり | E-09 | ○ |
| C-16 | SourceMapStore.Keyはu64ラッパー | E-08 | ○ |
| C-17 | unref関数はunrefCountを呼び出し | E-05 | ○ |
| C-18 | unrefCountはunrefAtIndexを呼び出し | E-06 | ○ |
| C-19 | ref_count -= countでデクリメント | E-07 | ○ |
| C-20 | entry.deinit()でクリーンアップ | E-07 | ○ |
| C-21 | クライアント側でrevokeObjectURL使用 | E-11 | ○ |
| C-22 | メモリリーク防止が目的 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目に根拠あり、ソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] HmrSocket.zigの行番号が現在のソースと一致しているか確認
- [ ] SourceMapStore.zigの行番号が現在のソースと一致しているか確認
- [ ] メッセージフォーマット（'u' + u64）がコードと一致しているか確認
- [ ] 参照カウント管理のロジックが正しく記述されているか確認
