---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-WebSocket再接続通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/websocket.ts` 172行目 - console.info("Reconnected") メッセージ
- E-02: `src/bake/client/websocket.ts` 162-188行目 - 再接続ループ
- E-03: `src/bake/client/websocket.ts` 169行目 - 新規 WebSocket 作成と wsProxy.wrapped 再割り当て
- E-04: `src/bake/client/websocket.ts` 171-176行目 - 再接続成功時の onopen ハンドラ
- E-05: `src/bake/client/websocket.ts` 173行目 - done(true) で Promise 解決
- E-06: `src/bake/client/websocket.ts` 174行目 - onStatusChange(true) 呼び出し
- E-07: `src/bake/client/websocket.ts` 175行目 - onerror ハンドラ再設定
- E-08: `src/bake/client/websocket.ts` 177行目 - onmessage ハンドラ設定
- E-09: `src/bake/client/websocket.ts` 165-167行目 - Promise パターン（iOS サポートのコメント）
- E-10: `src/bake/hmr-runtime-client.ts` 204-206行目 - onStatusChange でイベント発行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは `[Bun] Reconnected` | E-01 | ○ |
| C-02 | `console.info()` メソッドで出力される | E-01 | ○ |
| C-03 | 再接続ループ内の onopen イベントで発火する | E-02, E-04 | ○ |
| C-04 | 新しい WebSocket インスタンスが作成され wsProxy.wrapped に再割り当てされる | E-03 | ○ |
| C-05 | `onStatusChange(true)` が呼び出される | E-06 | ○ |
| C-06 | `bun:ws:connect` イベントが発行される | E-06, E-10 | ○ |
| C-07 | 再接続後に onerror ハンドラが再設定される | E-07 | ○ |
| C-08 | onmessage ハンドラは同じものが使用される | E-08 | ○ |
| C-09 | Promise.withResolvers を使用しない（iOS サポートのため） | E-09 | ○ |
| C-10 | 初回接続時はこの通知ではなく別の通知が使用される | E-01, websocket.ts 122-133行目 onFirstOpen | ○ |
| C-11 | 固定メッセージでテンプレート変数は存在しない | E-01 | ○ |
| C-12 | 成功時に done(true) で Promise が解決される | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けの情報通知であり、機能的な影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] メッセージ文字列がコード内の実装と一致しているか確認
- [ ] 初回接続時との挙動の違いが正しく記述されているか確認
- [ ] 再接続後のハンドラ再設定の挙動が正しく記述されているか確認
