---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-サーバーサイドコード変更通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/hmr-runtime-client.ts` 38行目 - console.info メッセージ
- E-02: `src/bake/hmr-runtime-client.ts` 37-63行目 - performRouteReload 関数
- E-03: `src/bake/hmr-runtime-client.ts` 33-35行目 - 状態変数定義
- E-04: `src/bake/hmr-runtime-client.ts` 118-196行目 - hot_update ハンドラ
- E-05: `src/bake/hmr-runtime-client.ts` 125-130行目 - List 1 解析
- E-06: `src/bake/hmr-runtime-client.ts` 136-137行目 - isServerSideRouteUpdate 判定
- E-07: `src/bake/hmr-runtime-client.ts` 170-177行目 - hasFatalError チェックと performRouteReload 呼び出し
- E-08: `src/bake/hmr-runtime-client.ts` 39-42行目 - 重複呼び出し防止
- E-09: `src/bake/hmr-runtime-client.ts` 44-58行目 - onServerSideReload 実装がある場合の処理
- E-10: `src/bake/hmr-runtime-client.ts` 62行目 - fullReload フォールバック
- E-11: `src/bake/hmr-runtime-client.ts` 54-56行目 - リロード失敗時のエラー出力
- E-12: `src/bake/client/overlay.ts` 16行目 - hasFatalError 変数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは `[Bun] Server-side code changed, reloading!` | E-01 | ○ |
| C-02 | `console.info()` メソッドで出力される | E-01 | ○ |
| C-03 | `performRouteReload` 関数で通知が出力される | E-02 | ○ |
| C-04 | `isPerformingRouteReload` で重複呼び出しが防止される | E-03, E-08 | ○ |
| C-05 | `shouldPerformAnotherRouteReload` で次回リロードがスケジュールされる | E-03, E-08 | ○ |
| C-06 | `currentRouteIndex` で現在表示中のルートを追跡 | E-03 | ○ |
| C-07 | `hot_update` メッセージで処理が開始される | E-04 | ○ |
| C-08 | サーバーサイドルート更新リスト（List 1）が解析される | E-05 | ○ |
| C-09 | `isServerSideRouteUpdate` で現在ルートの更新が判定される | E-06 | ○ |
| C-10 | `hasFatalError` が true の場合は即座に fullReload | E-07 | ○ |
| C-11 | `onServerSideReload` が実装されている場合はそれを呼び出す | E-09 | ○ |
| C-12 | `onServerSideReload` が未実装の場合は fullReload | E-10 | ○ |
| C-13 | リロード失敗時はエラーをコンソールに出力 | E-11 | ○ |
| C-14 | `hasFatalError` は overlay.ts で管理される | E-12 | ○ |
| C-15 | リロード中に再度変更が検出された場合は `shouldPerformAnotherRouteReload` が true に設定される | E-08 | ○ |
| C-16 | 固定メッセージでテンプレート変数は存在しない | E-01 | ○ |
| C-17 | サーバーサイドルート更新がない場合は CSS/JS の HMR 処理が行われる | E-04 (179-195行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けの情報通知であり、リロード処理は適切にフォールバックが実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] メッセージ文字列がコード内の実装と一致しているか確認
- [ ] サーバーサイドルート更新の判定ロジックが正しく記述されているか確認
- [ ] onServerSideReload 失敗時のフォールバック処理が正しく記述されているか確認
- [ ] hasFatalError との連携が正しく記述されているか確認
