---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-バージョン不一致通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/hmr-runtime-client.ts` 93行目 - console.error メッセージ
- E-02: `src/bake/hmr-runtime-client.ts` 91-117行目 - version ハンドラ
- E-03: `src/bake/hmr-runtime-client.ts` 89行目 - isFirstRun 変数定義
- E-04: `src/bake/hmr-runtime-client.ts` 92行目 - td.decode でバージョンデコード
- E-05: `src/bake/hmr-runtime-client.ts` 92行目 - config.version との比較
- E-06: `src/bake/hmr-runtime-client.ts` 94行目 - fullReload 呼び出し
- E-07: `src/bake/hmr-runtime-client.ts` 98-106行目 - 初回/再接続の分岐
- E-08: `src/bake/hmr-runtime-client.ts` 105行目 - 再接続時の fullReload
- E-09: `src/bake/DevServer/HmrSocket.zig` 31行目 - onOpen でのバージョン送信
- E-10: `src/bake/hmr-runtime-client.ts` 101-103行目 - 再接続時の fullReload 理由コメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは `Version mismatch, hard-reloading` | E-01 | ○ |
| C-02 | `console.error()` メソッドで出力される | E-01 | ○ |
| C-03 | `MessageId.version` メッセージで処理が開始される | E-02 | ○ |
| C-04 | `isFirstRun` で初回接続を判定する | E-03 | ○ |
| C-05 | `td.decode()` でサーバーバージョンをデコードする | E-04 | ○ |
| C-06 | `config.version` との比較でバージョン不一致を検出する | E-05 | ○ |
| C-07 | バージョン不一致時に `fullReload` が実行される | E-06 | ○ |
| C-08 | 初回接続/再接続で処理が分岐する | E-07 | ○ |
| C-09 | 再接続時はバージョン一致でも fullReload が実行される | E-08 | ○ |
| C-10 | サーバーは onOpen で configuration_hash_key を送信する | E-09 | ○ |
| C-11 | 再接続時の fullReload はクライアントファイルが古くなっている可能性があるため | E-10 | ○ |
| C-12 | 固定メッセージでテンプレート変数は存在しない | E-01 | ○ |
| C-13 | バージョン一致時は WebSocket サブスクリプションを送信する | E-02 (109-116行目) | ○ |
| C-14 | バージョン情報は通知メッセージに含まれない | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けのエラー通知であり、fullReload で確実に問題が解決される

## 6) レビュアーチェックリスト（最小）
- [ ] メッセージ文字列がコード内の実装と一致しているか確認
- [ ] バージョン比較ロジックが正しく記述されているか確認
- [ ] 初回接続と再接続での処理の違いが正しく記述されているか確認
- [ ] サーバーサイドのバージョン送信処理が正しく記述されているか確認
