---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-ビルドエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/overlay.ts` 199-214行目 - onServerErrorPayload 関数
- E-02: `src/bake/client/overlay.ts` 28-32行目 - buildErrors, errorDoms, updatedErrorOwners
- E-03: `src/bake/client/overlay.ts` 133-189行目 - mountModal 関数
- E-04: `src/bake/client/overlay.ts` 386-458行目 - updateErrorOverlay 関数
- E-05: `src/bake/client/overlay.ts` 526-568行目 - updateBuildErrorOverlay 関数
- E-06: `src/bake/client/overlay.ts` 578-588行目 - renderBundlerMessage 関数
- E-07: `src/bake/client/overlay.ts` 620-633行目 - renderCodeLine 関数
- E-08: `src/bake/client/error-serialization.ts` 5-9行目 - DeserializedFailure インターフェース
- E-09: `src/bake/client/error-serialization.ts` 11-17行目 - BundlerMessage インターフェース
- E-10: `src/bake/client/error-serialization.ts` 19-27行目 - BundlerMessageLocation インターフェース
- E-11: `src/bake/client/overlay.ts` 136-144行目 - Shadow DOM とスタイル設定
- E-12: `src/bake/client/overlay.ts` 420行目 - モーダルタイトル設定
- E-13: `src/bake/hmr-runtime-client.ts` 201行目 - errors ハンドラ登録
- E-14: `src/bake/client/overlay.ts` 368-381行目 - decodeAndAppendServerError 関数
- E-15: `src/bake/client/overlay.ts` 22行目 - FailureOwner 型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `MessageId.errors` でエラーメッセージを受信する | E-13 | ○ |
| C-02 | `onServerErrorPayload` でメッセージを処理する | E-01 | ○ |
| C-03 | `buildErrors` Map でエラーを管理する | E-02 | ○ |
| C-04 | `errorDoms` で DOM 要素をキャッシュする | E-02 | ○ |
| C-05 | `updatedErrorOwners` で更新されたエラーを追跡する | E-02 | ○ |
| C-06 | Shadow DOM 内にオーバーレイをレンダリングする | E-11 | ○ |
| C-07 | Z-index は 2147483647 で最前面に表示 | E-03 (136-144行目) | ○ |
| C-08 | モーダルタイトルはエラー数に応じて変化する | E-12 | ○ |
| C-09 | `DeserializedFailure` でエラーデータを保持する | E-08 | ○ |
| C-10 | `BundlerMessage` でエラーメッセージを表現する | E-09 | ○ |
| C-11 | `BundlerMessageLocation` で位置情報を保持する | E-10 | ○ |
| C-12 | `updateErrorOverlay` で UI を更新する | E-04 | ○ |
| C-13 | `updateBuildErrorOverlay` でビルドエラーを表示する | E-05 | ○ |
| C-14 | `renderBundlerMessage` でエラーメッセージを描画する | E-06 | ○ |
| C-15 | `renderCodeLine` でコードプレビューを描画する | E-07 | ○ |
| C-16 | `FailureOwner` は32ビット整数で識別される | E-15 | ○ |
| C-17 | `decodeAndAppendServerError` でエラーをデコードする | E-14 | ○ |
| C-18 | ビルドエラーはユーザーが dismiss できない | E-04 (444-452行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けのエラー表示機能であり、適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] オーバーレイの表示条件が正しく記述されているか確認
- [ ] エラーデータのシリアライズ/デシリアライズ形式が正しく記述されているか確認
- [ ] Shadow DOM によるスタイル分離が正しく記述されているか確認
- [ ] ビルドエラーとランタイムエラーの共存時の挙動が正しく記述されているか確認
