---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ランタイムエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/overlay.ts` 216-334行目 - onRuntimeError 関数
- E-02: `src/bake/client/overlay.ts` 103-116行目 - RuntimeError インターフェース
- E-03: `src/bake/client/overlay.ts` 118-125行目 - CodePreview インターフェース
- E-04: `src/bake/hmr-runtime-client.ts` 239-250行目 - window.error イベントリスナー
- E-05: `src/bake/hmr-runtime-client.ts` 252-254行目 - unhandledrejection イベントリスナー
- E-06: `src/bake/client/overlay.ts` 218-219行目 - hasFatalError = true 設定
- E-07: `src/bake/client/overlay.ts` 239行目 - parseStackTrace 呼び出し
- E-08: `src/bake/client/overlay.ts` 244-263行目 - DataViewWriter でバイナリデータ生成
- E-09: `src/bake/client/overlay.ts` 266-269行目 - fetch POST リクエスト
- E-10: `src/bake/client/overlay.ts` 274-317行目 - レスポンス解析
- E-11: `src/bake/client/overlay.ts` 463-524行目 - updateRuntimeErrorOverlay 関数
- E-12: `src/bake/client/overlay.ts` 416行目 - モーダルタイトル設定
- E-13: `src/bake/client/overlay.ts` 29行目 - runtimeErrors 配列
- E-14: `src/bake/client/overlay.ts` 318-327行目 - リマッピング失敗時の処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `window.error` イベントでエラーをキャプチャする | E-04 | ○ |
| C-02 | `unhandledrejection` イベントで Promise rejection をキャプチャする | E-05 | ○ |
| C-03 | `onRuntimeError` 関数でエラーを処理する | E-01 | ○ |
| C-04 | `hasFatalError` を true に設定する | E-06 | ○ |
| C-05 | `parseStackTrace` でスタックトレースを解析する | E-07 | ○ |
| C-06 | `DataViewWriter` でバイナリデータを生成する | E-08 | ○ |
| C-07 | `/_bun/report_error` に POST リクエストを送信する | E-09 | ○ |
| C-08 | サーバーレスポンスを解析してリマップされたトレースを取得する | E-10 | ○ |
| C-09 | リマッピング失敗時は元のトレースを使用する | E-14 | ○ |
| C-10 | `runtimeErrors` 配列でエラーを管理する | E-13 | ○ |
| C-11 | `RuntimeError` インターフェースでエラーデータを表現する | E-02 | ○ |
| C-12 | `CodePreview` インターフェースでコードプレビューを表現する | E-03 | ○ |
| C-13 | `updateRuntimeErrorOverlay` でオーバーレイを更新する | E-11 | ○ |
| C-14 | モーダルタイトルは `Runtime Error` / `Unhandled Promise Rejection` | E-12 | ○ |
| C-15 | エラー名、メッセージ、スタックトレースを表示する | E-11 | ○ |
| C-16 | コードプレビューとハイライトを表示する | E-11 (475-514行目) | ○ |
| C-17 | ビルドエラーがない場合のみ Dismiss All が可能 | E-01 overlay.ts 453行目 | ○ |
| C-18 | `async` フラグで Promise rejection を判定する | E-02, E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けのエラー表示機能であり、適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] エラーキャプチャの方法が正しく記述されているか確認
- [ ] スタックトレースリマッピングの処理が正しく記述されているか確認
- [ ] リマッピング失敗時のフォールバック処理が正しく記述されているか確認
- [ ] ランタイムエラーとビルドエラーの共存時の挙動が正しく記述されているか確認
