---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-致命的エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/overlay.ts` 16行目 - hasFatalError フラグ定義
- E-02: `src/bake/client/overlay.ts` 216-219行目 - onRuntimeError 内でのフラグ設定
- E-03: `src/bake/hmr-runtime-client.ts` 6行目 - hasFatalError import
- E-04: `src/bake/hmr-runtime-client.ts` 170-173行目 - フラグ参照とリロード判定
- E-05: `src/bake/hmr-runtime-client.ts` 249行目 - onRuntimeError(value, true, false) 呼び出し
- E-06: `src/bake/hmr-runtime-client.ts` 253行目 - onRuntimeError(event.reason, true, true) 呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `hasFatalError` は `export let` で定義される | E-01 | ○ |
| C-02 | 初期値は `false` | E-01 | ○ |
| C-03 | `onRuntimeError` で `fatal === true` の場合にフラグ設定 | E-02 | ○ |
| C-04 | `hmr-runtime-client.ts` で `hasFatalError` を import | E-03 | ○ |
| C-05 | `hot_update` ハンドラでフラグを参照 | E-04 | ○ |
| C-06 | `hasFatalError && (isServerSideRouteUpdate \|\| reader.hasMoreData())` でリロード判定 | E-04 | ○ |
| C-07 | 条件満たす場合 `fullReload()` 実行 | E-04 | ○ |
| C-08 | ランタイムエラー時に `fatal=true` で呼び出される（error イベント） | E-05 | ○ |
| C-09 | Promise rejection 時に `fatal=true` で呼び出される | E-06 | ○ |
| C-10 | リロード後にフラグはリセットされる（スクリプト再実行で初期化） | E-01 (let 宣言) | ○ |
| C-11 | 更新内容がない場合はリロードしない | E-04 (条件式) | ○ |
| C-12 | サーバーサイドルート更新または JS モジュール更新がある場合にリロード | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能は開発環境向けの状態回復機能であり、適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] `hasFatalError` フラグの設定条件が正しく記述されているか確認
- [ ] リロード実行条件が正しく記述されているか確認
- [ ] フラグリセットの仕組み（ページリロードによる再初期化）が正しく記述されているか確認
