---
generated_at: 2026-01-27 18:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **インストールコマンドの具体的なURL**: 公式サイトのURLは外部参照のため要確認
  2. **bunfig.toml設定項目**: 一部設定項目は推測に基づく
  3. **クロスコンパイルターゲット名**: 実際のターゲット指定形式の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - プロジェクト概要
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面（コマンド）一覧
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - コマンド遷移図
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `docs/code-to-docs/画面設計書/1-run.md` - runコマンド設計書
- E-08: `docs/code-to-docs/画面設計書/2-test.md` - testコマンド設計書
- E-09: `docs/code-to-docs/画面設計書/6-install.md` - installコマンド設計書
- E-10: `docs/code-to-docs/画面設計書/7-add.md` - addコマンド設計書
- E-11: `docs/code-to-docs/画面設計書/20-build.md` - buildコマンド設計書
- E-12: `src/cli/run_command.zig` - runコマンド実装
- E-13: `src/cli/test_command.zig` - testコマンド実装
- E-14: `src/cli/install_command.zig` - installコマンド実装
- E-15: `src/cli/build_command.zig` - buildコマンド実装
- E-16: `src/cli/init_command.zig` - initコマンド実装
- E-17: `src/cli/create_command.zig` - createコマンド実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bunはオールインワンランタイムである | E-01, E-02 | ○ |
| C-02 | bun runでファイル実行可能 | E-03, E-07 | ○ |
| C-03 | bun runでpackage.jsonスクリプト実行可能 | E-07 | ○ |
| C-04 | --watchオプションで自動再起動 | E-07, E-05 | ○ |
| C-05 | --hotオプションでホットリロード | E-07, E-05 | ○ |
| C-06 | bun testでJest互換テスト実行 | E-03, E-08 | ○ |
| C-07 | --coverageでカバレッジ計測 | E-08, E-02 | ○ |
| C-08 | --update-snapshotsでスナップショット更新 | E-08 | ○ |
| C-09 | bun installで依存関係インストール | E-03, E-09 | ○ |
| C-10 | bun iはinstallの短縮形 | E-03 | ○ |
| C-11 | --frozen-lockfileでlockfile固定 | E-09 | ○ |
| C-12 | --productionでdevDependencies除外 | E-09 | ○ |
| C-13 | bun addでパッケージ追加 | E-03, E-10 | ○ |
| C-14 | bun aはaddの短縮形 | E-03 | ○ |
| C-15 | -dでdevDependenciesに追加 | E-10 | ○ |
| C-16 | @versionでバージョン指定可能 | E-10 | ○ |
| C-17 | bun removeでパッケージ削除 | E-03 | ○ |
| C-18 | bun updateでパッケージ更新 | E-03 | ○ |
| C-19 | bun outdatedで古いパッケージ表示 | E-03, E-02 | ○ |
| C-20 | bun auditで脆弱性チェック | E-03, E-05 | ○ |
| C-21 | bun buildでバンドル生成 | E-03, E-11 | ○ |
| C-22 | --outdirで出力ディレクトリ指定 | E-11 | ○ |
| C-23 | --minifyでコード圧縮 | E-11 | ○ |
| C-24 | --sourcemapでソースマップ生成 | E-11 | ○ |
| C-25 | --splittingでコード分割 | E-11 | ○ |
| C-26 | --compileで単一実行ファイル生成 | E-11, E-02 | ○ |
| C-27 | --targetでターゲット指定 | E-11 | ○ |
| C-28 | bun initでプロジェクト初期化 | E-03, E-05 | ○ |
| C-29 | bun createでテンプレートから作成 | E-03, E-05 | ○ |
| C-30 | bun replでREPL起動 | E-03, E-02 | ○ |
| C-31 | bunxでパッケージ一時実行 | E-03, E-02 | ○ |
| C-32 | bun upgradeでBunアップグレード | E-03, E-05 | ○ |
| C-33 | bun helpでヘルプ表示 | E-03 | ○ |
| C-34 | bun completionsでシェル補完インストール | E-03 | ○ |
| C-35 | bun discordでDiscordサーバーを開く | E-03 | ○ |
| C-36 | .envファイル自動読み込み | E-07, E-02 | ○ |
| C-37 | TypeScript/JSXネイティブサポート | E-01, E-02 | ○ |
| C-38 | bun.lockbバイナリロックファイル | E-09, E-02 | ○ |
| C-39 | pre/postスクリプト自動実行 | E-07 | ○ |
| C-40 | --if-presentでスクリプト不在時もエラーなし | E-07 | ○ |
| C-41 | *.test.ts等のテストファイル検出 | E-08 | ○ |
| C-42 | インストールコマンド curl -fsSL https://bun.sh/install | **根拠なし** | △ |
| C-43 | bunfig.tomlの設定項目（test.coverage等） | **根拠不足** | △ |
| C-44 | クロスコンパイルターゲット指定（bun-linux-x64等） | **根拠不足** | △ |
| C-45 | Node.js、ブラウザターゲット指定 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- インストールコマンドのURL（https://bun.sh/install）は外部リソースのため、本リポジトリ内に根拠がない
  - 候補：公式ドキュメント / 公式サイト / README.md（リポジトリ外）
- bunfig.tomlの設定項目の詳細仕様はソースコード解析が必要
  - 候補：src/bunfig.zig / 公式ドキュメント
- クロスコンパイルターゲットの正確な形式は実装詳細の確認が必要
  - 候補：src/standalone.zig / src/cli/build_command.zig

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド体系、オプション、基本的な使い方
- 1: 中リスク - 設定ファイルの詳細、エラーメッセージの具体例
- 2: 高リスク - インストールURL（外部依存）、クロスコンパイル設定（実装依存）

## 6) レビュアーチェックリスト（最小）
- [ ] インストールコマンドのURLが現在も有効か確認
- [ ] bunfig.tomlの設定項目が実際に機能するか確認
- [ ] クロスコンパイルターゲットの指定形式が正しいか確認
- [ ] 各コマンドのオプションが最新バージョンと一致するか確認
- [ ] エラーメッセージの記載が実際の出力と一致するか確認
- [ ] 業務フローの順序がユーザーの実際の使用パターンと合致するか確認
