# Bun 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [インストール・初期設定](#2-インストール初期設定)
3. [基本的な使い方](#3-基本的な使い方)

**【業務フローに沿った機能】**
4. [【STEP1】プロジェクトの初期化](#4-step1プロジェクトの初期化)
5. [【STEP2-3】開発作業（コード実行・テスト）](#5-step2-3開発作業コード実行テスト)
6. [【STEP3-4】パッケージ管理](#6-step3-4パッケージ管理)
7. [【STEP4-5】ビルド・デプロイ](#7-step4-5ビルドデプロイ)

**【サポート機能】**
8. [デバッグ機能](#8-デバッグ機能)
9. [ヘルプ・補助コマンド](#9-ヘルプ補助コマンド)
10. [設定管理](#10-設定管理)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Bunとは

Bunは、速度に最適化されたオールインワンのJavaScript/TypeScriptランタイム及びツールキットです。以下の機能を単一の実行ファイル`bun`として提供します：

- **JavaScriptランタイム**: Node.jsの高速な代替として機能
- **パッケージマネージャー**: npm互換の高速パッケージ管理
- **バンドラー**: 高速なJavaScript/TypeScriptバンドル
- **テストランナー**: Jest互換のテストフレームワーク

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **開発実行** | JavaScript/TypeScriptファイルの実行、REPLによる対話的開発 |
| **パッケージ管理** | 依存関係のインストール・追加・削除・更新 |
| **ビルド** | プロジェクトのバンドル、単一実行ファイルの生成 |
| **テスト** | ユニットテストの実行、カバレッジ測定 |
| **プロジェクト管理** | プロジェクトの初期化、設定管理 |

### 1.3 業務フロー概要

本システムにおける開発業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        開発業務フロー                            │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】プロジェクトの初期化                                   │
│      ↓    bun init / bun create でプロジェクトを作成             │
│                                                                 │
│  【STEP 2】開発作業の開始                                        │
│      ↓    bun run でコードを実行、動作を確認                     │
│                                                                 │
│  【STEP 3】パッケージ管理                                        │
│      ↓    bun add / bun install で依存関係を管理                 │
│                                                                 │
│  【STEP 4】テスト実行                                            │
│      ↓    bun test でユニットテストを実行                        │
│                                                                 │
│  【STEP 5】ビルド・デプロイ                                      │
│           bun build でプロダクションビルドを生成                  │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | コード実行、テスト実行、パッケージ追加、ビルド作成 |
| **DevOps/CI担当** | 依存関係インストール（frozen-lockfile）、本番ビルド、テスト自動化 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| bun init / create | プロジェクトの初期化・作成 | STEP 1 |
| bun run | ファイル・スクリプトの実行 | STEP 2 |
| bun install / add | パッケージのインストール・追加 | STEP 3 |
| bun test | テストの実行 | STEP 4 |
| bun build | プロジェクトのビルド | STEP 5 |
| bun upgrade | Bun自体のアップグレード | 随時利用 |
| bun help | ヘルプの表示 | 随時参照 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者 | 日常の開発作業でBunを使用するユーザー |
| DevOps担当 | CI/CD環境でBunを使用してビルド・テストを自動化するユーザー |
| オープンソース貢献者 | Bunの開発に参加するユーザー |

### 1.6 対応OS・環境

推奨環境：
- macOS（最新版）
- Linux（主要ディストリビューション）
- Windows（Windows 10以降）
- WSL2（Windows Subsystem for Linux 2）

---

## 2. インストール・初期設定

### 2.1 インストール方法

#### macOS / Linux

ターミナルで以下のコマンドを実行します：

```bash
curl -fsSL https://bun.sh/install | bash
```

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| インストールスクリプト | 上記のcurlコマンド |

インストール完了後、新しいターミナルを開くか、以下を実行してPATHを更新します：

```bash
source ~/.bashrc  # または ~/.zshrc
```

#### Windows

PowerShellで以下のコマンドを実行します：

```powershell
powershell -c "irm bun.sh/install.ps1 | iex"
```

### 2.2 インストール確認

以下のコマンドでBunが正しくインストールされたことを確認します：

```bash
bun --version
```

バージョン番号（例：1.0.0）が表示されれば成功です。

### 2.3 アップグレード方法

Bunを最新バージョンにアップグレードするには：

```bash
bun upgrade
```

---

## 3. 基本的な使い方

### 3.1 コマンド構造

Bunのコマンドは以下の形式で実行します：

```bash
bun <コマンド> [オプション] [引数]
```

### 3.2 主要コマンド一覧

| コマンド | 短縮形 | 説明 |
|---------|-------|------|
| `bun run` | - | ファイルまたはスクリプトを実行 |
| `bun test` | - | テストを実行 |
| `bun install` | `bun i` | 依存関係をインストール |
| `bun add` | `bun a` | パッケージを追加 |
| `bun remove` | `bun rm` | パッケージを削除 |
| `bun build` | - | プロジェクトをビルド |
| `bun init` | - | プロジェクトを初期化 |
| `bun create` | `bun c` | テンプレートからプロジェクト作成 |

### 3.3 ヘルプの表示

各コマンドのヘルプを表示するには：

```bash
bun --help           # 全体のヘルプ
bun <コマンド> --help  # 特定コマンドのヘルプ
```

---

## 4. 【STEP1】プロジェクトの初期化

> **業務フローでの位置**: 新規開発を開始する際の最初のステップです。プロジェクトの基盤となるファイル構造を作成します。

### 4.1 空のプロジェクトを初期化する

**業務シーン**: 新しいプロジェクトを一から始める場合

**操作手順**:

1. プロジェクト用のディレクトリを作成し、移動します

```bash
mkdir my-project
cd my-project
```

2. 「bun init」コマンドを実行します

```bash
bun init
```

3. 対話的なプロンプトに従って設定を入力します

**入力項目：**

| 項目 | 説明 | デフォルト値 |
|------|------|-------------|
| package name | パッケージ名 | ディレクトリ名 |
| entry point | エントリーポイント | index.ts |

4. 以下のファイルが生成されます：
   - `package.json` - プロジェクト設定
   - `tsconfig.json` - TypeScript設定
   - `index.ts` - エントリーポイント

**注意点・Tips**:
- `-y`オプションを付けると、対話なしでデフォルト値で初期化されます

### 4.2 テンプレートからプロジェクトを作成する

**業務シーン**: React、Next.js等のフレームワークを使ったプロジェクトを開始する場合

**操作手順**:

1. 「bun create」コマンドでテンプレートを指定します

```bash
bun create <テンプレート名> <プロジェクト名>
```

**例：**

```bash
# Reactアプリを作成
bun create react my-react-app

# Next.jsアプリを作成
bun create next-app my-next-app

# Viteプロジェクトを作成
bun create vite my-vite-app
```

2. 作成されたディレクトリに移動します

```bash
cd my-react-app
```

3. 依存関係をインストールします（自動でインストールされない場合）

```bash
bun install
```

**次のステップ**: 依存関係のインストールが完了したら、STEP2の開発作業に進みます。

---

## 5. 【STEP2-3】開発作業（コード実行・テスト）

> **業務フローでの位置**: プロジェクト初期化後、日常的な開発作業を行うステップです。

### 5.1 ファイルを直接実行する

**業務シーン**: TypeScript/JavaScriptファイルを実行して動作確認する場合

**操作手順**:

1. 実行したいファイルを指定して「bun run」または「bun」を実行します

```bash
bun run index.ts
# または
bun index.ts
```

**入力項目：**

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| ファイルパス | string | はい | 実行するファイル |
| --watch / -w | flag | いいえ | ファイル変更時に自動再起動 |
| --hot | flag | いいえ | ホットリロードを有効化 |

**例：**

```bash
# 基本的な実行
bun run src/app.ts

# 監視モードで実行（ファイル変更時に自動再起動）
bun run --watch src/app.ts

# ホットリロードモードで実行
bun run --hot src/server.ts
```

### 5.2 package.jsonスクリプトを実行する

**業務シーン**: 定義済みの開発コマンド（dev、start等）を実行する場合

**前提条件**: package.jsonにscriptsが定義されていること

**操作手順**:

1. package.jsonのscriptsセクションを確認します

```json
{
  "scripts": {
    "dev": "bun run --hot src/index.ts",
    "start": "bun run src/index.ts",
    "build": "bun build src/index.ts --outdir dist"
  }
}
```

2. 「bun run」でスクリプト名を指定して実行します

```bash
bun run dev
```

**注意点・Tips**:
- `pre`と`post`スクリプトは自動的に実行されます（例：`prebuild`、`postbuild`）
- `--if-present`オプションを付けると、スクリプトが存在しない場合でもエラーになりません

### 5.3 テストを実行する

**業務シーン**: コードの品質を確認するためにユニットテストを実行する場合

**前提条件**: テストファイル（*.test.ts、*.spec.ts等）が存在すること

**操作手順**:

1. 「bun test」を実行します

```bash
bun test
```

2. テスト結果が表示されます

```
bun test v1.0.0

src/utils.test.ts:
✓ add function > should add two numbers [0.50ms]
✓ add function > should handle negative numbers [0.10ms]

 2 pass
 0 fail
 2 tests | 0 skip
```

**入力項目：**

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| ファイルパターン | string[] | いいえ | テストファイルのパターン |
| -t / --test-name-pattern | string | いいえ | テスト名のフィルタ |
| --timeout | number | いいえ | タイムアウト（デフォルト5000ms） |
| --watch | flag | いいえ | ファイル変更時に自動再実行 |
| --coverage | flag | いいえ | カバレッジを計測 |
| --update-snapshots | flag | いいえ | スナップショットを更新 |

**例：**

```bash
# 特定のファイルをテスト
bun test src/utils.test.ts

# 特定のテスト名にマッチするものだけ実行
bun test -t "should add"

# カバレッジ付きでテスト
bun test --coverage

# 監視モードでテスト
bun test --watch
```

**関連画面**: スナップショットテストを更新する場合は`--update-snapshots`オプションを使用します。

---

## 6. 【STEP3-4】パッケージ管理

> **業務フローでの位置**: 開発中にライブラリを追加・管理するステップです。

### 6.1 依存関係をインストールする

**業務シーン**: プロジェクトをクローンした後、または新しい環境でセットアップする場合

**操作手順**:

1. プロジェクトディレクトリで「bun install」を実行します

```bash
bun install
```

2. インストール完了のサマリーが表示されます

```
bun install v1.0.0

Installed 150 packages in 500ms
```

**入力項目：**

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| --production / -p | flag | いいえ | devDependenciesを除外 |
| --frozen-lockfile | flag | いいえ | lockfileを更新しない（CI向け） |
| --force | flag | いいえ | キャッシュを無視して再インストール |
| --ignore-scripts | flag | いいえ | ライフサイクルスクリプトを実行しない |

**CI/CD環境での使用例**:

```bash
# lockfileに基づいて厳密にインストール
bun install --frozen-lockfile
```

### 6.2 パッケージを追加する

**業務シーン**: 新しいライブラリをプロジェクトに追加する場合

**操作手順**:

1. 「bun add」でパッケージ名を指定します

```bash
bun add <パッケージ名>
```

**例：**

```bash
# 最新バージョンを追加
bun add react

# 特定バージョンを追加
bun add react@18.2.0

# 開発用依存関係として追加
bun add -d typescript

# 複数パッケージを同時に追加
bun add react react-dom
```

**入力項目：**

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| パッケージ名 | string[] | はい | 追加するパッケージ（@version指定可） |
| -d / --dev / -D | flag | いいえ | devDependenciesに追加 |
| -E / --exact | flag | いいえ | 正確なバージョンで追加（^なし） |

### 6.3 パッケージを削除する

**業務シーン**: 不要になったライブラリを削除する場合

**操作手順**:

1. 「bun remove」でパッケージ名を指定します

```bash
bun remove <パッケージ名>
```

**例：**

```bash
bun remove lodash
```

### 6.4 パッケージを更新する

**業務シーン**: 依存パッケージを最新バージョンに更新する場合

**操作手順**:

1. 「bun update」を実行します

```bash
bun update
```

**例：**

```bash
# 全パッケージを更新
bun update

# 特定パッケージのみ更新
bun update react
```

### 6.5 古いパッケージを確認する

**業務シーン**: 更新可能なパッケージを確認する場合

**操作手順**:

1. 「bun outdated」を実行します

```bash
bun outdated
```

2. 更新可能なパッケージの一覧が表示されます

### 6.6 脆弱性をチェックする

**業務シーン**: セキュリティの観点から依存パッケージを監査する場合

**操作手順**:

1. 「bun audit」を実行します

```bash
bun audit
```

2. 脆弱性がある場合は詳細が表示されます

---

## 7. 【STEP4-5】ビルド・デプロイ

> **業務フローでの位置**: 開発完了後、プロダクション向けにアプリケーションをビルドするステップです。

### 7.1 プロジェクトをビルドする

**業務シーン**: 本番環境用にJavaScript/TypeScriptをバンドルする場合

**操作手順**:

1. 「bun build」でエントリーポイントを指定します

```bash
bun build src/index.ts --outdir dist
```

2. ビルド結果のサマリーが表示されます

```
Bundled 50 module(s) in 100ms

  dist/index.js     150KB  (entry point)
  dist/chunk-abc.js  50KB  (chunk)
```

**入力項目：**

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| エントリーポイント | string[] | はい | バンドル対象ファイル |
| --outdir | string | いいえ | 出力ディレクトリ |
| --outfile | string | いいえ | 出力ファイル名（単一ファイル時） |
| --target | string | いいえ | 出力ターゲット（browser/bun/node） |
| --minify | flag | いいえ | コードを圧縮 |
| --sourcemap | string | いいえ | ソースマップ生成 |
| --splitting | flag | いいえ | コード分割を有効化 |

**例：**

```bash
# 基本的なビルド
bun build src/index.ts --outdir dist

# 本番用（圧縮あり）
bun build src/index.ts --outdir dist --minify

# ソースマップ付き
bun build src/index.ts --outdir dist --sourcemap=external

# Node.js向けビルド
bun build src/index.ts --outdir dist --target=node

# コード分割あり
bun build src/index.ts --outdir dist --splitting
```

### 7.2 単一実行ファイルを生成する

**業務シーン**: Bunがインストールされていない環境でも実行できるスタンドアロンアプリを作成する場合

**操作手順**:

1. 「bun build」に`--compile`オプションを付けて実行します

```bash
bun build src/index.ts --compile --outfile myapp
```

2. 実行可能ファイルが生成されます

```bash
./myapp  # 生成されたファイルを直接実行
```

**入力項目：**

| 項目 | 型 | 必須 | 説明 |
|------|-----|------|------|
| --compile | flag | はい | 単一実行ファイルを生成 |
| --outfile | string | はい | 出力ファイル名 |
| --minify | flag | いいえ | コードを圧縮 |

**注意点・Tips**:
- `--compile`と`--outdir`は併用できません
- クロスコンパイル対応：`--target=bun-linux-x64`等でターゲット指定可能

---

## 8. デバッグ機能

### 8.1 REPLを使用する

**業務シーン**: 対話的にJavaScriptを実行して動作を確認する場合

**操作手順**:

1. 「bun repl」を実行します

```bash
bun repl
```

2. JavaScriptコードを入力して実行します

```javascript
> const x = 1 + 2
> x
3
> await fetch('https://example.com').then(r => r.text())
```

### 8.2 bunxでパッケージを一時実行する

**業務シーン**: インストールせずにパッケージのCLIツールを実行する場合

**操作手順**:

1. 「bunx」でパッケージ名とコマンドを指定します

```bash
bunx <パッケージ名> [引数]
```

**例：**

```bash
# Prettierでフォーマット
bunx prettier --write src/

# create-react-appでプロジェクト作成
bunx create-react-app my-app

# TypeScriptコンパイラを実行
bunx tsc --init
```

---

## 9. ヘルプ・補助コマンド

### 9.1 ヘルプを表示する

**操作手順**:

```bash
# 全体のヘルプ
bun help

# 特定コマンドのヘルプ
bun run --help
bun test --help
bun build --help
```

### 9.2 シェル補完をインストールする

**業務シーン**: コマンドの自動補完を有効にする場合

**操作手順**:

```bash
bun completions
```

指示に従ってシェル設定ファイルを更新します。

### 9.3 コミュニティリソースにアクセスする

```bash
# Discordサーバーを開く
bun discord

# フィードバックを送信
bun feedback
```

---

## 10. 設定管理

### 10.1 bunfig.tomlで設定を管理する

**業務シーン**: プロジェクト固有のBun設定を行う場合

プロジェクトルートに`bunfig.toml`ファイルを作成します：

```toml
# テスト設定
[test]
coverage = true
timeout = 10000

# インストール設定
[install]
production = false

# バンドル設定
[build]
minify = true
sourcemap = "external"
```

### 10.2 環境変数を使用する

Bunは`.env`ファイルを自動的に読み込みます：

1. プロジェクトルートに`.env`ファイルを作成します

```
DATABASE_URL=postgres://localhost/mydb
API_KEY=your-api-key
```

2. コード内で`process.env`または`Bun.env`でアクセスします

```typescript
const dbUrl = process.env.DATABASE_URL;
// または
const dbUrl = Bun.env.DATABASE_URL;
```

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】プロジェクトの初期化 → 4章参照
    ↓
【STEP 2】開発作業の開始 → 5章参照
    ↓
【STEP 3】パッケージ管理 → 6章参照
    ↓
【STEP 4】テスト実行 → 5章参照
    ↓
【STEP 5】ビルド・デプロイ → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【開発者】STEP1: プロジェクトの初期化

新規開発を開始する際、まずプロジェクトを初期化します。

```bash
# 空のプロジェクトを作成
mkdir my-project && cd my-project
bun init

# または、テンプレートから作成
bun create react my-react-app
cd my-react-app
bun install
```

### 11.2 【開発者】STEP2: 開発作業の開始

コードを書いて実行し、動作を確認します。

```bash
# 開発サーバーを起動（package.jsonにdevスクリプトがある場合）
bun run dev

# または、ファイルを直接実行
bun run src/index.ts

# 監視モードで開発（ファイル変更時に自動再起動）
bun run --watch src/index.ts
```

### 11.3 【開発者】STEP3: パッケージの追加

開発中に必要なライブラリを追加します。

```bash
# 本番用パッケージを追加
bun add express

# 開発用パッケージを追加
bun add -d @types/express typescript
```

### 11.4 【開発者】STEP4: テストの実行

コードの品質を確認するためにテストを実行します。

```bash
# テストを実行
bun test

# 監視モードでテスト（TDD向け）
bun test --watch

# カバレッジ付きテスト
bun test --coverage
```

### 11.5 【DevOps】STEP5: CI/CDでのビルド・デプロイ

CI/CD環境での典型的なコマンド：

```bash
# 依存関係を厳密にインストール
bun install --frozen-lockfile

# テストを実行
bun test

# 本番ビルドを生成
bun build src/index.ts --outdir dist --minify
```

---

## 12. よくある質問と対処法

### 12.1 インストールに関するQ&A

**Q: インストール後、bunコマンドが見つかりません**

A: 以下を確認してください：
1. 新しいターミナルを開いてください
2. PATHが正しく設定されているか確認します：
   ```bash
   echo $PATH | grep bun
   ```
3. 必要に応じてシェル設定ファイル（.bashrc、.zshrc）を再読み込みします：
   ```bash
   source ~/.bashrc
   ```

**Q: Bunをアップグレードできません**

A: 以下を試してください：
```bash
# 通常のアップグレード
bun upgrade

# 強制的にアップグレード
curl -fsSL https://bun.sh/install | bash
```

### 12.2 パッケージ管理に関するQ&A

**Q: bun installが遅いです**

A: 以下を確認してください：
1. ネットワーク接続を確認
2. `--force`オプションでキャッシュを再構築：
   ```bash
   bun install --force
   ```

**Q: package.jsonがないと言われます**

A: プロジェクトディレクトリにいることを確認し、なければ初期化します：
```bash
bun init -y
```

### 12.3 テストに関するQ&A

**Q: テストファイルが見つかりません**

A: テストファイルの命名規則を確認してください：
- `*.test.ts` / `*.test.js`
- `*.spec.ts` / `*.spec.js`
- `__tests__/`ディレクトリ内のファイル

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Module not found "{file}" | 指定ファイルが存在しない | ファイルパスを確認 |
| Script not found "{script}" | package.jsonにスクリプトがない | package.jsonを確認 |
| No package.json found | package.jsonが見つからない | `bun init`で初期化 |
| Failed to resolve "{package}" | パッケージの依存関係解決失敗 | パッケージ名を確認、`bun install`を再実行 |
| Network error | ネットワーク接続エラー | インターネット接続を確認 |
| Lockfile does not match | frozen-lockfile時のlockfile不一致 | `bun install`でlockfileを更新 |

### 13.2 よくあるトラブルと解決方法

**トラブル: TypeScriptの型エラーが解決されない**

解決方法：
1. 型定義パッケージがインストールされているか確認
   ```bash
   bun add -d @types/node
   ```
2. tsconfig.jsonの設定を確認

**トラブル: node_modulesが壊れている**

解決方法：
```bash
rm -rf node_modules bun.lockb
bun install
```

**トラブル: ビルドエラーが発生する**

解決方法：
1. エラーメッセージを確認
2. 依存パッケージが正しくインストールされているか確認
3. `--verbose`オプションで詳細情報を確認
   ```bash
   bun build src/index.ts --outdir dist --verbose
   ```

### 13.3 サポートへの連絡方法

問題が解決しない場合：

1. **公式ドキュメント**: https://bun.sh/docs
2. **GitHub Issues**: https://github.com/oven-sh/bun/issues
3. **Discord**: `bun discord`コマンドでアクセス
4. **フィードバック**: `bun feedback`コマンドでフィードバック送信

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-27 | 初版作成 |

---

*本マニュアルは、Bunのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
