---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースにソースコード根拠あり
  2. SLA/性能目標の明示的定義が無いため、合格基準は実装コードから推定
  3. 非機能要件の優先度はテスト内容の重要度から判断

## 2) 参照した情報（Evidence一覧）

- E-01: `bench/snippets/http-hello.js` - HTTP Hello World ベンチマーク
- E-02: `bench/stress/hot-reload-files/stress-test.ts` - Hot Reload ストレステスト（1000回リロード、メモリ監視）
- E-03: `test/js/bun/jsc-stress/jsc-stress.test.ts` - JSC JIT ストレステスト定義
- E-04: `test/js/bun/jsc-stress/fixtures/wasm/` - WASM BBQ/OMG テストフィクスチャ
- E-05: `test/js/bun/glob/stress.test.ts` - Glob ストレステスト（1000回並行スキャン、10000回マッチ）
- E-06: `test/js/third_party/body-parser/express-memory-leak.test.ts` - Express メモリリークテスト（50000リクエスト、1.5倍閾値）
- E-07: `bench/crypto/asymmetricSign.js` - RSA署名ベンチマーク
- E-08: `test/bake/dev/stress.test.ts` - Dev Server ストレステスト
- E-09: `test/js/bun/cookie/cookie-security-fuzz.test.ts` - Cookie セキュリティFuzzテスト
- E-10: `test/js/bun/css/css-fuzz.test.ts` - CSS Parser Fuzzテスト（構文/構造/エンコーディング/メモリ）
- E-11: `test/js/web/fetch/fetch-tls-abortsignal-timeout.test.ts` - Fetch TLS タイムアウトテスト
- E-12: `test/js/third_party/socket.io/socket.io-socket-timeout.test.ts` - Socket.io タイムアウトテスト
- E-13: `test/js/node/http/client-timeout-error.test.ts` - HTTP Client タイムアウトテスト
- E-14: `test/cli/test/test-timeout-behavior.test.ts` - Test Runner タイムアウトテスト
- E-15: `test/js/node/perf_hooks/perf_hooks.test.ts` - Node.js perf_hooks 互換性テスト
- E-16: `test/js/bun/perf_hooks/histogram.test.ts` - Histogram API テスト
- E-17: `test/js/deno/performance/performance.test.ts` - Deno Performance API 互換性テスト
- E-18: `test/js/node/http/node-http-maxHeaderSize.test.ts` - HTTP Max Header Size テスト
- E-19: `test/js/bun/websocket/websocket-server.test.ts` - WebSocket Server テスト
- E-20: `bench/websocket-server/chat-server.bun.js` - WebSocket Chat ベンチマーク（32クライアント）
- E-21: `test/js/bun/perf/static-initializers.test.ts` - 静的初期化子性能テスト
- E-22: `test/js/node/http/node-http-backpressure.test.ts` - HTTP バックプレッシャーテスト
- E-23: `test/js/node/http/node-http-backpressure-max.test.ts` - HTTP バックプレッシャー最大値テスト
- E-24: `test/js/node/tls/node-tls-cert.test.ts` - TLS 証明書テスト
- E-25: `test/js/node/tls/test-system-ca-https.test.ts` - システムCA証明書テスト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP Hello World レスポンス性能テスト（200,000リクエスト） | E-01 | ○ |
| C-02 | Hot Reload ストレステスト（1,000回リロード） | E-02 | ○ |
| C-03 | JSC JIT ストレステスト | E-03 | ○ |
| C-04 | WASM BBQ/OMG ストレステスト | E-04 | ○ |
| C-05 | Glob.scan ストレステスト（1,000回並行） | E-05 | ○ |
| C-06 | Glob.match ストレステスト（10,000回） | E-05 | ○ |
| C-07 | Express メモリリークテスト（Empty Response） | E-06 | ○ |
| C-08 | Express メモリリークテスト（Request Body） | E-06 | ○ |
| C-09 | Express メモリリークテスト（Response Body） | E-06 | ○ |
| C-10 | Express メモリリークテスト（Aborted Requests） | E-06 | ○ |
| C-11 | RSA署名ベンチマーク | E-07 | ○ |
| C-12 | Dev Server ストレステスト | E-08 | ○ |
| C-13 | Cookie インジェクション攻撃耐性テスト | E-09 | ○ |
| C-14 | Cookie ヘッダ分割攻撃耐性テスト | E-09 | ○ |
| C-15 | Cookie ReDoS攻撃耐性テスト（1秒未満） | E-09 | ○ |
| C-16 | Cookie SQLインジェクション処理テスト | E-09 | ○ |
| C-17 | Cookie プロトタイプ汚染攻撃耐性テスト | E-09 | ○ |
| C-18 | Cookie NULLバイトインジェクション耐性テスト | E-09 | ○ |
| C-19 | Cookie Unicode ホモグラフ攻撃耐性テスト | E-09 | ○ |
| C-20 | CSS Parser 構文エラー Fuzz テスト（1000イテレーション） | E-10 | ○ |
| C-21 | CSS Parser 構造エラー Fuzz テスト（1000イテレーション） | E-10 | ○ |
| C-22 | CSS Parser エンコーディングエラー Fuzz テスト（500イテレーション） | E-10 | ○ |
| C-23 | CSS Parser メモリストレステスト（500MB閾値） | E-10 | ○ |
| C-24 | Fetch TLS AbortSignal タイムアウトテスト | E-11 | ○ |
| C-25 | Socket.io タイムアウトテスト | E-12 | ○ |
| C-26 | HTTP Client タイムアウトテスト | E-13 | ○ |
| C-27 | Test Runner タイムアウト動作テスト | E-14 | ○ |
| C-28 | Performance API 互換性テスト（Node.js） | E-15 | ○ |
| C-29 | Histogram API 互換性テスト | E-16 | ○ |
| C-30 | Performance API Deno互換性テスト | E-17 | ○ |
| C-31 | HTTP Max Header Size テスト（431ステータス） | E-18 | ○ |
| C-32 | WebSocket Server 並行接続テスト | E-19 | ○ |
| C-33 | WebSocket Chat Server ベンチマーク（32クライアント） | E-20 | ○ |
| C-34 | Static Initializers 性能テスト | E-21 | ○ |
| C-35 | WebSocket 閉じた接続操作テスト | E-19 | ○ |
| C-36 | HTTP Backpressure テスト | E-22 | ○ |
| C-37 | HTTP Backpressure Max テスト | E-23 | ○ |
| C-38 | TLS証明書テスト | E-24 | ○ |
| C-39 | システムCA証明書テスト | E-25 | ○ |
| C-40 | Performance Histogram 統計精度テスト | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）

- 明示的なSLA定義書やパフォーマンス目標定義書は存在しない
  - 合格基準はソースコード内のアサーションから抽出
  - 候補：性能要件定義書 / SLA定義書 / パフォーマンス目標設計書
- 可用性要件（99.9%等）の明示的定義なし
  - タイムアウト関連テストは存在するが、可用性目標値は未定義
- スケーラビリティテストケースの明示的定義なし
  - ストレステストは存在するが、スケールアウト時の目標は未定義

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全テストケースにソースコード根拠あり
- 1: 中リスク - 合格基準の一部はコード内アサーションからの推定値
- 1: 中リスク - 性能目標の公式定義がないため、将来の変更で基準が変わる可能性

## 6) レビュアーチェックリスト（最小）

- [ ] 各テストケースの合格基準が妥当か確認
- [ ] 優先度の判断が適切か確認
- [ ] テスト種別の分類が適切か確認
- [ ] 不足しているテストカテゴリがないか確認（例：負荷テスト、耐久テスト）
- [ ] セキュリティテストの網羅性を確認
- [ ] 互換性テストのカバレッジを確認
