---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **稼働率要件**：具体的なSLA数値がコードから特定不可
  2. **RTO/RPO要件**：コードレベルでは明示的な定義なし
  3. **プラットフォーム対応詳細**：各プラットフォーム固有の制約が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli.zig` - テストオプション、タイムアウト設定
- E-02: `src/http/AsyncHTTP.zig` - HTTPクライアント設定、同時リクエスト数
- E-03: `src/http.zig` - HTTPクライアント実装、リダイレクト、証明書検証
- E-04: `src/sql/postgres/PostgresSQLConnection.zig` - PostgreSQL接続タイムアウト設定
- E-05: `src/sql/mysql/js/JSMySQLConnection.zig` - MySQL接続タイムアウト設定
- E-06: `src/valkey/valkey.zig` - Valkey接続タイムアウト設定
- E-07: `src/bun.js/api/server.zig` - HTTPサーバー実装
- E-08: `src/bun.js/webcore/fetch.zig` - Fetch API実装
- E-09: `src/boringssl.zig` - TLS/SSL実装
- E-10: `src/allocators/MimallocArena.zig` - メモリアロケータ実装
- E-11: `src/analytics.zig` - アナリティクス・機能追跡
- E-12: `src/bun.js/api/bun/socket.zig` - ソケット実装、TLS対応
- E-13: `src/http/FetchRequestMode.zig` - CORS対応
- E-14: `src/deps/uws.zig` - uWebSockets設定
- E-15: `src/shell/subproc.zig` - シェルサブプロセスバッファ設定
- E-16: `src/install/PackageInstaller.zig` - ライフサイクルスクリプト並行処理
- E-17: `src/bun.js/webcore/fetch/FetchTasklet.zig` - Fetch実装詳細

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストタイムアウトデフォルト5秒 | E-01 (`default_timeout_ms: u32 = 5 * std.time.ms_per_s`) | ○ |
| C-02 | 同時HTTPリクエスト数256 | E-02 (`max_simultaneous_requests = std.atomic.Value(usize).init(256)`) | ○ |
| C-03 | BUN_CONFIG_MAX_HTTP_REQUESTS環境変数 | E-02 (`env.get("BUN_CONFIG_MAX_HTTP_REQUESTS")`) | ○ |
| C-04 | HTTPヘッダー最大16KB | E-03 (`max_http_header_size: usize = 16 * 1024`) | ○ |
| C-05 | リダイレクト最大127回 | E-03 (`default_redirect_count = 127`) | ○ |
| C-06 | リダイレクトURL最大128KB | E-03 (`MAX_REDIRECT_URL_LENGTH = 128 * 1024`) | ○ |
| C-07 | PostgreSQL接続タイムアウト設定可能 | E-04 (`connection_timeout_ms: u32 = 0`) | ○ |
| C-08 | PostgreSQLアイドルタイムアウト設定可能 | E-04 (`idle_timeout_interval_ms: u32 = 0`) | ○ |
| C-09 | MySQL接続タイムアウト設定可能 | E-05 (`connection_timeout_ms: u32 = 0`) | ○ |
| C-10 | Valkeyデフォルト接続タイムアウト10秒 | E-06 (`connection_timeout_ms: u32 = 10000`) | ○ |
| C-11 | reject_unauthorizedデフォルトtrue | E-03 (`reject_unauthorized: bool = true`) | ○ |
| C-12 | SSL verify_ca/verify_fullモード | E-04, E-05 (`verify_ca = 3, verify_full = 4`) | ○ |
| C-13 | BoringSSL使用 | E-09 (`boring.SSL_library_init()`) | ○ |
| C-14 | CORS no-cors/corsモード | E-13 (`@"no-cors", cors`) | ○ |
| C-15 | CSRF機能サポート | E-11 (`csrf_verify`, `csrf_generate`) | ○ |
| C-16 | mimalloc使用 | E-10 (`mimalloc.mi_heap_malloc`) | ○ |
| C-17 | スコープ付きログシステム | E-02等 (`Output.scoped(.fetch, .visible)`) | ○ |
| C-18 | DO_NOT_TRACK環境変数対応 | E-11 (`bun.env_var.DO_NOT_TRACK.get()`) | ○ |
| C-19 | ライフサイクルスクリプト並行数制御 | E-16 (`max_concurrent_lifecycle_scripts`) | ○ |
| C-20 | テスト最大並行数20 | E-01 (`max_concurrency: u32 = 20`) | ○ |
| C-21 | シェルバッファ4MB | E-15 (`default_max_buffer_size = 1024 * 1024 * 4`) | ○ |
| C-22 | タイムアウト粒度4秒 | E-14 (`LIBUS_TIMEOUT_GRANULARITY = 4`) | ○ |
| C-23 | disable_timeout設定 | E-02 (`disable_timeout: ?bool = null`) | ○ |
| C-24 | disable_keepalive設定 | E-02 (`disable_keepalive: ?bool = null`) | ○ |
| C-25 | preconnect機能 | E-02 (`preconnect` function) | ○ |
| C-26 | HTTPプロキシ対応 | E-02, E-03 (`http_proxy: ?URL = null`) | ○ |
| C-27 | Workerスレッド追跡 | E-11 (`workers_spawned`, `workers_terminated`) | ○ |
| C-28 | 機能使用状況追跡 | E-11 (`Features` struct) | ○ |
| C-29 | CPUプロファイリング | E-01 (`cpu_prof` struct) | ○ |
| C-30 | ヒーププロファイリング | E-01 (`heap_prof` struct) | ○ |
| C-31 | デバッガーサポート | E-01 (`Debugger = union(enum)`) | ○ |
| C-32 | GC明示実行 | E-01 (`expose_gc: bool = false`) | ○ |
| C-33 | 稼働率目標値 | **根拠なし** | △ |
| C-34 | RTO/RPO目標値 | **根拠なし** | △ |
| C-35 | 全プラットフォーム対応詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **稼働率・RTO・RPO要件**：
  - ランタイムとしての設計であり、明示的なSLA定義がコードに存在しない
  - 候補：運用ドキュメント / SLA定義書 / 障害対応フロー文書
- **プラットフォーム固有制約**：
  - 各プラットフォームでの動作差異がコードレベルで分散している
  - 候補：プラットフォーム別テスト結果 / CI/CD設定 / リリースノート

## 5) リスクフラグ（レビュー観点）
- **0 - 低リスク**: 性能要件（タイムアウト、スループット）の数値 - コードから直接確認可能
- **0 - 低リスク**: セキュリティ要件（TLS設定）- BoringSSL実装から確認可能
- **1 - 中リスク**: メモリ管理詳細 - mimallocの設定がプラットフォーム依存の可能性
- **2 - 高リスク**: 可用性要件（稼働率等）- 明示的な定義がなく運用環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件の数値がプロジェクト要件と整合しているか確認
- [ ] セキュリティ要件（TLS設定、CORS）が組織のセキュリティポリシーと合致しているか確認
- [ ] 同時接続数・バッファサイズの制限値がインフラ要件と整合しているか確認
- [ ] 環境変数による設定項目が運用チームに周知されているか確認
- [ ] 可用性要件について別途SLA定義が必要かどうか判断
- [ ] プラットフォーム固有の制約事項を別途調査する必要があるか判断
