# 非機能要件定義書

## 概要

本ドキュメントは、Bunランタイム（all-in-one JavaScript runtime & toolkit）の非機能要件を定義します。Bunは速度を重視した設計で、バンドラー、テストランナー、Node.js互換パッケージマネージャーを統合したJavaScriptランタイムです。主にZig言語で実装され、JavaScriptCore（WebKit）エンジンを使用しています。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| HTTPリクエスト処理 | タイムアウト設定可能 | `disable_timeout`オプションで制御可能 |
| テスト実行タイムアウト | 5秒（デフォルト） | `default_timeout_ms`で設定可能 |
| データベース接続タイムアウト（PostgreSQL/MySQL） | 設定可能 | `connection_timeout_ms`パラメータで制御 |
| データベースアイドルタイムアウト | 設定可能 | `idle_timeout_interval_ms`パラメータで制御 |
| Valkeyコネクションタイムアウト | 10秒（デフォルト） | `connection_timeout_ms: u32 = 10000` |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時HTTPリクエスト数 | 256（デフォルト） | `BUN_CONFIG_MAX_HTTP_REQUESTS`環境変数で1〜65535の範囲で設定可能 |
| HTTPリダイレクト最大回数 | 127回 | `default_redirect_count = 127` |
| 同時ライフサイクルスクリプト数 | 1（デフォルト） | `max_concurrent_lifecycle_scripts`で設定可能 |
| テスト並行実行数 | 20（デフォルト） | `max_concurrency: u32 = 20` |
| HTTPヘッダー最大サイズ | 16KB | `max_http_header_size: usize = 16 * 1024` |
| リダイレクトURL最大長 | 128KB | `MAX_REDIRECT_URL_LENGTH = 128 * 1024` |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | ランタイムとして継続稼働 | クラッシュハンドラーによる障害レポート機能あり |
| データベース接続ライフタイム | 設定可能 | `max_lifetime_interval_ms`パラメータで制御 |
| コネクションプール | データベース接続でサポート | PostgreSQL/MySQL/Valkeyで利用可能 |
| Keep-Alive | HTTPクライアントでサポート | `disable_keepalive`オプションで制御可能 |
| Preconnect機能 | HTTPクライアントでサポート | `fetch.preconnect`APIで事前接続可能 |

## セキュリティ要件

### TLS/SSL対応

- **TLSプロトコル**: BoringSSL（GoogleのOpenSSLフォーク）を使用
- **証明書検証**: `reject_unauthorized`オプションで制御可能（デフォルト: true）
- **証明書検証モード**:
  - `verify_ca`: CA証明書による検証
  - `verify_full`: 完全な証明書検証（ホスト名含む）
- **ALPN（Application-Layer Protocol Negotiation）**: サポート
- **サーバー識別子検証**: `checkServerIdentity`コールバックでカスタム検証可能

### CORS対応

- **FetchRequestMode**: `cors`, `no-cors`, `navigate`, `same-origin`, `websocket`をサポート
- **HTTP/2ヘッダー**: Access-Control関連ヘッダーをサポート
  - `access-control-allow-credentials`
  - `access-control-allow-headers`
  - `access-control-allow-methods`
  - `access-control-allow-origin`
  - `access-control-expose-headers`
  - `access-control-max-age`

### 認証・認可

- **CSRF保護**: `csrf_verify`および`csrf_generate`機能を提供
- **HTTPプロキシ**: プロキシ経由のHTTP/HTTPS通信をサポート
- **データベース認証**: PostgreSQL/MySQL/Valkeyの認証をサポート

## 拡張性要件

### メモリ管理

- **カスタムアロケータ**: mimalloc（Microsoft製高性能アロケータ）を使用
- **ヒープ管理**: スレッドローカルヒープによる効率的なメモリ管理
- **ガベージコレクション**: JavaScriptCoreのGCを使用、`gc()`関数で明示的なGC実行可能（`--expose-gc`オプション時）

### 並行処理

- **スレッドプール**: パッケージインストール、HTTPクライアントなどで使用
- **イベントループ**: 非同期I/O処理を効率的に実行
- **ワーカースレッド**: Web Workers APIをサポート

### モジュラー設計

- **プラグインシステム**: バンドラーでプラグインをサポート
- **N-API互換**: Node.jsネイティブモジュールとの互換性
- **V8 API互換**: 一部のV8 C++ APIとの互換性

## 保守性要件

### デバッグ機能

- **デバッガー**: リモートデバッグをサポート（`--inspect`オプション）
- **CPUプロファイリング**: `--cpu-prof`オプションでCPUプロファイル取得可能
- **ヒーププロファイリング**: `--heap-prof`オプションでヒープスナップショット取得可能
- **Verboseモード**: HTTP通信のデバッグ出力をサポート

### ログ機能

- **スコープ付きログ**: `Output.scoped`によるモジュール別ログ出力
- **ログレベル**: `.visible`/`.hidden`で表示制御
- **主要なログスコープ**:
  - `.Server`: HTTPサーバー
  - `.RequestContext`: リクエストコンテキスト
  - `.FetchTasklet`: Fetch処理
  - `.Postgres`: PostgreSQL接続
  - `.MySQLConnection`: MySQL接続
  - `.fetch`: HTTPクライアント

### アナリティクス

- **匿名クラッシュレポート**: 有効/無効を選択可能（`DO_NOT_TRACK`環境変数で無効化）
- **機能使用状況追跡**: 各APIの使用回数を内部的に記録

## 運用・監視要件

### 環境変数による設定

| 環境変数 | 説明 | 備考 |
| --- | --- | --- |
| `BUN_CONFIG_MAX_HTTP_REQUESTS` | 最大同時HTTPリクエスト数 | 1〜65535 |
| `DO_NOT_TRACK` | アナリティクス無効化 | 設定時は匿名レポート送信なし |
| `BUN_DEBUG_QUIET_LOGS` | デバッグログ抑制 | 1で有効 |
| `BUN_DEBUG_<scopeName>` | 特定スコープのデバッグログ有効化 | 例: `BUN_DEBUG_Server=1` |

### ヘルスチェック

- **起動時ファイル検証**: 静的ルートのファイル存在確認
- **プロセス終了コード**: 異常時は非ゼロで終了

### リソース制限

| 項目 | 制限値 | 備考 |
| --- | --- | --- |
| シェルサブプロセスバッファ | 4MB | `default_max_buffer_size = 1024 * 1024 * 4` |
| タイムアウト粒度 | 4秒 | `LIBUS_TIMEOUT_GRANULARITY = 4` |
| SSL証明書セッション有効期限 | 2時間〜7日 | BoringSSLのデフォルト設定 |

## 備考

### 対応プラットフォーム

- macOS (darwin)
- Linux
- Windows

### 依存ライブラリ

- **JavaScriptCore**: WebKitのJavaScriptエンジン
- **BoringSSL**: TLS/SSL実装
- **c-ares**: 非同期DNS解決
- **mimalloc**: 高性能メモリアロケータ
- **picohttp**: 軽量HTTPパーサー
- **uWebSockets**: 高性能WebSocketライブラリ

### バージョン情報

- 本ドキュメントはBunリポジトリのソースコード解析に基づいて生成されました
- 実際の動作は実装の詳細により異なる場合があります
