# API設計書: GenApp (General Insurance Application)

## 1. 概要

### 1.1 ドキュメント情報

| 項目 | 内容 |
|------|------|
| システム名 | GenApp (General Insurance Application) |
| バージョン | 1.0 |
| 作成日 | 2026-01-06 |
| プラットフォーム | IBM CICS Transaction Server for z/OS |
| 通信プロトコル | SOAP/HTTP (Web Services) |

### 1.2 システム概要

GenAppは、IBM CICS TS上で動作する汎用保険アプリケーションです。顧客情報と保険契約(ポリシー)情報の管理を行うビジネスロジックを提供し、Webサービスとして外部システムとの連携が可能です。

### 1.3 API アーキテクチャ

```
[外部システム] <--SOAP/HTTP--> [CICS Web Services Pipeline]
                                      |
                                      v
                               [CICS Transaction]
                                      |
                                      v
                    +------------------+------------------+
                    |                  |                  |
                    v                  v                  v
              [ビジネスロジック]  [データ管理]    [VSAM/Db2]
```

#### レイヤー構成
- **プレゼンテーション層**: SOAP Webサービス (Pipeline: GENAPIP1)
- **ビジネスロジック層**: COBOLプログラム (LGACUS01, LGICUS01, LGAPOL01等)
- **データ管理層**: COBOLプログラム (LGACDB01, LGICDB01, LGAPDB01等)
- **データ層**: Db2データベース / VSAMファイル

---

## 2. 接続情報

### 2.1 エンドポイント基本情報

| 項目 | 値 |
|------|------|
| プロトコル | HTTP/HTTPS |
| デフォルトポート | 4321 |
| ベースURI | /GENAPP/ |
| Pipeline | GENAPIP1 |
| TCPIPサービス | GENATCP1 |

### 2.2 WSDL ファイル配置

WSDLファイルは以下のパスに生成されます:
```
<ZFSHOME>/genapp/wsdir/
```

---

## 3. 認証・認可

### 3.1 認証方式

現在のバージョンでは、アプリケーションレベルでの明示的な認証機構は実装されていません。

セキュリティは以下のCICSレベルの機能で管理されます:

| セキュリティ層 | 説明 |
|--------------|------|
| CICS Security | CICSリージョンレベルのトランザクションセキュリティ |
| RACF/SAF | z/OS Security Server による認証・認可 |
| SSL/TLS | TCPIPサービスでのSSL設定(オプション) |

### 3.2 認可

トランザクションレベルでのアクセス制御が可能です:
- 各Webサービス呼び出しはCICSトランザクション(CWXN)を通じて処理されます
- RACFプロファイルによりトランザクション実行権限を制御可能

---

## 4. Webサービス API 詳細

### 4.1 顧客管理API

#### 4.1.1 顧客追加 (Customer Add)

| 項目 | 値 |
|------|------|
| サービス名 | LGACUS01 |
| URI | GENAPP/LGACUS01 |
| WSDLファイル | LGACUS01.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | 新規顧客情報をDb2データベースに登録 |

**リクエスト構造:**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01ACUS") |
| CA-RETURN-CODE | 数字 | 2 | - | 戻りコード (初期値: 00) |
| CA-CUSTOMER-NUM | 数字 | 10 | - | 顧客番号 (システム生成) |
| CA-FIRST-NAME | 英数字 | 10 | Yes | 名 |
| CA-LAST-NAME | 英数字 | 20 | Yes | 姓 |
| CA-DOB | 英数字 | 10 | Yes | 生年月日 |
| CA-HOUSE-NAME | 英数字 | 20 | No | 住所(建物名) |
| CA-HOUSE-NUM | 英数字 | 4 | No | 住所(番地) |
| CA-POSTCODE | 英数字 | 8 | Yes | 郵便番号 |
| CA-NUM-POLICIES | 数字 | 3 | - | 契約数 (初期値: 00) |
| CA-PHONE-MOBILE | 英数字 | 20 | No | 携帯電話番号 |
| CA-PHONE-HOME | 英数字 | 20 | No | 自宅電話番号 |
| CA-EMAIL-ADDRESS | 英数字 | 100 | No | メールアドレス |

**レスポンス構造:**

| フィールド名 | データ型 | サイズ | 説明 |
|------------|---------|-------|------|
| CA-RETURN-CODE | 数字 | 2 | 処理結果コード |
| CA-CUSTOMER-NUM | 数字 | 10 | 生成された顧客番号 |

#### 4.1.2 顧客照会 (Customer Inquiry)

| 項目 | 値 |
|------|------|
| サービス名 | LGICUS01 |
| URI | GENAPP/LGICUS01 |
| WSDLファイル | LGICUS01.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | 顧客番号に基づく顧客情報の取得 |

**リクエスト構造:**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01ICUS") |
| CA-CUSTOMER-NUM | 数字 | 10 | Yes | 照会対象の顧客番号 |

**レスポンス構造:**

| フィールド名 | データ型 | サイズ | 説明 |
|------------|---------|-------|------|
| CA-RETURN-CODE | 数字 | 2 | 処理結果コード |
| CA-CUSTOMER-NUM | 数字 | 10 | 顧客番号 |
| CA-FIRST-NAME | 英数字 | 10 | 名 |
| CA-LAST-NAME | 英数字 | 20 | 姓 |
| CA-DOB | 英数字 | 10 | 生年月日 |
| CA-HOUSE-NAME | 英数字 | 20 | 住所(建物名) |
| CA-HOUSE-NUM | 英数字 | 4 | 住所(番地) |
| CA-POSTCODE | 英数字 | 8 | 郵便番号 |
| CA-NUM-POLICIES | 数字 | 3 | 契約数 |
| CA-PHONE-MOBILE | 英数字 | 20 | 携帯電話番号 |
| CA-PHONE-HOME | 英数字 | 20 | 自宅電話番号 |
| CA-EMAIL-ADDRESS | 英数字 | 100 | メールアドレス |

#### 4.1.3 顧客更新 (Customer Update)

| 項目 | 値 |
|------|------|
| サービス名 | LGUCUS01 |
| URI | - (内部使用) |
| メソッド | CICS LINK |
| 処理概要 | 顧客情報の更新 |

**リクエスト構造:**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 ("01UCUS") |
| CA-CUSTOMER-NUM | 数字 | 10 | Yes | 更新対象の顧客番号 |
| (その他のフィールド) | - | - | - | 顧客追加と同様 |

---

### 4.2 ポリシー管理API

#### 4.2.1 自動車保険ポリシー追加 (Motor Policy Add)

| 項目 | 値 |
|------|------|
| サービス名 | LGAPOL01 (Motor) |
| URI | GENAPP/LGAPOLM1 |
| WSDLファイル | LGAPOLM1.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | 自動車保険ポリシーの新規作成 |

**リクエスト構造:**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01AMOT") |
| CA-CUSTOMER-NUM | 数字 | 10 | Yes | 顧客番号 |
| CA-POLICY-NUM | 数字 | 10 | - | ポリシー番号 (システム生成) |
| CA-ISSUE-DATE | 英数字 | 10 | Yes | 発行日 |
| CA-EXPIRY-DATE | 英数字 | 10 | Yes | 有効期限 |
| CA-BROKERID | 数字 | 10 | No | ブローカーID |
| CA-BROKERSREF | 英数字 | 10 | No | ブローカー参照番号 |
| CA-PAYMENT | 数字 | 6 | Yes | 支払額 |
| CA-M-MAKE | 英数字 | 15 | Yes | 車両メーカー |
| CA-M-MODEL | 英数字 | 15 | Yes | 車両モデル |
| CA-M-VALUE | 数字 | 6 | Yes | 車両価格 |
| CA-M-REGNUMBER | 英数字 | 7 | Yes | 登録番号 |
| CA-M-COLOUR | 英数字 | 8 | No | 車両色 |
| CA-M-CC | 数字 | 4 | No | 排気量 |
| CA-M-MANUFACTURED | 英数字 | 10 | No | 製造日 |
| CA-M-PREMIUM | 数字 | 6 | Yes | 保険料 |
| CA-M-ACCIDENTS | 数字 | 6 | No | 事故履歴数 |

**レスポンス構造:**

| フィールド名 | データ型 | サイズ | 説明 |
|------------|---------|-------|------|
| CA-RETURN-CODE | 数字 | 2 | 処理結果コード |
| CA-POLICY-NUM | 数字 | 10 | 生成されたポリシー番号 |

#### 4.2.2 住宅保険ポリシー追加 (House Policy Add)

| 項目 | 値 |
|------|------|
| サービス名 | LGAPOL01 (House) |
| URI | GENAPP/LGAPOLH1 |
| WSDLファイル | LGAPOLH1.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | 住宅保険ポリシーの新規作成 |

**リクエスト構造 (ポリシー固有部分):**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01AHOU") |
| CA-H-PROPERTY-TYPE | 英数字 | 15 | Yes | 物件種別 |
| CA-H-BEDROOMS | 数字 | 3 | Yes | 寝室数 |
| CA-H-VALUE | 数字 | 8 | Yes | 物件価格 |
| CA-H-HOUSE-NAME | 英数字 | 20 | No | 建物名 |
| CA-H-HOUSE-NUMBER | 英数字 | 4 | No | 番地 |
| CA-H-POSTCODE | 英数字 | 8 | Yes | 郵便番号 |

#### 4.2.3 養老保険ポリシー追加 (Endowment Policy Add)

| 項目 | 値 |
|------|------|
| サービス名 | LGAPOL01 (Endowment) |
| URI | GENAPP/LGAPOLE1 |
| WSDLファイル | LGAPOLE1.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | 養老保険ポリシーの新規作成 |

**リクエスト構造 (ポリシー固有部分):**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01AEND") |
| CA-E-WITH-PROFITS | 英数字 | 1 | No | 有配当フラグ |
| CA-E-EQUITIES | 英数字 | 1 | No | 株式フラグ |
| CA-E-MANAGED-FUND | 英数字 | 1 | No | マネージドファンドフラグ |
| CA-E-FUND-NAME | 英数字 | 10 | No | ファンド名 |
| CA-E-TERM | 数字 | 2 | Yes | 期間(年) |
| CA-E-SUM-ASSURED | 数字 | 6 | Yes | 保証金額 |
| CA-E-LIFE-ASSURED | 英数字 | 31 | Yes | 被保険者名 |

#### 4.2.4 商業保険ポリシー追加 (Commercial Policy Add)

| 項目 | 値 |
|------|------|
| サービス名 | LGAPOL01 (Commercial) |
| URI | GENAPP/LGAPOLB1 |
| WSDLファイル | LGAPOLB1.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | 商業保険ポリシーの新規作成 |

**リクエスト構造 (ポリシー固有部分):**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01ACOM") |
| CA-B-Address | 英数字 | 255 | Yes | 物件住所 |
| CA-B-Postcode | 英数字 | 8 | Yes | 郵便番号 |
| CA-B-Latitude | 英数字 | 11 | No | 緯度 |
| CA-B-Longitude | 英数字 | 11 | No | 経度 |
| CA-B-Customer | 英数字 | 255 | Yes | 顧客詳細 |
| CA-B-PropType | 英数字 | 255 | Yes | 物件タイプ |
| CA-B-FirePeril | 数字 | 4 | No | 火災リスク |
| CA-B-FirePremium | 数字 | 8 | No | 火災保険料 |
| CA-B-CrimePeril | 数字 | 4 | No | 犯罪リスク |
| CA-B-CrimePremium | 数字 | 8 | No | 犯罪保険料 |
| CA-B-FloodPeril | 数字 | 4 | No | 洪水リスク |
| CA-B-FloodPremium | 数字 | 8 | No | 洪水保険料 |
| CA-B-WeatherPeril | 数字 | 4 | No | 天候リスク |
| CA-B-WeatherPremium | 数字 | 8 | No | 天候保険料 |
| CA-B-Status | 数字 | 4 | No | ステータス |
| CA-B-RejectReason | 英数字 | 255 | No | 拒否理由 |

#### 4.2.5 ポリシー照会 (Policy Inquiry)

各ポリシータイプに対応した照会APIが提供されています:

| ポリシータイプ | サービス名 | URI | WSDLファイル |
|--------------|-----------|-----|-------------|
| 自動車保険 | LGIPOL01 | GENAPP/LGIPOLM1 | LGIPOLM1.wsdl |
| 住宅保険 | LGIPOL01 | GENAPP/LGIPOLH1 | LGIPOLH1.wsdl |
| 養老保険 | LGIPOL01 | GENAPP/LGIPOLE1 | LGIPOLE1.wsdl |
| 商業保険 | LGIPOL01 | GENAPP/LGIPOLB1 | LGIPOLB1.wsdl |

**共通リクエスト構造:**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| CA-REQUEST-ID | 英数字 | 6 | Yes | リクエスト識別子 (例: "01IMOT") |
| CA-CUSTOMER-NUM | 数字 | 10 | Yes | 顧客番号 |
| CA-POLICY-NUM | 数字 | 10 | Yes | ポリシー番号 |

**レスポンス:**
各ポリシータイプの追加APIと同じフィールド構造でデータが返却されます。

#### 4.2.6 ポリシー更新 (Policy Update)

| 項目 | 値 |
|------|------|
| サービス名 | LGUPOL01 |
| URI | - (内部使用) |
| メソッド | CICS LINK |
| 処理概要 | ポリシー情報の更新 |

**リクエスト識別子:**

| ポリシータイプ | CA-REQUEST-ID |
|--------------|---------------|
| 養老保険 | 01UEND |
| 住宅保険 | 01UHOU |
| 自動車保険 | 01UMOT |

#### 4.2.7 ポリシー削除 (Policy Delete)

| 項目 | 値 |
|------|------|
| サービス名 | LGDPOL01 |
| URI | - (内部使用) |
| メソッド | CICS LINK |
| 処理概要 | ポリシーの削除 |

**リクエスト識別子:**

| ポリシータイプ | CA-REQUEST-ID |
|--------------|---------------|
| 養老保険 | 01DEND |
| 住宅保険 | 01DHOU |
| 自動車保険 | 01DMOT |
| 商業保険 | 01DCOM |

---

### 4.3 VSAM直接アクセスAPI

#### 4.3.1 顧客VSAM照会 (Customer VSAM Inquiry)

| 項目 | 値 |
|------|------|
| サービス名 | LGICVS01 |
| URI | GENAPP/LGICVS01 |
| WSDLファイル | LGICVS01.wsdl |
| メソッド | POST (SOAP) |
| 処理概要 | VSAMファイルから顧客番号を取得 |

**リクエスト構造:**

| フィールド名 | データ型 | サイズ | 必須 | 説明 |
|------------|---------|-------|------|------|
| Customer-Number | 英数字 | 10 | Yes | 検索する顧客番号 |

**レスポンス構造:**

| フィールド名 | データ型 | サイズ | 説明 |
|------------|---------|-------|------|
| Comma-Data-Text | 英数字 | 14 | テキストデータ |
| Comma-Data-High | 英数字 | 10 | 最大顧客番号 |

---

## 5. 戻りコード一覧

### 5.1 共通戻りコード

| コード | 説明 | 対処方法 |
|-------|------|----------|
| 00 | 正常終了 | 処理成功 |
| 98 | COMMAREAサイズ不足 | リクエストデータのサイズを確認 |
| 99 | 不正なリクエストID | CA-REQUEST-IDの値を確認 |

### 5.2 データベース関連エラー

Db2アクセスでエラーが発生した場合、エラーメッセージは一時ストレージキュー(GENAERRS)に記録されます。

---

## 6. データモデル

### 6.1 データベーステーブル構成

| テーブル名 | 説明 |
|-----------|------|
| CUSTOMER | 顧客マスタテーブル |
| POLICY | ポリシー基本テーブル |
| MOTOR | 自動車保険詳細テーブル |
| HOUSE | 住宅保険詳細テーブル |
| ENDOWMENT | 養老保険詳細テーブル |
| COMMERCIAL | 商業保険詳細テーブル |

### 6.2 VSAMファイル構成

| ファイル名 | キー | 説明 |
|-----------|-----|------|
| KSDSCUST | 顧客番号(10桁) | 顧客レコード |
| KSDSPOLY | ポリシータイプ(1)+顧客番号(10)+ポリシー番号(10) | ポリシーレコード |

### 6.3 ポリシータイプコード

| コード | 説明 |
|-------|------|
| M | Motor (自動車保険) |
| H | House (住宅保険) |
| E | Endowment (養老保険) |
| C | Commercial (商業保険) |

---

## 7. トランザクション一覧

| トランザクションID | 説明 |
|------------------|------|
| CWXN | Webサービスリクエスト処理用トランザクション |
| SSC1 | 顧客メニュー |
| SSP1 | 自動車保険メニュー |
| SSP2 | 養老保険メニュー |
| SSP3 | 住宅保険メニュー |
| SSP4 | 商業保険メニュー |
| LGSE | カウンター・TSQ初期化 |
| LGCF | VSAM顧客番号取得 |
| LGPF | VSAMポリシー番号取得 |
| LGST | イベントアダプタトリガー |
| SSST | 動的スクリプト初期化 |

---

## 8. 制限事項・注意事項

### 8.1 COMMAREAサイズ制限

- 最大COMMAREAサイズ: 32,500バイト
- Webサービス用に32KB未満に制限されている場合があります

### 8.2 トランザクションタイムアウト

CICSトランザクションのタイムアウト設定に依存します。

### 8.3 同時実行性

- Db2接続はCICS DB2 Attachment Facilityを使用
- VSAMファイルアクセスは2フェーズコミットをサポート

### 8.4 文字コード

- EBCDIC (メインフレーム内部)
- Webサービス経由の場合はUTF-8/ISO-8859-1に変換

---

## 9. 関連プログラム一覧

### 9.1 ビジネスロジック層

| プログラム名 | 説明 |
|------------|------|
| LGACUS01 | 顧客追加ビジネスロジック |
| LGICUS01 | 顧客照会ビジネスロジック |
| LGUCUS01 | 顧客更新ビジネスロジック |
| LGAPOL01 | ポリシー追加ビジネスロジック |
| LGIPOL01 | ポリシー照会ビジネスロジック |
| LGUPOL01 | ポリシー更新ビジネスロジック |
| LGDPOL01 | ポリシー削除ビジネスロジック |

### 9.2 データ管理層

| プログラム名 | 説明 |
|------------|------|
| LGACDB01 | 顧客追加Db2処理 |
| LGICDB01 | 顧客照会Db2処理 |
| LGUCDB01 | 顧客更新Db2処理 |
| LGAPDB01 | ポリシー追加Db2処理 |
| LGIPDB01 | ポリシー照会Db2処理 |
| LGUPDB01 | ポリシー更新Db2処理 |
| LGDPDB01 | ポリシー削除Db2処理 |
| LGACVS01 | 顧客追加VSAM処理 |
| LGICVS01 | 顧客照会VSAM処理 |
| LGAPVS01 | ポリシー追加VSAM処理 |
| LGIPVS01 | ポリシー照会VSAM処理 |
| LGDPVS01 | ポリシー削除VSAM処理 |

---

## 10. Webサービス設定参考情報

### 10.1 Pipeline設定

```xml
<!-- basicsoap11provider.xml を使用 -->
/usr/lpp/cicsts/cics660/samples/pipelines/basicsoap11provider.xml
```

### 10.2 WSBINDファイル生成

JCL例(DFHLS2WSプロシージャ使用):
```jcl
//LS2WS     EXEC DFHLS2WS,
//    JAVADIR='java601_bit64_ga/J6.0.1_64',
//    USSDIR='cics660'
//INPUT.SYSUT1 DD *
 PDSLIB=<SOURCEX>
 LANG=COBOL
 PGMNAME=LGICUS01
 REQMEM=SOAIC01
 RESPMEM=SOAIC01
 URI=GENAPP/LGICUS01
 PGMINT=COMMAREA
 WSBIND=<ZFSHOME>/genapp/wsdir/LGICUS01.wsbind
 WSDL=<ZFSHOME>/genapp/wsdir/LGICUS01.wsdl
/*
```

---

## 付録A: Request-ID一覧

| Request-ID | 操作 | 対象 |
|------------|------|------|
| 01ACUS | Add | Customer |
| 01ICUS | Inquiry | Customer |
| 01UCUS | Update | Customer |
| 01AMOT | Add | Motor Policy |
| 01IMOT | Inquiry | Motor Policy |
| 01UMOT | Update | Motor Policy |
| 01DMOT | Delete | Motor Policy |
| 01AEND | Add | Endowment Policy |
| 01IEND | Inquiry | Endowment Policy |
| 01UEND | Update | Endowment Policy |
| 01DEND | Delete | Endowment Policy |
| 01AHOU | Add | House Policy |
| 01IHOU | Inquiry | House Policy |
| 01UHOU | Update | House Policy |
| 01DHOU | Delete | House Policy |
| 01ACOM | Add | Commercial Policy |
| 01ICOM | Inquiry | Commercial Policy |
| 01DCOM | Delete | Commercial Policy |

---

## 付録B: サンプルリクエスト (SOAP)

### 顧客照会リクエスト例

```xml
<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:gen="http://genapp.ibm.com/LGICUS01">
   <soapenv:Header/>
   <soapenv:Body>
      <gen:LGICUS01Operation>
         <gen:CA_REQUEST_ID>01ICUS</gen:CA_REQUEST_ID>
         <gen:CA_CUSTOMER_NUM>0000000001</gen:CA_CUSTOMER_NUM>
      </gen:LGICUS01Operation>
   </soapenv:Body>
</soapenv:Envelope>
```

---

*ドキュメント終了*
