# 根拠レポート: API設計書

## 1. 分析概要

| 項目 | 内容 |
|------|------|
| 対象ドキュメント | API設計書.md |
| 分析日時 | 2026-01-06 |
| 分析対象コードベース | cics-genapp-main |
| 総合信頼度 | 85% |

---

## 2. 情報源と根拠

### 2.1 プロジェクト構成情報

| 情報項目 | 根拠ファイル | 信頼度 |
|---------|-------------|--------|
| システム概要 | `/README.md`, `/base/README.md` | 95% |
| アーキテクチャ | `/base/Architecture.md` | 95% |
| トランザクション一覧 | `/base/Reference.md` | 95% |
| プログラム一覧 | `/base/Reference.md` | 95% |

### 2.2 Webサービス設定情報

| 情報項目 | 根拠ファイル | 信頼度 |
|---------|-------------|--------|
| URI定義 | `/base/cntl/wsaic01.jcl`, `/base/cntl/wsaac01.jcl`, `/base/cntl/wsaip01.jcl`, `/base/cntl/wsaap01.jcl`, `/base/cntl/wsavc01.jcl` | 90% |
| TCPIPサービス設定 | `/base/cntl/cdef124.jcl` | 90% |
| Pipeline設定 | `/base/cntl/cdef124.jcl` | 90% |
| ポート番号 | `/base/cntl/cdef124.jcl` | 95% |

### 2.3 データ構造情報

| 情報項目 | 根拠ファイル | 信頼度 |
|---------|-------------|--------|
| COMMAREA構造 | `/base/src/lgcmarea.cpy` | 95% |
| ポリシー長定義 | `/base/src/lgpolicy.cpy` | 95% |
| 顧客SOAPデータ構造 | `/base/src/soaic01.cpy` | 90% |
| 自動車保険SOAPデータ | `/base/src/soaipm1.cpy` | 90% |
| 住宅保険SOAPデータ | `/base/src/soaiph1.cpy` | 90% |
| 養老保険SOAPデータ | `/base/src/soaipe1.cpy` | 90% |
| 商業保険SOAPデータ | `/base/src/soaipb1.cpy` | 90% |
| VSAM入力データ構造 | `/base/src/soavcii.cpy` | 90% |
| VSAM出力データ構造 | `/base/src/soavcio.cpy` | 90% |

### 2.4 ビジネスロジック情報

| 情報項目 | 根拠ファイル | 信頼度 |
|---------|-------------|--------|
| 顧客追加処理 | `/base/src/lgacus01.cbl` | 95% |
| 顧客照会処理 | `/base/src/lgicus01.cbl` | 95% |
| 顧客更新処理 | `/base/src/lgucus01.cbl` | 95% |
| ポリシー追加処理 | `/base/src/lgapol01.cbl` | 95% |
| ポリシー照会処理 | `/base/src/lgipol01.cbl` | 95% |
| ポリシー更新処理 | `/base/src/lgupol01.cbl` | 95% |
| ポリシー削除処理 | `/base/src/lgdpol01.cbl` | 95% |

### 2.5 戻りコード情報

| 情報項目 | 根拠ファイル | 信頼度 |
|---------|-------------|--------|
| 戻りコード 00 | 全ビジネスロジックプログラム | 95% |
| 戻りコード 98 | `/base/src/lgacus01.cbl`, `/base/src/lgicus01.cbl` 等 | 95% |
| 戻りコード 99 | `/base/src/lgucus01.cbl`, `/base/src/lgupol01.cbl`, `/base/src/lgdpol01.cbl` | 95% |

---

## 3. 推測・補完情報

以下の情報はコードベースから直接確認できなかったため、推測または一般的なCICS/SOAPの知識に基づいています:

### 3.1 推測レベル: 中 (70-80%)

| 情報項目 | 推測根拠 | 信頼度 |
|---------|---------|--------|
| SOAPエンベロープ形式 | CICS Web Services標準形式に基づく推測 | 70% |
| 認証方式 | コードに明示的認証ロジックがないことからの推測 | 75% |
| SSL/TLS設定 | TCPIPサービス設定の標準オプションからの推測 | 70% |

### 3.2 推測レベル: 低 (50-70%)

| 情報項目 | 推測根拠 | 信頼度 |
|---------|---------|--------|
| タイムアウト設定 | CICS標準設定からの推測、実際の設定値は不明 | 60% |
| 同時実行制御の詳細 | Architecture.mdの記述からの推測 | 65% |

---

## 4. 未確認・不明事項

以下の項目はコードベースから確認できませんでした:

### 4.1 環境依存情報
- 実際のホスト名・IPアドレス
- 実運用環境でのポート番号
- RACF/SAFの詳細設定
- Db2データベース名・スキーマ名

### 4.2 運用情報
- SLAやパフォーマンス要件
- 実際のエラーハンドリングフロー詳細
- 監視・ロギング設定
- バックアップ・リカバリ手順

### 4.3 セキュリティ情報
- SSL証明書の詳細
- 認証・認可の詳細設定
- データ暗号化の有無

---

## 5. 分析プロセス

### 5.1 分析手順

1. **ドキュメント調査**: README.md, Architecture.md, Reference.md を読み込み、システム概要を把握
2. **JCL分析**: wsaac01.jcl, wsaic01.jcl, wsaap01.jcl, wsaip01.jcl, wsavc01.jcl からWebサービス設定を抽出
3. **COBOL Copybook分析**: lgcmarea.cpy, lgpolicy.cpy, soaic01.cpy等からデータ構造を抽出
4. **ビジネスロジック分析**: lgacus01.cbl, lgicus01.cbl等から処理フローと戻りコードを分析
5. **CSD定義分析**: cdef124.jcl からリソース定義(TCPIPサービス、Pipeline)を抽出

### 5.2 分析対象ファイル一覧

```
ドキュメント:
- /README.md
- /base/README.md
- /base/Architecture.md
- /base/Reference.md

JCLファイル:
- /base/cntl/wsaac01.jcl
- /base/cntl/wsaic01.jcl
- /base/cntl/wsaap01.jcl
- /base/cntl/wsaip01.jcl
- /base/cntl/wsavc01.jcl
- /base/cntl/cdef124.jcl

COBOLプログラム:
- /base/src/lgacus01.cbl
- /base/src/lgicus01.cbl
- /base/src/lgucus01.cbl
- /base/src/lgapol01.cbl
- /base/src/lgipol01.cbl
- /base/src/lgupol01.cbl
- /base/src/lgdpol01.cbl
- /base/src/lgwebst5.cbl

Copybook:
- /base/src/lgcmarea.cpy
- /base/src/lgpolicy.cpy
- /base/src/soaic01.cpy
- /base/src/soaipm1.cpy
- /base/src/soaiph1.cpy
- /base/src/soaipe1.cpy
- /base/src/soaipb1.cpy
- /base/src/soavcii.cpy
- /base/src/soavcio.cpy
```

---

## 6. 信頼度評価基準

| 信頼度レベル | 範囲 | 説明 |
|------------|------|------|
| 高 | 90-100% | ソースコード・ドキュメントから直接確認できる情報 |
| 中高 | 80-89% | 複数の情報源から合理的に導出できる情報 |
| 中 | 70-79% | 標準的な設計パターン・プラットフォーム仕様からの推測 |
| 低 | 60-69% | 限られた情報からの推測、環境依存の可能性が高い情報 |
| 非常に低 | 50-59% | 仮定に基づく情報、要確認事項 |

---

## 7. 推奨事項

### 7.1 確認が必要な項目

1. **TCPIPサービス設定**: 実運用環境でのポート番号、SSL設定を確認
2. **認証設定**: RACF/SAFの設定状況、Webサービスレベルの認証要件を確認
3. **データベーススキーマ**: 実際のDb2テーブル定義、カラム制約を確認
4. **WSDLファイル**: 生成済みのWSDLファイルとの整合性を確認

### 7.2 ドキュメント更新推奨

1. **エラーコード一覧の拡充**: Db2エラー、CICSエラーを含む詳細なエラーコード一覧の作成
2. **サンプルリクエスト/レスポンスの追加**: 各APIの具体的なSOAPサンプルの追加
3. **環境設定ガイド**: TCPIPサービス、Pipeline設定の詳細手順の追加

---

## 8. 改訂履歴

| バージョン | 日付 | 内容 |
|-----------|------|------|
| 1.0 | 2026-01-06 | 初版作成 |

---

*レポート終了*
