# CICS GenApp (General Insurance Application)

## 概要

CICS GenApp（General Insurance Application）は、IBM CICS Transaction Server for z/OS向けに開発された一般保険業務アプリケーションです。IBM Hursley CICSチームによって開発され、CICSの新機能テストおよびレガシーアプリケーションのモダナイゼーションを実証するためのサンプルアプリケーションとして提供されています。

顧客情報と保険契約（ポリシー）の登録・照会・削除を行う機能を持ち、3270端末インターフェースを通じて操作します。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 顧客管理 | 顧客情報の照会・追加（SSC1トランザクション） |
| 自動車保険契約 | 自動車保険ポリシーの作成・照会・更新・削除（SSP1トランザクション） |
| 養老保険契約 | 養老保険ポリシーの作成・照会・更新・削除（SSP2トランザクション） |
| 住宅保険契約 | 住宅保険ポリシーの作成・照会・更新・削除（SSP3トランザクション） |
| 商業用不動産保険契約 | 商業用不動産保険ポリシーの作成・照会・更新・削除（SSP4トランザクション） |
| Webサービス | 顧客・ポリシー操作用のSOAP/JSON Webサービス |
| ワークロードシミュレーション | IBM Workload Simulatorによる負荷テスト |
| CICSPlex SM対応 | トポロジー管理およびワークロード管理 |

## 技術スタック

### コア

- フレームワーク: IBM CICS Transaction Server for z/OS (V4.1以降)
- 言語: COBOL
- データベース: IBM Db2
- ファイルシステム: VSAM (KSDS)
- 画面インターフェース: BMS (Basic Mapping Support) 3270端末

### 主要ライブラリ

- IBM Enterprise COBOL V6.x
- Language Environment (LE)
- CICS Web Services Assistant
- IBM Workload Simulator for z/OS (オプション)
- CICSPlex SM (オプション)

### オプション機能

- Named Counter Server (カップリングファシリティ使用)
- Shared Temporary Storage Queue (カップリングファシリティ使用)

## ディレクトリ構成

```
cics-genapp-main/
├── base/                      # GenAppベースアプリケーション
│   ├── bin/                   # インストールスクリプト
│   │   └── install.sh         # USSからのインストールスクリプト
│   ├── cntl/                  # JCLジョブ（環境構築用）
│   │   ├── adef121.jcl        # VSAMファイル定義・データロード
│   │   ├── asmmap.jcl         # BMSマップアセンブル
│   │   ├── cdef12x.jcl        # CICSリソース定義
│   │   ├── cobol.jcl          # COBOLコンパイル
│   │   ├── db2cre.jcl         # Db2データベース作成
│   │   ├── db2bind.jcl        # Db2バインド
│   │   └── ...                # その他JCLジョブ
│   ├── data/                  # サンプルデータ
│   │   ├── ksdscust.txt       # 顧客データ
│   │   └── ksdspoly.txt       # ポリシーデータ
│   ├── event-bindings/        # イベントバインディング定義
│   ├── exec/                  # REXXスクリプト
│   │   ├── cust1.rexx         # カスタマイズスクリプト
│   │   └── mac1.rexx          # マクロスクリプト
│   ├── images/                # ドキュメント用画像
│   ├── src/                   # ソースコード
│   │   ├── lg*.cbl            # COBOLプログラム
│   │   ├── *.cpy              # COBOLコピーブック
│   │   └── ssmap.bms          # BMSマップ定義
│   ├── wsim/                  # Workload Simulatorスクリプト
│   ├── Architecture.md        # アーキテクチャ説明
│   ├── Building.md            # ビルド手順
│   ├── Installation.md        # インストール手順
│   ├── Reference.md           # リファレンス
│   └── Testing.md             # テスト手順
├── Changes.md                 # 変更履歴
├── LICENSE                    # Eclipse Public License 2.0
├── MAINTAINERS.md             # メンテナー情報
└── README.md                  # プロジェクト概要
```

## セットアップ

### 前提条件

- IBM CICS Transaction Server for z/OS V4.1以降
- IBM Db2
- IBM Enterprise COBOL V6.x
- z/OS UNIX System Services (USS) または FTPクライアント

### インストール手順

#### 方法1: USSからの直接クローン

1. USS環境にGitリポジトリをクローン
   ```
   git clone https://github.com/cicsdev/cics-genapp.git
   ```

2. `base/bin/install.sh`スクリプトを編集し、高レベル修飾子を設定

3. インストールスクリプトを実行
   ```
   cd base/bin
   ./install.sh
   ```

#### 方法2: ワークステーションからFTP転送

1. リポジトリをワークステーションにダウンロードまたはクローン

2. 各ディレクトリのREADMEに従い、FTPでMVSデータセットに転送
   - `cntl/` -> `userid.GENAPP.CNTL`
   - `src/` -> `userid.GENAPP.SRC`
   - `exec/` -> `userid.GENAPP.EXEC`
   - `data/` -> `userid.GENAPP.DATA`
   - `wsim/` -> `userid.GENAPP.WSIM`

### カスタマイズ

1. `userid.GENAPP.EXEC(CUST1)`メンバーを環境に合わせて編集
   - `CICSHLQ`: CICSの高レベル修飾子
   - `DB2HLQ`: Db2の高レベル修飾子
   - `COBOLHLQ`: COBOLコンパイラの高レベル修飾子
   - その他環境固有のパラメータ

2. カスタマイズスクリプトを実行
   ```
   EXEC 'userid.GENAPP.EXEC(CUST1)'
   ```

### 環境構築

以下のジョブを順番に実行：

1. `@ADEF121` - VSAMファイルの作成とデータロード
2. `@ASMMAP` - BMSマップのアセンブル
3. `@CDEF121` - CICSリソース定義の登録
4. `@COBOL` - COBOLプログラムのコンパイル
5. `@DB2CRE` - Db2データベースの作成
6. `@DB2BIND` - Db2バインド

オプション（カップリングファシリティ使用時）：
- `@SAMPNCS` - Named Counter Server起動
- `@SAMPTSQ` - Temporary Storage Queue Server起動

## 開発

### プログラム構造

アプリケーションは3層アーキテクチャで設計：

| レイヤー | プログラム例 | 説明 |
| --- | --- | --- |
| プレゼンテーション | LGTESTC1, LGTESTP1-4 | 3270画面制御 |
| ビジネスロジック | LGACUS01, LGIPOL01等 | 業務処理 |
| データアクセス | LGACDB01, LGICVS01等 | Db2/VSAMアクセス |

### 主要トランザクション

| トランザクションID | 説明 |
| --- | --- |
| SSC1 | 顧客メニュー |
| SSP1 | 自動車保険メニュー |
| SSP2 | 養老保険メニュー |
| SSP3 | 住宅保険メニュー |
| SSP4 | 商業用不動産保険メニュー |
| LGSE | カウンター・TSQ初期化 |

### テスト実行

1. LGSEトランザクションを実行してアプリケーションを初期化
2. SSC1トランザクションで顧客情報の照会・追加をテスト
3. SSP1-4トランザクションでポリシー操作をテスト

### Workload Simulatorによる負荷テスト

`wsim/`ディレクトリに各種シミュレーションスクリプトを提供：
- 顧客追加・照会シナリオ
- ポリシー操作シナリオ
- Webサービス呼び出しシナリオ

## ライセンス

Eclipse Public License 2.0

## 参考情報

- [IBM CICS Transaction Server Documentation](https://www.ibm.com/docs/en/cics-ts)
- [CICS GenApp GitHub Repository](https://github.com/cicsdev/cics-genapp)
