---
generated_at: 2026-01-06 15:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **IBM Enterprise COBOL V6.x対応**：バージョン固有の動作確認が必要
  2. **カップリングファシリティの設定詳細**：環境依存のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/cics-genapp-main/README.md` - プロジェクトルートREADME
- E-02: `/Users/tomokababa/Work/route06/cics-genapp-main/base/README.md` - baseディレクトリREADME
- E-03: `/Users/tomokababa/Work/route06/cics-genapp-main/base/Architecture.md` - アーキテクチャ説明
- E-04: `/Users/tomokababa/Work/route06/cics-genapp-main/base/Building.md` - ビルド手順
- E-05: `/Users/tomokababa/Work/route06/cics-genapp-main/base/Installation.md` - インストール手順
- E-06: `/Users/tomokababa/Work/route06/cics-genapp-main/base/Reference.md` - リファレンス
- E-07: `/Users/tomokababa/Work/route06/cics-genapp-main/base/Testing.md` - テスト手順
- E-08: `/Users/tomokababa/Work/route06/cics-genapp-main/Changes.md` - 変更履歴
- E-09: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/lgacdb01.cbl` - COBOLソースコード例
- E-10: `/Users/tomokababa/Work/route06/cics-genapp-main/base/cntl/README.md` - JCLディレクトリREADME
- E-11: `/Users/tomokababa/Work/route06/cics-genapp-main/base/src/README.md` - ソースディレクトリREADME
- E-12: `/Users/tomokababa/Work/route06/cics-genapp-main/LICENSE` - ライセンスファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IBM CICS TS向けの一般保険アプリケーションである | E-01, E-02 | ○ |
| C-02 | IBM Hursley CICSチームによって開発された | E-01 | ○ |
| C-03 | 顧客情報と保険契約の登録・照会・削除機能を持つ | E-03, E-06 | ○ |
| C-04 | 3270端末インターフェースで操作する | E-02, E-03 | ○ |
| C-05 | SSC1トランザクションで顧客管理を行う | E-03, E-06 | ○ |
| C-06 | SSP1-4トランザクションで各種保険ポリシーを管理する | E-03, E-06 | ○ |
| C-07 | CICS TS V4.1以降が必要 | E-01, E-02 | ○ |
| C-08 | COBOLで実装されている | E-09, E-11 | ○ |
| C-09 | IBM Db2をデータベースとして使用 | E-01, E-03 | ○ |
| C-10 | VSAM (KSDS)ファイルを使用 | E-03 | ○ |
| C-11 | BMSマップで3270画面を制御 | E-03, E-06 | ○ |
| C-12 | IBM Enterprise COBOL V6.xに対応 | E-08 | ○ |
| C-13 | Named Counter Serverが使用可能（オプション） | E-03, E-04 | ○ |
| C-14 | Shared TSQが使用可能（オプション） | E-03, E-04 | ○ |
| C-15 | install.shスクリプトでUSSからインストール可能 | E-05 | ○ |
| C-16 | FTPでワークステーションから転送可能 | E-05, E-10, E-11 | ○ |
| C-17 | CUST1 REXXスクリプトでカスタマイズ可能 | E-05 | ○ |
| C-18 | @ADEF121でVSAMファイルを作成 | E-04, E-06 | ○ |
| C-19 | @ASMMAPでBMSマップをアセンブル | E-04, E-06 | ○ |
| C-20 | @COBOLでプログラムをコンパイル | E-04, E-06 | ○ |
| C-21 | @DB2CREでDb2データベースを作成 | E-04, E-06 | ○ |
| C-22 | 3層アーキテクチャで設計されている | E-03 | ○ |
| C-23 | LGTESTxx系がプレゼンテーション層 | E-03, E-06 | ○ |
| C-24 | LGACUSxx/LGIPOLxx系がビジネスロジック層 | E-03, E-06 | ○ |
| C-25 | LGACDBxx/LGICVSxx系がデータアクセス層 | E-03, E-06, E-09 | ○ |
| C-26 | LGSEトランザクションで初期化を行う | E-06, E-07 | ○ |
| C-27 | IBM Enterprise COBOL V6.xの具体的なバージョン要件 | **根拠なし** | △ |
| C-28 | Workload Simulatorスクリプトの詳細な使用方法 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-27について**：Changes.mdに「Updates to make use of IBM Enterprise COBOL compilers V6.x」と記載があるが、具体的なマイナーバージョン要件は不明
  - 候補：IBM COBOL V6.1 / V6.2 / V6.3 / V6.4
- **C-28について**：wsim/ディレクトリにスクリプトファイルが存在するが、詳細な使用方法のドキュメントは確認できず
  - 候補：wsim/README.md（存在するが詳細確認未実施）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：ほとんどの主張は既存ドキュメントに明確な根拠がある
- **1（中リスク）**：COBOLコンパイラバージョンの詳細確認が推奨される
- **0（低リスク）**：ライセンス情報は明確（Eclipse Public License 2.0）

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクト概要が正確に記載されているか確認
- [ ] 前提条件（CICS TS V4.1以降、Db2）が環境に適合しているか確認
- [ ] インストール手順が環境に合わせてカスタマイズ可能か確認
- [ ] トランザクションIDと機能の対応が正確か確認
- [ ] プログラム構造（3層アーキテクチャ）の説明が実装と一致するか確認
- [ ] COBOLコンパイラバージョン（V6.x）が使用環境と互換性があるか確認
