---
generated_at: 2026-01-06 16:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **バックアップ頻度・保持期間**：運用要件として推奨値を記載したが、具体的な設定ファイルやドキュメントなし
  2. **監視アラート条件**：一般的な監視項目を記載したが、具体的な閾値設定なし
  3. **セキュリティ認証方式**：RACFを想定したが、具体的な設定ファイルなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、前提条件
- E-02: `base/README.md` - アプリケーション概要
- E-03: `base/Architecture.md` - アーキテクチャ説明、コンポーネント構成
- E-04: `base/Installation.md` - インストール手順、設定パラメータ
- E-05: `base/Building.md` - ビルド手順、CICSリージョン設定
- E-06: `base/Reference.md` - リソース定義一覧、プログラム一覧
- E-07: `base/images/initial_topology.jpg` - 初期トポロジ構成図
- E-08: `base/cntl/` - JCL制御ファイル群
- E-09: `base/src/` - COBOLソースプログラム群
- E-10: `base/data/` - サンプルデータファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本システムはIBM CICS TS V4.1以降で動作する | E-01, E-02 | ○ |
| C-02 | IBM Db2 for z/OSが必要 | E-01 | ○ |
| C-03 | 3270端末インターフェースを提供 | E-02, E-03 | ○ |
| C-04 | VSAMファイル（KSDSCUST, KSDSPOLY）を使用 | E-03, E-06 | ○ |
| C-05 | Db2にCUSTOMER, POLICYテーブルがある | E-03, E-06 | ○ |
| C-06 | 4種類の保険契約（Motor, Endowment, House, Commercial）をサポート | E-03, E-06 | ○ |
| C-07 | Named Counter Serverはオプション | E-03, E-05 | ○ |
| C-08 | Coupling Facilityはオプション | E-03, E-05 | ○ |
| C-09 | プログラムは3層構造（Presentation, Business, Data） | E-03 | ○ |
| C-10 | 2フェーズコミットでDb2-VSAM間整合性確保 | E-03 | ○ |
| C-11 | CICSPlex SMによるトポロジ管理をサポート | E-02, E-06 | ○ |
| C-12 | DB2CONN, TSMODEL, FILE等のCICSリソース定義が必要 | E-06 | ○ |
| C-13 | GRPLIST=(DFHLIST,GENALIST)の設定が必要 | E-05 | ○ |
| C-14 | DB2CONN=YESの設定が必要 | E-05 | ○ |
| C-15 | NCPLDFT=GENAの設定（Named Counter使用時） | E-05 | ○ |
| C-16 | Db2スキーマはdb2cre.jclで定義 | E-08 | ○ |
| C-17 | COBOLコンパイラV6.1以降を使用 | E-04 | ○ |
| C-18 | REXXスクリプトでJCLをカスタマイズ | E-04 | ○ |
| C-19 | Webサービスパイプライン（GENAPIP1）をサポート | E-06 | ○ |
| C-20 | TCPIPSERVICE（GENATCP1）でHTTP接続 | E-06 | ○ |
| C-21 | イベントバインディング機能をサポート | E-06 | ○ |
| C-22 | Workload Simulator for z/OSをサポート | E-04, E-06 | ○ |
| C-23 | 単一リージョン構成と複数リージョン構成の両方をサポート | E-02, E-05, E-06 | ○ |
| C-24 | USS環境またはワークステーションからインストール可能 | E-04 | ○ |
| C-25 | EBCDIC CCSID設定が必要 | E-04 | ○ |
| C-26 | バックアップは日次推奨、保持期間は運用要件に依存 | **根拠なし** | △ |
| C-27 | 監視はCICS System Log、異常終了でアラート | **根拠なし** | △ |
| C-28 | 認証はRACF/外部セキュリティマネージャー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **バックアップ設計の詳細**
  - 理由：プロジェクト内にバックアップ設定に関するJCLや設定ファイルが存在しない
  - 候補：運用マニュアル / z/OS運用ガイド / 顧客要件定義書
- **監視設計の詳細**
  - 理由：監視ツール設定やアラート閾値を定義するファイルが存在しない
  - 候補：運用監視設計書 / CICS SMF設定 / Tivoli設定
- **セキュリティ設計の詳細**
  - 理由：RACF定義やセキュリティポリシーを定義するファイルが存在しない
  - 候補：セキュリティ設計書 / RACF定義JCL / アクセス制御マトリクス

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: C-01〜C-25 - ソースコードおよびドキュメントから直接確認可能
- **リスク1（中）**: C-26, C-27, C-28 - 一般的な運用慣行に基づく推奨値、実際の運用要件に応じて調整が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CICS TS バージョンが実際の環境と一致するか確認
- [ ] Db2 バージョンが実際の環境と一致するか確認
- [ ] CICSリソース定義（DB2CONN, FILE等）が正しいか確認
- [ ] VSAMファイル名とキー長が正しいか確認
- [ ] Named Counter/TSQ Serverの利用有無を確認
- [ ] バックアップ頻度・保持期間を運用要件に基づいて決定
- [ ] 監視項目とアラート閾値を運用要件に基づいて決定
- [ ] セキュリティ要件（RACF設定等）を確認
