# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "Business Users"
        USER[("Business Users<br/>3270端末")]
    end

    subgraph "z/OS Mainframe"
        subgraph "CICS Region"
            TN3270["TN3270<br/>Terminal Interface"]
            APP["3270 Application<br/>(COBOL Programs)"]

            subgraph "Application Layer"
                PRES["Presentation Logic<br/>(LGTESTC1, LGTESTP1-P4)"]
                BIZ["Business Logic<br/>(LGACUS01, LGAPOL01, etc.)"]
                DATA["Data Management<br/>(LGACDB01, LGAPDB01, etc.)"]
            end

            subgraph "CICS Resources"
                DB2CONN["DB2CONN<br/>(Db2 Attachment)"]
                FILE_CUST["FILE: KSDSCUST"]
                FILE_POLY["FILE: KSDSPOLY"]
                TSMODEL["TSMODEL: GENASTST"]
                TCPIP["TCPIPSERVICE:<br/>GENATCP1"]
                PIPELINE["PIPELINE:<br/>GENAPIP1"]
            end
        end

        subgraph "Data Storage"
            subgraph "VSAM Files"
                VSAM_CUST[("KSDSCUST<br/>Customer Records")]
                VSAM_POLY[("KSDSPOLY<br/>Policy Records")]
            end

            subgraph "Db2 Subsystem"
                DB2[("Db2 Database")]
                TBL_CUST["CUSTOMER Table"]
                TBL_POLICY["POLICY Table"]
                TBL_MOTOR["MOTOR Table"]
                TBL_ENDOW["ENDOWMENT Table"]
                TBL_HOUSE["HOUSE Table"]
                TBL_COMM["COMMERCIAL Table"]
            end
        end

        subgraph "Coupling Facility (Optional)"
            NCS["Named Counter Server<br/>Pool: GENA<br/>Structure: DFHNCLS_GENA"]
            TSQ_CTRL["TSQ: GENACNTL<br/>(Control)"]
            TSQ_ERR["TSQ: GENAERRS<br/>(Errors)"]
        end
    end

    USER --> TN3270
    TN3270 --> APP
    APP --> PRES
    PRES --> BIZ
    BIZ --> DATA

    DATA --> DB2CONN
    DATA --> FILE_CUST
    DATA --> FILE_POLY

    DB2CONN --> DB2
    FILE_CUST --> VSAM_CUST
    FILE_POLY --> VSAM_POLY

    DB2 --> TBL_CUST
    DB2 --> TBL_POLICY
    TBL_POLICY --> TBL_MOTOR
    TBL_POLICY --> TBL_ENDOW
    TBL_POLICY --> TBL_HOUSE
    TBL_POLICY --> TBL_COMM

    BIZ -.-> NCS
    BIZ -.-> TSQ_CTRL
    BIZ -.-> TSQ_ERR

    TCPIP --> PIPELINE

    style USER fill:#f9f,stroke:#333
    style DB2 fill:#90EE90,stroke:#333
    style VSAM_CUST fill:#87CEEB,stroke:#333
    style VSAM_POLY fill:#87CEEB,stroke:#333
    style NCS fill:#FFE4B5,stroke:#333
    style TSQ_CTRL fill:#FFE4B5,stroke:#333
    style TSQ_ERR fill:#FFE4B5,stroke:#333
```

## データフロー図

```mermaid
flowchart LR
    subgraph "User Interface"
        TERM["3270 Terminal"]
    end

    subgraph "Transactions"
        SSC1["SSC1<br/>Customer Menu"]
        SSP1["SSP1<br/>Motor Policy"]
        SSP2["SSP2<br/>Endowment Policy"]
        SSP3["SSP3<br/>House Policy"]
        SSP4["SSP4<br/>Commercial Policy"]
    end

    subgraph "Business Operations"
        ADD_CUST["Add Customer"]
        INQ_CUST["Inquire Customer"]
        ADD_POL["Add Policy"]
        INQ_POL["Inquire Policy"]
        UPD_POL["Update Policy"]
        DEL_POL["Delete Policy"]
    end

    subgraph "Data Storage"
        DB2[("Db2")]
        VSAM[("VSAM")]
    end

    TERM --> SSC1
    TERM --> SSP1
    TERM --> SSP2
    TERM --> SSP3
    TERM --> SSP4

    SSC1 --> ADD_CUST
    SSC1 --> INQ_CUST
    SSP1 & SSP2 & SSP3 & SSP4 --> ADD_POL
    SSP1 & SSP2 & SSP3 & SSP4 --> INQ_POL
    SSP1 & SSP2 & SSP3 & SSP4 --> UPD_POL
    SSP1 & SSP2 & SSP3 & SSP4 --> DEL_POL

    ADD_CUST --> DB2
    ADD_CUST --> VSAM
    INQ_CUST --> DB2
    ADD_POL --> DB2
    ADD_POL --> VSAM
    INQ_POL --> DB2
    UPD_POL --> DB2
    UPD_POL --> VSAM
    DEL_POL --> DB2
    DEL_POL --> VSAM
```

## アプリケーション層構造

```mermaid
graph TB
    subgraph "Presentation Layer"
        LGTESTC1["LGTESTC1<br/>Customer Menu"]
        LGTESTP1["LGTESTP1<br/>Motor Policy"]
        LGTESTP2["LGTESTP2<br/>Endowment Policy"]
        LGTESTP3["LGTESTP3<br/>House Policy"]
        LGTESTP4["LGTESTP4<br/>Commercial Policy"]
        SSMAP["SSMAP<br/>BMS Maps"]
    end

    subgraph "Business Logic Layer"
        LGACUS01["LGACUS01<br/>Add Customer"]
        LGICUS01["LGICUS01<br/>Inquire Customer"]
        LGUCUS01["LGUCUS01<br/>Update Customer"]
        LGAPOL01["LGAPOL01<br/>Add Policy"]
        LGIPOL01["LGIPOL01<br/>Inquire Policy"]
        LGUPOL01["LGUPOL01<br/>Update Policy"]
        LGDPOL01["LGDPOL01<br/>Delete Policy"]
    end

    subgraph "Data Access Layer"
        subgraph "Db2 Access"
            LGACDB01["LGACDB01<br/>Add Customer DB"]
            LGACDB02["LGACDB02<br/>Add Customer DB2"]
            LGICDB01["LGICDB01<br/>Inquire Customer DB"]
            LGUCDB01["LGUCDB01<br/>Update Customer DB"]
            LGAPDB01["LGAPDB01<br/>Add Policy DB"]
            LGIPDB01["LGIPDB01<br/>Inquire Policy DB"]
            LGUPDB01["LGUPDB01<br/>Update Policy DB"]
            LGDPDB01["LGDPDB01<br/>Delete Policy DB"]
        end

        subgraph "VSAM Access"
            LGACVS01["LGACVS01<br/>Add Customer VSAM"]
            LGICVS01["LGICVS01<br/>Inquire Customer VSAM"]
            LGUCVS01["LGUCVS01<br/>Update Customer VSAM"]
            LGAPVS01["LGAPVS01<br/>Add Policy VSAM"]
            LGIPVS01["LGIPVS01<br/>Inquire Policy VSAM"]
            LGUPVS01["LGUPVS01<br/>Update Policy VSAM"]
            LGDPVS01["LGDPVS01<br/>Delete Policy VSAM"]
        end
    end

    LGTESTC1 --> LGACUS01
    LGTESTC1 --> LGICUS01
    LGTESTP1 & LGTESTP2 & LGTESTP3 & LGTESTP4 --> LGAPOL01
    LGTESTP1 & LGTESTP2 & LGTESTP3 & LGTESTP4 --> LGIPOL01
    LGTESTP1 & LGTESTP2 & LGTESTP3 & LGTESTP4 --> LGUPOL01
    LGTESTP1 & LGTESTP2 & LGTESTP3 & LGTESTP4 --> LGDPOL01

    LGACUS01 --> LGACDB01
    LGACUS01 --> LGACVS01
    LGICUS01 --> LGICDB01
    LGICUS01 --> LGICVS01
    LGAPOL01 --> LGAPDB01
    LGAPOL01 --> LGAPVS01
    LGIPOL01 --> LGIPDB01
    LGIPOL01 --> LGIPVS01
    LGUPOL01 --> LGUPDB01
    LGUPOL01 --> LGUPVS01
    LGDPOL01 --> LGDPDB01
    LGDPOL01 --> LGDPVS01
```

## トポロジ構成（拡張構成）

```mermaid
graph TB
    subgraph "CICSPlex SM Management"
        CMAS["CMAS<br/>CICSPlex SM Address Space"]
        WUI["WUI<br/>Web User Interface"]
    end

    subgraph "Application Owning Regions (AOR)"
        AOR1["AOR 1<br/>CICS Region"]
        AOR2["AOR 2<br/>CICS Region"]
        AORn["AOR n<br/>CICS Region"]
    end

    subgraph "Terminal Owning Region (TOR)"
        TOR["TOR<br/>Terminal Router"]
    end

    subgraph "Shared Resources"
        CF["Coupling Facility"]
        DB2[("Db2 Subsystem")]
        VSAM[("VSAM Files")]
    end

    subgraph "Users"
        USERS["3270 Terminals"]
    end

    USERS --> TOR
    TOR --> AOR1
    TOR --> AOR2
    TOR --> AORn

    CMAS --> AOR1
    CMAS --> AOR2
    CMAS --> AORn
    CMAS --> TOR
    WUI --> CMAS

    AOR1 --> CF
    AOR2 --> CF
    AORn --> CF
    AOR1 --> DB2
    AOR2 --> DB2
    AORn --> DB2
    AOR1 --> VSAM
    AOR2 --> VSAM
    AORn --> VSAM

    style CMAS fill:#FFD700,stroke:#333
    style WUI fill:#FFD700,stroke:#333
    style CF fill:#FFE4B5,stroke:#333
    style DB2 fill:#90EE90,stroke:#333
```

## Db2 スキーマ構成

```mermaid
erDiagram
    CUSTOMER {
        int CUSTOMERNUMBER PK
        string FIRSTNAME
        string LASTNAME
        string DATEOFBIRTH
        string HOUSENAME
        string HOUSENUMBER
        string POSTCODE
        string PHONEMOBILE
        string PHONEHOME
        string EMAILADDRESS
    }

    POLICY {
        int POLICYNUMBER PK
        int CUSTOMERNUMBER FK
        string POLICYTYPE
        string ISSUEDATE
        string EXPIRYDATE
    }

    MOTOR {
        int POLICYNUMBER PK,FK
        string MAKE
        string MODEL
        string VALUE
        string RESSION
        string MESSION
        string PESSION
        string ACCIDENTS
    }

    ENDOWMENT {
        int POLICYNUMBER PK,FK
        string WITHPROFITS
        string EQUITIES
        string MANAGEDFD
        string FUNDNAME
        string TERM
        string SUMASSURED
        string LIFEASSURED
    }

    HOUSE {
        int POLICYNUMBER PK,FK
        string PROPERTYTYPE
        string BEDROOMS
        string VALUE
        string HOUSENAME
        string HOUSENUMBER
        string POSTCODE
    }

    COMMERCIAL {
        int POLICYNUMBER PK,FK
        string REQUESTDATE
        string PAYMENTDATE
        string BROKERID
        string BROKERSREF
        string PAYMENT
    }

    CUSTOMER ||--o{ POLICY : "has"
    POLICY ||--o| MOTOR : "is"
    POLICY ||--o| ENDOWMENT : "is"
    POLICY ||--o| HOUSE : "is"
    POLICY ||--o| COMMERCIAL : "is"
```

## ネットワーク構成図

```mermaid
graph LR
    subgraph "Client Network"
        TERM["3270 Terminal<br/>Emulator"]
        WEB["Web Browser"]
    end

    subgraph "z/OS Network Stack"
        VTAM["VTAM/TN3270"]
        TCPIP["TCP/IP Stack"]
    end

    subgraph "CICS Services"
        CICS_TERM["CICS Terminal<br/>Management"]
        CICS_WEB["CICS Web<br/>Services"]
    end

    TERM --> VTAM
    VTAM --> CICS_TERM

    WEB --> TCPIP
    TCPIP --> CICS_WEB

    style TERM fill:#f9f,stroke:#333
    style WEB fill:#f9f,stroke:#333
```

## 凡例

| 記号 | 意味 |
|------|------|
| 実線矢印 | 必須のデータフロー/接続 |
| 点線矢印 | オプションの接続（Coupling Facility利用時） |
| 円筒形 | データストア（DB2/VSAM） |
| 長方形 | プログラム/サービス |
| 角丸長方形 | ユーザーインターフェース |
