# インフラ設計書

## 概要

本ドキュメントは、IBM CICS Transaction Server for z/OS上で動作する汎用保険アプリケーション（GenApp）のインフラ構成を定義する設計書です。本システムはz/OSメインフレーム環境において、3270端末インターフェースを通じて保険契約および顧客情報の管理を行います。

## システム構成

### 全体構成

本システムはIBM z/OSメインフレーム上で稼働するCICS Transaction Server（CICS TS）を基盤としたオンライントランザクション処理システムです。構成要素は以下の通りです：

- **CICS リージョン**: アプリケーション実行環境
- **Db2 データベース**: 顧客・保険契約データの永続化
- **VSAM ファイル**: 顧客・契約データのファイルストレージ
- **Coupling Facility（オプション）**: Named Counter Server、共有一時ストレージキュー

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| z/OS LPAR | メインフレーム論理区画 | z/OS対応メインフレーム | 1以上 |
| CICS リージョン | トランザクション処理サーバー | CICS TS V4.1以降 | 1（単一リージョン構成）または複数（トポロジ構成） |
| Db2 サブシステム | リレーショナルデータベース | IBM Db2 for z/OS | 1 |
| Named Counter Server（オプション） | 一意番号生成サーバー | CICS Named Counter Server | 1 |
| Temporary Storage Server（オプション） | 共有一時ストレージサーバー | CICS TS Queue Server | 1 |

### ネットワーク構成

| 接続種別 | プロトコル | ポート | 用途 |
| --- | --- | --- | --- |
| 3270 端末接続 | TN3270/SNA | 標準3270ポート | ユーザーインターフェース |
| TCP/IP サービス | HTTP/SOAP | GENATCP1定義による | Webサービスアクセス |
| Db2 接続 | DRDA | Db2アタッチメント | データベースアクセス |
| Coupling Facility | XCF | - | Named Counter/TSQ共有 |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| IBM CICS Transaction Server for z/OS | V4.1以降（推奨V5.4+） | トランザクション処理基盤 |
| IBM Db2 for z/OS | V12以降 | リレーショナルデータベース |
| IBM COBOL for z/OS | V6.1以降 | アプリケーション実行環境 |
| IBM Language Environment | - | ランタイム環境 |
| IBM Workload Simulator for z/OS（オプション） | V1.1以降 | 負荷テスト |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Db2 サブシステム | 顧客・契約データの永続化 | DB2CONN リソース定義による接続 |
| Named Counter Server | 顧客番号の一意採番 | EXEC CICS GET COUNTER API |
| Shared TS Queue Server | 制御情報・エラー情報の共有 | EXEC CICS WRITEQ TS API |

## ストレージ設計

### データセット構成

| データセット名 | 種別 | 用途 |
| --- | --- | --- |
| *userid*.GENAPP.LOAD | PDS | COBOLコンパイル済みロードモジュール |
| *userid*.GENAPP.CNTL | PDS | JCL制御ファイル |
| *userid*.GENAPP.EXEC | PDS | REXXスクリプト |
| *userid*.GENAPP.SRC | PDS | COBOLソースプログラム |
| *userid*.GENAPP.KSDSCUST | VSAM KSDS | 顧客データファイル |
| *userid*.GENAPP.KSDSPOLY | VSAM KSDS | 契約データファイル |
| *userid*.GENAPP.DFHCSD | VSAM | CSD定義ファイル |

### Db2 オブジェクト構成

| オブジェクト種別 | 名称 | 用途 |
| --- | --- | --- |
| ストレージグループ | GENAPP | データ格納領域 |
| データベース | GENASA1（設定可能） | アプリケーションデータベース |
| テーブル | CUSTOMER | 顧客情報 |
| テーブル | POLICY | 契約情報（マスター） |
| テーブル | MOTOR | 自動車保険契約 |
| テーブル | ENDOWMENT | 養老保険契約 |
| テーブル | HOUSE | 住宅保険契約 |
| テーブル | COMMERCIAL | 事業用不動産保険契約 |

### VSAM ファイル構成

| ファイル名 | キー長 | レコード長 | 用途 |
| --- | --- | --- | --- |
| KSDSCUST | 10バイト | 可変長 | 顧客レコード |
| KSDSPOLY | 21バイト | 可変長 | 契約レコード |

## スケーリング設計

### 水平スケーリング

本システムはCICSPlex SMによるトポロジ管理をサポートしており、以下のスケーリングが可能です：

1. **単一リージョン構成**: 開発・テスト環境向け
2. **トポロジ構成（CDEF122）**: 複数CICSリージョンによる負荷分散
3. **ワークロード管理構成（CDEF123）**: CICSPlex SM WLMによる動的ルーティング

### スケーリングパラメータ

| パラメータ | 設定値 | 説明 |
| --- | --- | --- |
| GRPLIST | (DFHLIST,GENALIST) | CICS起動時ロードグループ |
| DB2CONN | YES | Db2接続有効化 |
| NCPLDFT | GENA | デフォルトNamed Counterプール |

## 可用性設計

### 冗長構成

| コンポーネント | 冗長化方式 | フェイルオーバー |
| --- | --- | --- |
| CICS リージョン | CICSPlex SM トポロジ | 自動ワークロード分散 |
| Db2 | Db2 Data Sharing（オプション） | Db2標準フェイルオーバー |
| Coupling Facility | Sysplex冗長構成 | 自動切替 |

### データ整合性

- 2フェーズコミットによるDb2-VSAM間のデータ整合性確保
- トランザクション単位でのロールバック対応

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| Db2 データベース | Db2 BACKUP/RECOVER | 日次（推奨） | 運用要件に依存 |
| VSAM ファイル | IDCAMS REPRO/DFSMShsm | 日次（推奨） | 運用要件に依存 |
| CSD 定義 | DFHCSDUP EXTRACT | 変更時 | 世代管理 |
| ロードライブラリ | PDSバックアップ | デプロイ時 | 世代管理 |

## 監視設計

### 監視項目

| 監視対象 | 監視方法 | アラート条件 |
| --- | --- | --- |
| CICS リージョン | CICS System Log | 異常終了、リソース枯渇 |
| Db2 接続 | DB2CONN ステータス | 接続断 |
| トランザクション | CICS Statistics | レスポンス遅延、ABEND |
| TSQ | Named Counter/TSQ | キュー溢れ |

### イベント監視

本システムはCICS Event Binding機能をサポートしており、Transaction_Counters.evbindによるトランザクションカウンタのイベント監視が可能です。

## セキュリティ設計

### 認証・認可

| 項目 | 方式 |
| --- | --- |
| ユーザー認証 | RACF/外部セキュリティマネージャー |
| Db2 アクセス制御 | RACF SQLID認可 |
| CICS リソースアクセス | CICSリソースセキュリティ |

## CICS リソース定義

### 主要リソース

| リソース名 | 種別 | 用途 |
| --- | --- | --- |
| *DB2SSID* | DB2CONN | Db2アタッチメント定義 |
| GENAMOD | ENQMODEL | 共有TSQ更新用エンキュー |
| GENAEV01 | BUNDLE | イベントバインディング・アダプタ |
| GENAPIP1 | PIPELINE | Webサービスパイプライン |
| GENASTST | TSMODEL | 共有TSQモデル |
| GENATCP1 | TCPIPSERVICE | TCP/IP接続定義 |
| KSDSCUST | FILE | 顧客VSAMファイル |
| KSDSPOLY | FILE | 契約VSAMファイル |

## 備考

### 前提条件

- IBM z/OSオペレーティングシステム環境が必要
- CICS TS V4.1以降がインストールされていること
- IBM Db2 for z/OSがインストール・構成されていること
- COBOLコンパイラが利用可能であること

### オプション機能

以下の機能はCoupling Facilityへのアクセスが必要です：

1. Named Counter Server（一意顧客番号採番）
2. Shared Temporary Storage Queue（制御・エラー情報共有）

これらが利用できない環境では、Db2による採番機能で代替可能です。

### 構成変更時の注意

- リソース定義変更時はCSD更新後、CICSリージョン再起動が必要
- Db2スキーマ変更時は@DB2DELによる再作成または手動ALTER実行
