# セキュリティ設計書 根拠レポート

## 1. レポート概要

### 1.1 目的
本レポートは、セキュリティ設計書に記載された内容の根拠となるソースコード、設定ファイル、および分析結果を示す。

### 1.2 分析対象
- **プロジェクト**: General Insurance Application (GenApp)
- **パス**: `/Users/tomokababa/Work/route06/cics-genapp-main`
- **分析日**: 2026-01-06

---

## 2. 分析したファイル一覧

### 2.1 COBOLソースファイル

| ファイルパス | 主要機能 | セキュリティ関連度 |
|-------------|---------|-------------------|
| `base/src/lgacdb01.cbl` | 顧客追加（Db2） | 高 |
| `base/src/lgacdb02.cbl` | 顧客セキュリティ追加 | 最高 |
| `base/src/lgicdb01.cbl` | 顧客照会（Db2） | 高 |
| `base/src/lgicus01.cbl` | 顧客照会ビジネスロジック | 中 |
| `base/src/lgacus01.cbl` | 顧客追加ビジネスロジック | 中 |
| `base/src/lgucus01.cbl` | 顧客更新ビジネスロジック | 中 |
| `base/src/lgupdb01.cbl` | 保険更新（Db2） | 高 |
| `base/src/lgdpdb01.cbl` | 保険削除（Db2） | 高 |
| `base/src/lgwebst5.cbl` | 統計収集 | 低 |
| `base/src/lgcmarea.cpy` | COMMAREA定義 | 高 |

### 2.2 JCL・設定ファイル

| ファイルパス | 内容 | セキュリティ関連度 |
|-------------|------|-------------------|
| `base/cntl/db2cre.jcl` | Db2オブジェクト作成 | 最高 |

### 2.3 ドキュメント

| ファイルパス | 内容 |
|-------------|------|
| `README.md` | プロジェクト概要 |
| `base/Architecture.md` | アーキテクチャ説明 |
| `base/Installation.md` | インストール手順 |
| `base/Reference.md` | リファレンス情報 |

---

## 3. 根拠詳細

### 3.1 認証メカニズム

#### 3.1.1 CUSTOMER_SECUREテーブル定義

**根拠ファイル**: `base/cntl/db2cre.jcl`（行122-136）

```sql
CREATE TABLE <DB2DBID>.customer_secure (
     customerNumber INTEGER NOT NULL,
     customerPass   CHAR(32),
     state_indicator CHAR(1),
     pass_changes   INTEGER,
   PRIMARY KEY(customerNumber),
   FOREIGN KEY(customerNumber)
          REFERENCES <DB2DBID>.customer (customerNumber)
          ON DELETE CASCADE)
```

**信頼度**: 高（JCL内のSQL DDL文から直接確認）

#### 3.1.2 パスワードハッシュの使用

**根拠ファイル**: `base/src/lgacdb01.cbl`（行181-184）

```cobol
move '5732fec825535eeafb8fac50fee3a8aa'
                    To  D2-CUSTSECR-PASS.
Move '0000'       To  D2-CUSTSECR-COUNT.
Move 'N'          To  D2-CUSTSECR-STATE.
```

**信頼度**: 高（ソースコードから直接確認）

**補足**: 32文字の16進文字列はMD5ハッシュの形式と一致（MD5は128bit = 32文字16進）

#### 3.1.3 セキュリティレコード挿入処理

**根拠ファイル**: `base/src/lgacdb02.cbl`（行161-184）

```cobol
INSERT-CUSTOMER-PASSWORD.
       MOVE ' INSERT SECURITY' TO EM-SQLREQ
       EXEC SQL
         INSERT INTO CUSTOMER_SECURE
                   ( customerNumber,
                     customerPass,
                     state_indicator,
                     pass_changes   )
            VALUES ( :DB2-CUSTOMERNUM-INT,
                     :D2-CUSTSECR-PASS,
                     :D2-CUSTSECR-STATE,
                     :DB2-CUSTOMERCNT-INT)
       END-EXEC
```

**信頼度**: 高（ソースコードから直接確認）

### 3.2 入力検証

#### 3.2.1 COMMAREA長検証

**根拠ファイル**: `base/src/lgacus01.cbl`（行94-115）

```cobol
IF EIBCALEN IS EQUAL TO ZERO
    MOVE ' NO COMMAREA RECEIVED' TO EM-VARIABLE
    PERFORM WRITE-ERROR-MESSAGE
    EXEC CICS ABEND ABCODE('LGCA') NODUMP END-EXEC
END-IF

...

ADD WS-CA-HEADER-LEN TO WS-REQUIRED-CA-LEN
ADD WS-CUSTOMER-LEN  TO WS-REQUIRED-CA-LEN

IF EIBCALEN IS LESS THAN WS-REQUIRED-CA-LEN
  MOVE '98' TO CA-RETURN-CODE
  EXEC CICS RETURN END-EXEC
END-IF
```

**信頼度**: 高（同様のパターンが複数ファイルで確認）

**確認済みファイル**:
- `lgacus01.cbl`（行94-115）
- `lgicus01.cbl`（行87-107）
- `lgucus01.cbl`（行99-113）
- `lgicdb01.cbl`（行119-143）
- `lgdpdb01.cbl`（行131-146）

#### 3.2.2 リクエストID検証

**根拠ファイル**: `base/src/lgucus01.cbl`（行110-113）

```cobol
If CA-REQUEST-ID NOT = '01UCUS'
    MOVE '99' TO CA-RETURN-CODE
    GO TO END-PROGRAM
END-IF.
```

**根拠ファイル**: `base/src/lgdpdb01.cbl`（行160-172）

```cobol
IF ( CA-REQUEST-ID NOT EQUAL TO '01DEND' AND
     CA-REQUEST-ID NOT EQUAL TO '01DHOU' AND
     CA-REQUEST-ID NOT EQUAL TO '01DCOM' AND
     CA-REQUEST-ID NOT EQUAL TO '01DMOT' ) Then
    MOVE '99' TO CA-RETURN-CODE
ELSE
    PERFORM DELETE-POLICY-DB2-INFO
    ...
END-IF.
```

**信頼度**: 高（ソースコードから直接確認）

### 3.3 SQLインジェクション対策

#### 3.3.1 ホスト変数の使用

**根拠ファイル**: `base/src/lgicdb01.cbl`（行169-190）

```cobol
EXEC SQL
    SELECT FIRSTNAME,
           LASTNAME,
           DATEOFBIRTH,
           HOUSENAME,
           HOUSENUMBER,
           POSTCODE,
           PHONEMOBILE,
           PHONEHOME,
           EMAILADDRESS
    INTO  :CA-FIRST-NAME,
          :CA-LAST-NAME,
          :CA-DOB,
          :CA-HOUSE-NAME,
          :CA-HOUSE-NUM,
          :CA-POSTCODE,
          :CA-PHONE-MOBILE,
          :CA-PHONE-HOME,
          :CA-EMAIL-ADDRESS
    FROM CUSTOMER
    WHERE CUSTOMERNUMBER = :DB2-CUSTOMERNUMBER-INT
END-EXEC.
```

**信頼度**: 高（全SQL文でホスト変数を使用していることを確認）

**確認済みファイル**:
- `lgicdb01.cbl`（SELECT文）
- `lgacdb01.cbl`（INSERT文）
- `lgacdb02.cbl`（INSERT文）
- `lgupdb01.cbl`（UPDATE文、SELECT FOR UPDATE）
- `lgdpdb01.cbl`（DELETE文）

### 3.4 データベース権限設定

#### 3.4.1 PUBLIC権限の付与

**根拠ファイル**: `base/cntl/db2cre.jcl`（行385-401）

```sql
GRANT DBADM ON DATABASE <DB2DBID>      TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS01 TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS02 TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS03 TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS04 TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS05 TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS06 TO PUBLIC;
GRANT USE OF TABLESPACE <DB2DBID>.GENATS07 TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.customer TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.policy   TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.motor    TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.house    TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.endowment TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.commercial TO PUBLIC;
GRANT ALL PRIVILEGES ON TABLE <DB2DBID>.claim    TO PUBLIC;
```

**信頼度**: 高（JCLから直接確認）

**セキュリティリスク評価**: このサンプルアプリケーションでは開発・テスト目的でPUBLIC権限が付与されているが、本番環境では適切なロールベースアクセス制御が必要。

### 3.5 COMMAREA構造

#### 3.5.1 データ構造定義

**根拠ファイル**: `base/src/lgcmarea.cpy`（全体）

```cobol
    03 CA-REQUEST-ID            PIC X(6).
    03 CA-RETURN-CODE           PIC 9(2).
    03 CA-CUSTOMER-NUM          PIC 9(10).
    03 CA-REQUEST-SPECIFIC      PIC X(32482).
*    Fields used in INQ All and ADD customer
    03 CA-CUSTOMER-REQUEST REDEFINES CA-REQUEST-SPECIFIC.
       05 CA-FIRST-NAME         PIC X(10).
       05 CA-LAST-NAME          PIC X(20).
       05 CA-DOB                PIC X(10).
       05 CA-HOUSE-NAME         PIC X(20).
       05 CA-HOUSE-NUM          PIC X(4).
       05 CA-POSTCODE           PIC X(8).
       05 CA-NUM-POLICIES       PIC 9(3).
       05 CA-PHONE-MOBILE       PIC X(20).
       05 CA-PHONE-HOME         PIC X(20).
       05 CA-EMAIL-ADDRESS      PIC X(100).
       05 CA-POLICY-DATA        PIC X(32267).
*    Fields used in Customer security call
    03 CA-CUSTSECR-REQUEST REDEFINES CA-REQUEST-SPECIFIC.
       05 CA-CUSTSECR-PASS      PIC X(32).
       05 CA-CUSTSECR-COUNT     PIC X(4).
       05 CA-CUSTSECR-STATE     PIC X.
       05 CA-CUSTSECR-DATA      PIC X(32445).
```

**信頼度**: 高（コピーブックから直接確認）

### 3.6 エラー処理

#### 3.6.1 エラーメッセージ構造

**根拠ファイル**: `base/src/lgacdb01.cbl`（行46-56）

```cobol
01  ERROR-MSG.
    03 EM-DATE                  PIC X(8)  VALUE SPACES.
    03 FILLER                   PIC X     VALUE SPACES.
    03 EM-TIME                  PIC X(6)  VALUE SPACES.
    03 FILLER                   PIC X(9)  VALUE ' LGACDB01'.
    03 EM-VARIABLE.
      05 FILLER                 PIC X(6)  VALUE ' CNUM='.
      05 EM-CUSNUM              PIC X(10)  VALUE SPACES.
      05 EM-SQLREQ              PIC X(16) VALUE SPACES.
      05 FILLER                 PIC X(9)  VALUE ' SQLCODE='.
      05 EM-SQLRC               PIC +9(5) USAGE DISPLAY.
```

**信頼度**: 高（同様のパターンが全プログラムで確認）

#### 3.6.2 エラーログ出力処理

**根拠ファイル**: `base/src/lgacdb01.cbl`（行295-328）

```cobol
WRITE-ERROR-MESSAGE.
* Save SQLCODE in message
    MOVE SQLCODE TO EM-SQLRC
* Obtain and format current time and date
    EXEC CICS ASKTIME ABSTIME(WS-ABSTIME)
    END-EXEC
    EXEC CICS FORMATTIME ABSTIME(WS-ABSTIME)
              MMDDYYYY(WS-DATE)
              TIME(WS-TIME)
    END-EXEC
    MOVE WS-DATE TO EM-DATE
    MOVE WS-TIME TO EM-TIME
* Write output message to TDQ
    EXEC CICS LINK PROGRAM('LGSTSQ')
              COMMAREA(ERROR-MSG)
              LENGTH(LENGTH OF ERROR-MSG)
    END-EXEC.
```

**信頼度**: 高（全プログラムで同様の処理を確認）

### 3.7 楽観的ロック

#### 3.7.1 タイムスタンプ比較

**根拠ファイル**: `base/src/lgupdb01.cbl`（行276-347）

```cobol
IF CA-LASTCHANGED EQUAL TO DB2-LASTCHANGED
    ...
    PERFORM UPDATE-ENDOW-DB2-INFO
    ...
    EXEC SQL
      UPDATE POLICY
        SET ISSUEDATE        = :CA-ISSUE-DATE,
            EXPIRYDATE       = :CA-EXPIRY-DATE,
            LASTCHANGED      = CURRENT TIMESTAMP ,
            ...
        WHERE CURRENT OF POLICY_CURSOR
    END-EXEC
    ...
ELSE
*   Timestamps do not match (policy table v commarea)
    MOVE '02' TO CA-RETURN-CODE
END-IF
```

**信頼度**: 高（ソースコードから直接確認）

### 3.8 参照整合性

#### 3.8.1 外部キー制約

**根拠ファイル**: `base/cntl/db2cre.jcl`

顧客-セキュリティ関連（行128-130）:
```sql
FOREIGN KEY(customerNumber)
       REFERENCES <DB2DBID>.customer (customerNumber)
       ON DELETE CASCADE
```

保険-顧客関連（行166-168）:
```sql
FOREIGN KEY(customerNumber)
       REFERENCES <DB2DBID>.customer (customerNumber)
       ON DELETE CASCADE
```

保険詳細-保険関連（行206-208）:
```sql
FOREIGN KEY(policyNumber)
       REFERENCES <DB2DBID>.policy (policyNumber)
       ON DELETE CASCADE
```

**信頼度**: 高（JCLから直接確認）

---

## 4. 信頼度評価

### 4.1 信頼度レベル定義

| レベル | 定義 |
|-------|------|
| 最高 | ソースコード/設定ファイルから直接確認、複数箇所で一貫性あり |
| 高 | ソースコード/設定ファイルから直接確認 |
| 中 | ドキュメントまたは間接的証拠から推測 |
| 低 | 一般的なパターンからの推測 |

### 4.2 セクション別信頼度

| セクション | 信頼度 | 根拠数 |
|-----------|--------|--------|
| 認証メカニズム | 高 | 3 |
| 入力検証 | 高 | 7 |
| SQLインジェクション対策 | 高 | 5 |
| データベース権限 | 高 | 1 |
| COMMAREA構造 | 高 | 1 |
| エラー処理 | 高 | 複数 |
| 楽観的ロック | 高 | 1 |
| 参照整合性 | 高 | 3 |

### 4.3 全体信頼度

**総合評価**: 高

全てのセキュリティ設計書の記述は、ソースコードまたは設定ファイルから直接確認された内容に基づいている。

---

## 5. 未確認事項・制限

### 5.1 分析の制限

1. **実行時動作**: 静的コード分析のみ実施。実行時の動作は未検証。
2. **CICS設定**: CICSシステム定義（SIT、CSD）の詳細は未分析。
3. **ネットワーク設定**: AT-TLS等の通信暗号化設定は未確認。
4. **RACF/SAF**: 外部セキュリティマネージャーとの統合は未分析。

### 5.2 追加調査推奨事項

1. CICSリソース定義（CSD）の詳細分析
2. Db2バインドオプションの確認
3. JESセキュリティ設定の確認
4. 実環境でのペネトレーションテスト

---

## 6. 改訂履歴

| バージョン | 日付 | 変更内容 | 作成者 |
|-----------|------|---------|--------|
| 1.0 | 2026-01-06 | 初版作成 | Claude Code |
