---
generated_at: 2026-01-06 15:50:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **カバレッジ目標数値**：目標値は推奨値として記載、プロジェクト固有の要件定義なし
  2. **不具合管理分類**：一般的なベストプラクティスに基づく、プロジェクト固有定義なし
  3. **CI/CD推奨改善事項**：現行構成に対する提案、実現可能性の検証が必要
  4. **対応期限設定**：一般的な基準に基づく、組織固有のSLA定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、前提条件（CICS TS V4.1以上、Db2）
- E-02: `base/README.md` - アプリケーション概要、機能一覧
- E-03: `base/Architecture.md` - アプリケーションアーキテクチャ、3層構造、データストア
- E-04: `base/Testing.md` - テスト手順、トランザクション実行方法
- E-05: `base/Reference.md` - トランザクション一覧、プログラム一覧、リソース定義
- E-06: `base/src/*.cbl` - COBOLソースコード（32プログラム）
- E-07: `base/wsim/` - Workload Simulatorスクリプト（39ファイル）
- E-08: `base/wsim/genapp.txt` - Workload Simulator設定、テストパス定義
- E-09: `base/exec/*.rexx` - REXXスクリプト（cust1.rexx、mac1.rexx）
- E-10: `base/data/` - 初期テストデータ（ksdscust.txt、ksdspoly.txt）
- E-11: `base/cntl/*.jcl` - JCLジョブ定義（30ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GenAppはCOBOLで記述されたレガシーアプリケーション | E-06 | ○ |
| C-02 | 3270端末インターフェースを使用 | E-03, E-04 | ○ |
| C-03 | Db2データベースを使用 | E-01, E-03 | ○ |
| C-04 | VSAMファイルを使用 | E-03 | ○ |
| C-05 | 3層構造（プレゼンテーション、ビジネスロジック、データ管理） | E-03 | ○ |
| C-06 | EXEC CICS LINK PROGRAMによるプログラム間連携 | E-03 | ○ |
| C-07 | 2フェーズコミット処理（Db2/VSAM） | E-03 | ○ |
| C-08 | 10種類のトランザクション（LGSE, LGCF, LGPF, LGST, SSC1, SSP1-4, SSST） | E-05 | ○ |
| C-09 | 32種類のプログラム | E-05, E-06 | ○ |
| C-10 | CICS TS V4.1以上が前提 | E-01, E-02 | ○ |
| C-11 | Workload Simulatorによるテスト自動化 | E-07, E-08 | ○ |
| C-12 | REXXスクリプトによるテストデータ生成 | E-09 | ○ |
| C-13 | 初期顧客データ10件（ksdscust.txt） | E-10 | ○ |
| C-14 | 初期保険契約データ10件（ksdspoly.txt） | E-10 | ○ |
| C-15 | @ITENTRジョブによるWorkload Simulator実行 | E-11 | ○ |
| C-16 | @ITPLLジョブによるログフォーマット | E-11 | ○ |
| C-17 | @COBOLジョブによるコンパイル | E-11 | ○ |
| C-18 | @ASMMAPジョブによるBMSマップアセンブル | E-11 | ○ |
| C-19 | @DB2BINDジョブによるDb2バインド | E-11 | ○ |
| C-20 | @DB2DEL/@DB2CREジョブによるデータベース再作成 | E-11 | ○ |
| C-21 | GENAERRSキューでDb2エラーを監視 | E-03 | ○ |
| C-22 | Named Counter Serverによる顧客番号採番 | E-03 | ○ |
| C-23 | Coupling Facility使用 | E-03 | ○ |
| C-24 | CICSPlex SMによるトポロジー管理対応 | E-02, E-05 | ○ |
| C-25 | Webサービス対応（GENAPIP1パイプライン） | E-05 | ○ |
| C-26 | 顧客管理機能（追加、照会、更新） | E-04, E-05 | ○ |
| C-27 | 4種類の保険契約（モーター、養老、住宅、商業物件） | E-03, E-05 | ○ |
| C-28 | LGSEトランザクションで環境初期化 | E-04 | ○ |
| C-29 | カバレッジ目標100%（トランザクション、プログラム、業務シナリオ） | **根拠なし** | △ |
| C-30 | 不具合重要度分類（Critical/High/Medium/Low） | **根拠なし** | △ |
| C-31 | CI/CDパイプライン未構成 | E-11（GitHub Actions等の構成ファイルなし） | ○ |
| C-32 | Zowe CLI/IBM DBB導入推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値**: プロジェクト固有の品質目標定義書が存在しない。記載値は業界標準のベストプラクティスに基づく推奨値。
  - 候補：品質管理計画書 / プロジェクト計画書 / SLA定義書
- **不具合管理分類・対応期限**: 組織固有の不具合管理規定が存在しない。一般的なITIL/ベストプラクティスに基づく。
  - 候補：不具合管理規定 / 品質管理基準書 / SLA定義書
- **CI/CD推奨改善事項**: 現行プロジェクトの制約・要件が不明。技術的な実現可能性の検証が必要。
  - 候補：インフラ構成書 / 技術選定基準 / ロードマップ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - アプリケーション構造、トランザクション一覧、プログラム一覧（ソースコードから確認可能）
- **0: 低リスク** - テストツール（Workload Simulator）の記載（実際のスクリプトファイルで確認可能）
- **1: 中リスク** - カバレッジ目標値（プロジェクト固有の要件確認が必要）
- **1: 中リスク** - 不具合管理プロセス（組織の既存プロセスとの整合性確認が必要）
- **1: 中リスク** - CI/CD推奨改善事項（実現可能性・コストの検証が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] テストレベルの定義が組織の品質管理基準と整合しているか確認
- [ ] カバレッジ目標値がプロジェクトの品質要件を満たしているか確認
- [ ] 不具合管理の分類・対応期限が組織のSLAと整合しているか確認
- [ ] テスト環境構成が実際のインフラ構成と一致しているか確認
- [ ] Workload Simulatorスクリプトが最新のテストケースを反映しているか確認
- [ ] CI/CD推奨改善事項の実現可能性を技術チームと協議
