# テスト方針書

## 概要

本ドキュメントは、IBM CICS TS向け汎用保険アプリケーション（GenApp）のテスト方針を定義するものである。GenAppはCOBOLで記述されたレガシーアプリケーションであり、3270端末インターフェース、Db2データベース、VSAMファイルを使用して保険顧客情報と保険契約情報を管理する。本テスト方針書では、アプリケーションの品質保証に必要なテストレベル、テスト種別、テスト環境、およびテスト実施体制を明確化する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 各COBOLプログラム（プレゼンテーションロジック、ビジネスロジック、データ管理ロジック）の個別機能検証 | 開発チーム |
| 結合テスト | プログラム間連携（EXEC CICS LINK PROGRAM）、Db2/VSAM連携、2フェーズコミット処理の検証 | 開発チーム/テストチーム |
| システムテスト | CICSリージョン上での全トランザクション（SSC1、SSP1-4、LGSE等）の総合動作検証 | テストチーム |
| 受入テスト | 顧客情報・保険契約の登録・照会・更新・削除シナリオの業務観点での検証 | 業務部門/QAチーム |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 顧客管理機能（追加、照会、更新）、保険契約管理機能（モーター、養老、住宅、商業物件保険）の正常系・異常系テスト | 各テストレベルで実施 |
| 性能テスト | Workload Simulatorを使用したトランザクション処理性能、同時実行性能の検証 | システムテスト段階 |
| セキュリティテスト | CICSトランザクションセキュリティ、Db2アクセス権限、RACFセキュリティの検証 | 結合テスト・システムテスト段階 |
| 回帰テスト | 機能変更・バグ修正後の既存機能への影響確認 | 随時（変更発生時） |
| データ整合性テスト | Db2とVSAMファイル間の2フェーズコミット処理、ロールバック処理の検証 | 結合テスト段階 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| 開発環境 | 単体テスト、開発者によるデバッグ | CICS TS V4.1以上、Db2、VSAM、単一リージョン構成 |
| テスト環境 | 結合テスト、システムテスト | CICS TS V4.1以上、Db2、VSAM、Coupling Facility（Named Counter Server、TSQサポート） |
| 負荷テスト環境 | 性能テスト、負荷テスト | CICS TS V4.1以上、Db2、VSAM、Workload Simulator、CICSPlex SM |
| ステージング環境 | 受入テスト | 本番同等構成（CICS TS V4.1以上、Db2、VSAM、Coupling Facility） |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| IBM Workload Simulator | 3270トランザクションの自動実行・負荷テスト | 対応バージョン |
| REXX スクリプト | 顧客データ生成（cust1.rexx）、テストデータ作成（mac1.rexx） | N/A |
| CICS Transaction Gateway | Webサービス経由テスト | 対応バージョン |
| Db2 SPUFI | SQLデータ検証、テストデータ準備 | 対応バージョン |
| CICS Interdependency Analyzer | プログラム間依存関係分析 | 対応バージョン |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| トランザクションカバレッジ | 100%（全10トランザクション: LGSE, LGCF, LGPF, LGST, SSC1, SSP1-4, SSST） |
| プログラムカバレッジ | 100%（全32プログラム） |
| 業務シナリオカバレッジ | 100%（顧客登録・照会・更新、各保険契約の登録・照会・更新・削除） |
| データパスカバレッジ | 90%以上（Db2パス、VSAMパス、Named Counter Serverパス） |

## テストデータ

### テストデータ準備方針

1. **初期データセット**: `base/data/`ディレクトリに格納されている以下のデータを使用
   - `ksdscust.txt`: 顧客マスタデータ（10件の初期顧客データ）
   - `ksdspoly.txt`: 保険契約データ（10件のサンプル契約データ）

2. **テストデータ生成**:
   - `cust1.rexx`: 顧客データの自動生成
   - `mac1.rexx`: テストデータの準備
   - Workload Simulatorスクリプト（`wsim/`）: 各トランザクション用テストデータ

3. **データ管理ルール**:
   - 顧客番号: 1-10は初期データとして予約、11以降をテスト用に使用
   - 保険契約番号: Db2のINSERTで自動採番
   - テスト実行前にLGSEトランザクションで制御テーブルを初期化

4. **データクリーンアップ**:
   - `@DB2DEL`ジョブによるデータベース削除
   - `@DB2CRE`ジョブによる再作成
   - GENAERRSキュー（エラーログ）のクリア

## 不具合管理

### 不具合分類

| 重要度 | 定義 | 対応期限 |
| --- | --- | --- |
| Critical | システム停止、データ損失に繋がる不具合 | 即時対応 |
| High | 主要機能が使用不可、回避策なし | 2営業日以内 |
| Medium | 機能制限あり、回避策あり | 次回リリースまで |
| Low | 軽微な問題、ユーザビリティ改善 | 将来リリースで対応 |

### 不具合記録項目

1. 不具合ID
2. 発見日時
3. 発見フェーズ（単体/結合/システム/受入）
4. 不具合概要
5. 再現手順
6. 期待結果と実際結果
7. 関連トランザクション/プログラム
8. 重要度
9. 担当者
10. 対応状況

### エラー監視

- GENAERRSテンポラリストレージキューでDb2エラーを監視
- CICSトランザクションダンプの確認
- Db2エラーログの確認

## CI/CD連携

### 現状

本プロジェクトはレガシーメインフレームアプリケーションであり、GitHub ActionsなどのモダンCI/CDパイプラインは構成されていない。テスト自動化はWorkload Simulatorを使用したバッチジョブで実現する。

### テスト自動化

| ジョブ | 用途 | 実行タイミング |
| --- | --- | --- |
| `@ITPENTR` | Workload Simulatorによる顧客・契約作成テスト | デプロイ後 |
| `@ITPLL` | Workload Simulatorログのフォーマット | テスト完了後 |
| `@ITPSTL` | スクリプト変換 | テストスクリプト更新時 |

### ビルド・デプロイ連携

1. `@COBOL`ジョブでCOBOLプログラムをコンパイル
2. `@ASMMAP`ジョブでBMSマップをアセンブル
3. `@CDEF121`ジョブでCICSリソース定義を更新
4. `@DB2BIND`ジョブでDb2バインド実行
5. LGSEトランザクションで環境初期化
6. テスト実行

### 推奨改善事項

- Zowe CLIを使用したz/OSとの連携自動化
- IBM DBB（Dependency Based Build）の導入検討
- Jenkins/GitHub ActionsとZowe連携によるCI/CDパイプライン構築

## 備考

### プロジェクト特性

1. **アーキテクチャ**: 3層構造（プレゼンテーション層、ビジネスロジック層、データ管理層）
2. **データ永続化**: Db2とVSAMの2フェーズコミット
3. **スケーラビリティ**: CICSPlex SMによるトポロジー管理対応
4. **外部連携**: Webサービス対応（GENAPIP1パイプライン）

### 既知の制約

- Coupling Facilityがない環境では、Named Counter ServerとTSQ機能が制限される
- テストは必ず単一CICSリージョンでの動作確認後、マルチリージョンへ展開

### 参照ドキュメント

- `base/Testing.md`: アプリケーションテスト手順
- `base/Reference.md`: トランザクション・プログラム一覧
- `base/Architecture.md`: アプリケーションアーキテクチャ
- `base/Installation.md`: インストール手順
