# ER図 (Entity Relationship Diagram)

## 概要

本ドキュメントは、General Insurance Application (GenApp) のデータベースエンティティ間の関係をER図として表現しています。

## ER図

```mermaid
erDiagram
    customer ||--o| customer_secure : "has"
    customer ||--o{ policy : "owns"
    policy ||--o| endowment : "is"
    policy ||--o| house : "is"
    policy ||--o| motor : "is"
    policy ||--o| commercial : "is"
    policy ||--o{ claim : "has"

    customer {
        INTEGER customerNumber PK "顧客番号 (自動採番)"
        CHAR_10 firstName "名"
        CHAR_20 lastName "姓"
        DATE dateOfBirth "生年月日"
        CHAR_20 houseName "建物名"
        CHAR_4 houseNumber "番地"
        CHAR_8 postcode "郵便番号"
        CHAR_20 phonehome "自宅電話番号"
        CHAR_20 phonemobile "携帯電話番号"
        CHAR_100 emailaddress "メールアドレス"
    }

    customer_secure {
        INTEGER customerNumber PK,FK "顧客番号"
        CHAR_32 customerPass "パスワードハッシュ"
        CHAR_1 state_indicator "状態インジケータ"
        INTEGER pass_changes "パスワード変更回数"
    }

    policy {
        INTEGER policyNumber PK "保険契約番号 (自動採番)"
        INTEGER customerNumber FK "顧客番号"
        DATE issueDate "発行日"
        DATE expiryDate "有効期限"
        CHAR_1 policyType "契約種別 (M/E/H/C)"
        TIMESTAMP lastChanged "最終更新日時"
        INTEGER brokerId "仲介業者ID"
        CHAR_10 brokersReference "仲介業者参照番号"
        INTEGER payment "支払金額"
        SMALLINT commission "手数料"
    }

    endowment {
        INTEGER policyNumber PK,FK "保険契約番号"
        CHAR_1 equities "株式運用フラグ"
        CHAR_1 withProfits "利益付きフラグ"
        CHAR_1 managedFund "マネージドファンドフラグ"
        CHAR_10 fundName "ファンド名"
        SMALLINT term "期間 (年)"
        INTEGER sumAssured "保証金額"
        CHAR_31 lifeAssured "被保険者名"
        VARCHAR paddingData "パディングデータ"
    }

    house {
        INTEGER policyNumber PK,FK "保険契約番号"
        CHAR_15 propertyType "物件種別"
        SMALLINT bedrooms "寝室数"
        INTEGER value "物件価値"
        CHAR_20 houseName "建物名"
        CHAR_4 houseNumber "番地"
        CHAR_8 postcode "郵便番号"
    }

    motor {
        INTEGER policyNumber PK,FK "保険契約番号"
        CHAR_15 make "メーカー"
        CHAR_15 model "車種"
        INTEGER value "車両価値"
        CHAR_7 regNumber "登録番号"
        CHAR_8 colour "色"
        SMALLINT cc "排気量"
        DATE yearOfManufacture "製造年月日"
        INTEGER premium "保険料"
        INTEGER accidents "事故件数"
    }

    commercial {
        INTEGER PolicyNumber PK,FK "保険契約番号"
        TIMESTAMP RequestDate "申請日時"
        DATE StartDate "開始日"
        DATE RenewalDate "更新日"
        CHAR_255 Address "住所"
        CHAR_8 Zipcode "郵便番号"
        CHAR_11 LatitudeN "緯度"
        CHAR_11 LongitudeW "経度"
        CHAR_255 Customer "顧客名"
        CHAR_255 PropertyType "物件種別"
        SMALLINT FirePeril "火災危険度"
        INTEGER FirePremium "火災保険料"
        SMALLINT CrimePeril "犯罪危険度"
        INTEGER CrimePremium "犯罪保険料"
        SMALLINT FloodPeril "洪水危険度"
        INTEGER FloodPremium "洪水保険料"
        SMALLINT WeatherPeril "気象危険度"
        INTEGER WeatherPremium "気象保険料"
        SMALLINT Status "ステータス"
        CHAR_255 RejectionReason "却下理由"
    }

    claim {
        INTEGER ClaimNumber PK "請求番号 (自動採番)"
        INTEGER PolicyNumber FK "保険契約番号"
        DATE ClaimDate "請求日"
        INTEGER Paid "支払済金額"
        INTEGER Value "請求金額"
        CHAR_255 Cause "原因"
        CHAR_255 Observations "備考"
    }
```

## リレーションシップの説明

### customer - customer_secure (1対0..1)

顧客と顧客セキュリティ情報は1対1の関係です。顧客レコードが存在する場合、対応するセキュリティレコードが存在する可能性があります。customerレコードが削除されると、関連するcustomer_secureレコードも削除されます。

### customer - policy (1対多)

1人の顧客は複数の保険契約を持つことができます。customerレコードが削除されると、その顧客の全ての保険契約も削除されます。

### policy - endowment/house/motor/commercial (1対0..1)

policyテーブルは、保険契約の共通情報を保持する親テーブルです。契約種別(policyType)に応じて、以下のいずれかの子テーブルに詳細情報が格納されます:
- M (Motor): motorテーブル
- E (Endowment): endowmentテーブル
- H (House): houseテーブル
- C (Commercial): commercialテーブル

これは「クラステーブル継承」パターンの実装です。policyレコードが削除されると、対応する詳細テーブルのレコードも削除されます。

### policy - claim (1対多)

1つの保険契約に対して、複数の保険金請求が発生する可能性があります。policyレコードが削除されると、関連する全てのclaimレコードも削除されます。

## 外部キー制約一覧

| 親テーブル | 子テーブル | 親カラム | 子カラム | 削除時動作 |
| --- | --- | --- | --- | --- |
| customer | customer_secure | customerNumber | customerNumber | CASCADE |
| customer | policy | customerNumber | customerNumber | CASCADE |
| policy | endowment | policyNumber | policyNumber | CASCADE |
| policy | house | policyNumber | policyNumber | CASCADE |
| policy | motor | policyNumber | policyNumber | CASCADE |
| policy | commercial | policyNumber | PolicyNumber | CASCADE |
| policy | claim | policyNumber | PolicyNumber | CASCADE |

## インデックス一覧

| テーブル | インデックス名 | カラム | 属性 |
| --- | --- | --- | --- |
| customer | iCustomer | customerNumber | UNIQUE, CLUSTER |
| customer_secure | iCustomer_secure | customerNumber | UNIQUE, CLUSTER |
| policy | iPolicy | policyNumber | UNIQUE, CLUSTER |
| policy | iPolicy2 | customerNumber | - |
| endowment | iEndowment | policyNumber | UNIQUE, CLUSTER |
| house | iHouse | policyNumber | UNIQUE, CLUSTER |
| motor | iMotor | policyNumber | UNIQUE, CLUSTER |
| commercial | iCommercial | PolicyNumber | UNIQUE, CLUSTER |
| claim | iClaim | ClaimNumber | UNIQUE, CLUSTER |
