---
generated_at: 2026-01-06 15:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容(Claim: 主張)を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠(Evidence)が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー(まず見るところ)
- 総合信頼度(derived): **1.00**
  - 根拠あり: 42 / 42、根拠なし: 0
- 優先レビュー(高)
  - 該当なし (全ての主張に根拠あり)

## 2) 参照した情報(Evidence一覧)
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/db2cre.jcl` (Db2テーブル作成JCL - CREATE TABLE文)
- E-02: `base/Architecture.md` (アプリケーションアーキテクチャ文書)
- E-03: `base/Reference.md` (アプリケーションリファレンス文書)
- E-04: `base/README.md` (アプリケーション概要文書)
- E-05: `base/src/lgpolicy.cpy` (COBOL COPYBOOKファイル - DB2構造体定義)
- E-06: `base/src/lgcmarea.cpy` (COBOL COPYBOOKファイル - COMMAREA構造体定義)
- E-07: `base/data/README.md` (サンプルデータREADME)
- E-08: `base/data/ksdscust.txt` (顧客VSAMサンプルデータ)
- E-09: `base/data/ksdspoly.txt` (保険契約VSAMサンプルデータ)

## 3) Claims と根拠の対応(レビューの主戦場)

### テーブル構造に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | customerテーブルは10カラムを持つ | E-01 (L102-116) | ○ |
| C-02 | customerNumber は IDENTITY列で自動採番 (1000001から開始) | E-01 (L103-104) | ○ |
| C-03 | customer_secureテーブルはcustomerと外部キー関係を持つ | E-01 (L128-130) | ○ |
| C-04 | customer_secureのcustomerNumberはON DELETE CASCADE | E-01 (L130) | ○ |
| C-05 | policyテーブルはcustomerと外部キー関係を持つ | E-01 (L166-168) | ○ |
| C-06 | policyNumber は IDENTITY列で自動採番 (1000001から開始) | E-01 (L154-155) | ○ |
| C-07 | policyType は CHAR(1) で契約種別を表す | E-01 (L159), E-02 (L89-94) | ○ |
| C-08 | endowmentテーブルはpolicyと外部キー関係を持つ | E-01 (L206-208) | ○ |
| C-09 | houseテーブルはpolicyと外部キー関係を持つ | E-01 (L241-242) | ○ |
| C-10 | motorテーブルはpolicyと外部キー関係を持つ | E-01 (L279-280) | ○ |
| C-11 | commercialテーブルはpolicyと外部キー関係を持つ | E-01 (L327-328) | ○ |
| C-12 | claimテーブルはpolicyと外部キー関係を持つ | E-01 (L363-365) | ○ |
| C-13 | ClaimNumber は IDENTITY列で自動採番 (1000001から開始) | E-01 (L354-355) | ○ |

### カラム定義に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | customer.firstName は CHAR(10) | E-01 (L105), E-05 (L32) | ○ |
| C-15 | customer.lastName は CHAR(20) | E-01 (L106), E-05 (L33) | ○ |
| C-16 | customer.emailaddress は CHAR(100) | E-01 (L113), E-05 (L40) | ○ |
| C-17 | policy.lastChanged は TIMESTAMP NOT NULL WITH DEFAULT | E-01 (L160) | ○ |
| C-18 | endowment.paddingData は VARCHAR(32606) | E-01 (L204) | ○ |
| C-19 | motor.cc は SMALLINT | E-01 (L274) | ○ |
| C-20 | commercial.Address は CHAR(255) | E-01 (L310) | ○ |
| C-21 | claim.Cause は CHAR(255) | E-01 (L360) | ○ |

### インデックスに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | iCustomer は customerNumber に対する UNIQUE CLUSTER インデックス | E-01 (L118-120) | ○ |
| C-23 | iPolicy は policyNumber に対する UNIQUE CLUSTER インデックス | E-01 (L172-174) | ○ |
| C-24 | iPolicy2 は customerNumber に対する非一意インデックス | E-01 (L175-177) | ○ |
| C-25 | 各詳細テーブルにpolicyNumberに対するUNIQUE CLUSTERインデックスが存在 | E-01 (L212-214, L246-248, L284-286, L332-334, L369-371) | ○ |

### テーブルスペース・ストレージに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | GENASG02ストレージグループが存在 | E-01 (L22) | ○ |
| C-27 | GENATS01-07の7つのテーブルスペースが存在 | E-01 (L27-82) | ○ |
| C-28 | GENATS03はBP32Kバッファプールを使用 | E-01 (L50) | ○ |
| C-29 | 全テーブルはCCSID EBCDICで作成 | E-01 (L33, 41, 49, 57, 65, 73, 81, 115, 132, 170, 210, 244, 282, 330, 366) | ○ |

### VSAMファイルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | KSDSCUSTのレコード長は225バイト | E-07 (L30-31) | ○ |
| C-31 | KSDSPOLYのレコード長は64バイト | E-07 (L39-40) | ○ |
| C-32 | KSDSCUSTのキーは先頭10文字(顧客番号) | E-02 (L86-87), E-08 (サンプルデータ) | ○ |
| C-33 | KSDSPOLYのキーは先頭21文字 | E-02 (L88-98) | ○ |
| C-34 | KSDSPOLYのキー構造は契約種別1文字+顧客番号10桁+契約番号10桁 | E-02 (L88-98), E-09 (サンプルデータ) | ○ |

### アプリケーション動作に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | アプリケーションはDb2とVSAMを2フェーズコミットで使用 | E-02 (L48-50) | ○ |
| C-36 | 保険契約種別は M/E/H/C の4種類 | E-02 (L89-94), E-03 (L56-57) | ○ |
| C-37 | 名前付きカウンターサーバーはオプションで顧客番号生成に使用可能 | E-02 (L40-43, L53-58) | ○ |
| C-38 | 全ての削除時にカスケード削除が発生 | E-01 (L130, 168, 208, 242, 280, 328, 365) | ○ |

### リファレンス情報に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | KSDSCUSTはFILEリソースとして定義される | E-03 (L105) | ○ |
| C-40 | KSDSPOLYはFILEリソースとして定義される | E-03 (L106) | ○ |
| C-41 | サンプルデータには10件の顧客レコードが存在 | E-08 (10行のサンプルデータ) | ○ |
| C-42 | サンプルデータには10件の保険契約レコードが存在 | E-03 (L110-123), E-09 | ○ |

## 4) 不足情報(Unknown / Missing)
- なし (全ての主張に対する根拠がソースコードおよび既存文書から確認できました)

## 5) リスクフラグ(レビュー観点)
- **0 (低リスク)**: 全ての主張がソースコード(db2cre.jcl)またはプロジェクト文書から直接確認できています。DDL文からの直接抽出であり、解釈の余地が少ないです。

## 6) レビュアーチェックリスト(最小)
- [ ] db2cre.jcl の CREATE TABLE 文と設計書のカラム定義が一致しているか確認
- [ ] 外部キー制約の ON DELETE CASCADE 設定が業務要件と合致しているか確認
- [ ] VSAMファイルのレコードレイアウトがCOPYBOOK(lgpolicy.cpy, lgcmarea.cpy)と一致しているか確認
- [ ] テーブルスペースの割り当てサイズ(PRIQTY, SECQTY)が本番環境で適切か確認
