# データベース設計書

## 概要

本ドキュメントは、IBM CICS Transaction Server用のGeneral Insurance Application (GenApp) のデータベース設計を記載します。本アプリケーションは、保険会社の顧客情報および保険契約情報を管理するためのシステムであり、IBM Db2データベースとVSAMファイルを使用してデータを永続化します。

## データベース構成

### 使用するデータベース

- **IBM Db2**: 顧客情報、保険契約情報の主要データストア
- **VSAM (Virtual Storage Access Method)**: 顧客レコードおよび保険契約レコードのバックアップ用ファイル

### ストレージグループ・データベース・テーブルスペース

| 名称 | 種別 | 説明 |
| --- | --- | --- |
| GENASG02 | ストレージグループ | GenAppアプリケーション用ストレージグループ |
| (DB2DBID) | データベース | GenAppアプリケーション用データベース |
| GENATS01 | テーブルスペース | customer, customer_secureテーブル用 |
| GENATS02 | テーブルスペース | policyテーブル用 |
| GENATS03 | テーブルスペース | endowmentテーブル用 (32Kバッファプール) |
| GENATS04 | テーブルスペース | houseテーブル用 |
| GENATS05 | テーブルスペース | motorテーブル用 |
| GENATS06 | テーブルスペース | commercialテーブル用 |
| GENATS07 | テーブルスペース | claimテーブル用 |

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| customer | 顧客 | 顧客の基本情報を管理 |
| customer_secure | 顧客セキュリティ | 顧客のパスワード等セキュリティ情報を管理 |
| policy | 保険契約 | 全ての保険契約の共通情報を管理 |
| endowment | 養老保険 | 養老保険固有の情報を管理 |
| house | 住宅保険 | 住宅保険固有の情報を管理 |
| motor | 自動車保険 | 自動車保険固有の情報を管理 |
| commercial | 商業保険 | 商業用不動産保険固有の情報を管理 |
| claim | 保険金請求 | 保険金請求情報を管理 |

## 各テーブル定義

### 1. customer (顧客テーブル)

顧客の基本情報を格納するテーブル。顧客番号は自動採番される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| customerNumber | INTEGER | NOT NULL | 顧客番号 (主キー、自動採番: 1000001から開始) |
| firstName | CHAR(10) | YES | 名 |
| lastName | CHAR(20) | YES | 姓 |
| dateOfBirth | DATE | YES | 生年月日 |
| houseName | CHAR(20) | YES | 建物名 |
| houseNumber | CHAR(4) | YES | 番地 |
| postcode | CHAR(8) | YES | 郵便番号 |
| phonehome | CHAR(20) | YES | 自宅電話番号 |
| phonemobile | CHAR(20) | YES | 携帯電話番号 |
| emailaddress | CHAR(100) | YES | メールアドレス |

**インデックス:**
- iCustomer: customerNumber (UNIQUE, CLUSTER)

### 2. customer_secure (顧客セキュリティテーブル)

顧客のセキュリティ情報を格納するテーブル。customerテーブルと1対1の関係を持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| customerNumber | INTEGER | NOT NULL | 顧客番号 (主キー、外部キー) |
| customerPass | CHAR(32) | YES | パスワードハッシュ (MD5) |
| state_indicator | CHAR(1) | YES | 状態インジケータ |
| pass_changes | INTEGER | YES | パスワード変更回数 |

**インデックス:**
- iCustomer_secure: customerNumber (UNIQUE, CLUSTER)

**外部キー:**
- customerNumber REFERENCES customer(customerNumber) ON DELETE CASCADE

### 3. policy (保険契約テーブル)

全ての保険契約の共通情報を格納する親テーブル。保険契約番号は自動採番される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| policyNumber | INTEGER | NOT NULL | 保険契約番号 (主キー、自動採番: 1000001から開始) |
| customerNumber | INTEGER | NOT NULL | 顧客番号 (外部キー) |
| issueDate | DATE | YES | 発行日 |
| expiryDate | DATE | YES | 有効期限 |
| policyType | CHAR(1) | YES | 契約種別 (M: 自動車, E: 養老, H: 住宅, C: 商業) |
| lastChanged | TIMESTAMP | NOT NULL | 最終更新日時 (デフォルト値あり) |
| brokerId | INTEGER | YES | 仲介業者ID |
| brokersReference | CHAR(10) | YES | 仲介業者参照番号 |
| payment | INTEGER | YES | 支払金額 |
| commission | SMALLINT | YES | 手数料 |

**インデックス:**
- iPolicy: policyNumber (UNIQUE, CLUSTER)
- iPolicy2: customerNumber

**外部キー:**
- customerNumber REFERENCES customer(customerNumber) ON DELETE CASCADE

### 4. endowment (養老保険テーブル)

養老保険固有の情報を格納するテーブル。policyテーブルと1対1の関係を持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| policyNumber | INTEGER | NOT NULL | 保険契約番号 (主キー、外部キー) |
| equities | CHAR(1) | YES | 株式運用フラグ (Y/N) |
| withProfits | CHAR(1) | YES | 利益付きフラグ (Y/N) |
| managedFund | CHAR(1) | YES | マネージドファンドフラグ (Y/N) |
| fundName | CHAR(10) | YES | ファンド名 |
| term | SMALLINT | YES | 期間 (年) |
| sumAssured | INTEGER | YES | 保証金額 |
| lifeAssured | CHAR(31) | YES | 被保険者名 |
| paddingData | VARCHAR(32606) | YES | パディングデータ (テスト用) |

**インデックス:**
- iEndowment: policyNumber (UNIQUE, CLUSTER)

**外部キー:**
- policyNumber REFERENCES policy(policyNumber) ON DELETE CASCADE

### 5. house (住宅保険テーブル)

住宅保険固有の情報を格納するテーブル。policyテーブルと1対1の関係を持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| policyNumber | INTEGER | NOT NULL | 保険契約番号 (主キー、外部キー) |
| propertyType | CHAR(15) | YES | 物件種別 (HOUSE/FARM/FLAT等) |
| bedrooms | SMALLINT | YES | 寝室数 |
| value | INTEGER | YES | 物件価値 |
| houseName | CHAR(20) | YES | 建物名 |
| houseNumber | CHAR(4) | YES | 番地 |
| postcode | CHAR(8) | YES | 郵便番号 |

**インデックス:**
- iHouse: policyNumber (UNIQUE, CLUSTER)

**外部キー:**
- policyNumber REFERENCES policy(policyNumber) ON DELETE CASCADE

### 6. motor (自動車保険テーブル)

自動車保険固有の情報を格納するテーブル。policyテーブルと1対1の関係を持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| policyNumber | INTEGER | NOT NULL | 保険契約番号 (主キー、外部キー) |
| make | CHAR(15) | YES | メーカー |
| model | CHAR(15) | YES | 車種 |
| value | INTEGER | YES | 車両価値 |
| regNumber | CHAR(7) | YES | 登録番号 |
| colour | CHAR(8) | YES | 色 |
| cc | SMALLINT | YES | 排気量 (cc) |
| yearOfManufacture | DATE | YES | 製造年月日 |
| premium | INTEGER | YES | 保険料 |
| accidents | INTEGER | YES | 事故件数 |

**インデックス:**
- iMotor: policyNumber (UNIQUE, CLUSTER)

**外部キー:**
- policyNumber REFERENCES policy(policyNumber) ON DELETE CASCADE

### 7. commercial (商業保険テーブル)

商業用不動産保険固有の情報を格納するテーブル。policyテーブルと1対1の関係を持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| PolicyNumber | INTEGER | NOT NULL | 保険契約番号 (主キー、外部キー) |
| RequestDate | TIMESTAMP | YES | 申請日時 |
| StartDate | DATE | YES | 開始日 |
| RenewalDate | DATE | YES | 更新日 |
| Address | CHAR(255) | YES | 住所 |
| Zipcode | CHAR(8) | YES | 郵便番号 |
| LatitudeN | CHAR(11) | YES | 緯度 |
| LongitudeW | CHAR(11) | YES | 経度 |
| Customer | CHAR(255) | YES | 顧客名 |
| PropertyType | CHAR(255) | YES | 物件種別 |
| FirePeril | SMALLINT | YES | 火災危険度 |
| FirePremium | INTEGER | YES | 火災保険料 |
| CrimePeril | SMALLINT | YES | 犯罪危険度 |
| CrimePremium | INTEGER | YES | 犯罪保険料 |
| FloodPeril | SMALLINT | YES | 洪水危険度 |
| FloodPremium | INTEGER | YES | 洪水保険料 |
| WeatherPeril | SMALLINT | YES | 気象危険度 |
| WeatherPremium | INTEGER | YES | 気象保険料 |
| Status | SMALLINT | YES | ステータス |
| RejectionReason | CHAR(255) | YES | 却下理由 |

**インデックス:**
- iCommercial: PolicyNumber (UNIQUE, CLUSTER)

**外部キー:**
- PolicyNumber REFERENCES policy(policyNumber) ON DELETE CASCADE

### 8. claim (保険金請求テーブル)

保険金請求情報を格納するテーブル。請求番号は自動採番される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ClaimNumber | INTEGER | NOT NULL | 請求番号 (主キー、自動採番: 1000001から開始) |
| PolicyNumber | INTEGER | NOT NULL | 保険契約番号 (外部キー) |
| ClaimDate | DATE | YES | 請求日 |
| Paid | INTEGER | YES | 支払済金額 |
| Value | INTEGER | YES | 請求金額 |
| Cause | CHAR(255) | YES | 原因 |
| Observations | CHAR(255) | YES | 備考 |

**インデックス:**
- iClaim: ClaimNumber (UNIQUE, CLUSTER)

**外部キー:**
- PolicyNumber REFERENCES policy(policyNumber) ON DELETE CASCADE

## VSAMファイル定義

アプリケーションはDb2に加えて、2つのVSAMファイルを使用します。これは2フェーズコミット処理のテスト用に提供されています。

### KSDSCUST (顧客VSAMファイル)

| 項目 | 値 |
| --- | --- |
| ファイル名 | KSDSCUST |
| レコード形式 | 固定長 (FB) |
| レコード長 | 225バイト |
| キー | 先頭10文字 (顧客番号) |
| 用途 | 顧客レコードの格納 |

**レコードレイアウト:**

| 位置 | 長さ | 説明 |
| --- | --- | --- |
| 1-10 | 10 | 顧客番号 |
| 11-20 | 10 | 名 |
| 21-40 | 20 | 姓 |
| 41-50 | 10 | 生年月日 |
| 51-70 | 20 | 建物名 |
| 71-74 | 4 | 番地 |
| 75-82 | 8 | 郵便番号 |
| 83-102 | 20 | 自宅電話番号 |
| 103-122 | 20 | 携帯電話番号 |
| 123-222 | 100 | メールアドレス |

### KSDSPOLY (保険契約VSAMファイル)

| 項目 | 値 |
| --- | --- |
| ファイル名 | KSDSPOLY |
| レコード形式 | 固定長 (FB) |
| レコード長 | 64バイト |
| キー | 先頭21文字 (契約種別1文字 + 顧客番号10文字 + 契約番号10文字) |
| 用途 | 保険契約レコードの格納 |

**キー構造:**
- 位置1: 契約種別 (C: 商業, E: 養老, H: 住宅, M: 自動車)
- 位置2-11: 顧客番号 (10桁)
- 位置12-21: 契約番号 (10桁)

## 備考

### 参照整合性

本データベースは参照整合性を持ち、以下の削除カスケードが設定されています:
- customerレコードが削除されると、関連するcustomer_secure、policyレコードが自動削除される
- policyレコードが削除されると、関連するendowment、house、motor、commercial、claimレコードが自動削除される

### 自動採番

以下のカラムはIDENTITY列として定義され、1000001から開始して自動採番されます:
- customer.customerNumber
- policy.policyNumber
- claim.ClaimNumber

### 文字コード

全てのテーブルはCCSID EBCDICで作成されます。これはIBMメインフレーム環境での使用を想定しています。

### テスト用パディングデータ

endowmentテーブルのpaddingDataカラムは、ワークロードシミュレーション用のテストデータとして使用されます。本番環境では通常空のままです。

### 名前付きカウンターサーバー

アプリケーションは、顧客番号の生成にDb2のIDENTITY列の代わりに、オプションでCICSの名前付きカウンターサーバーを使用することもできます。これはParallel Sysplex環境で複数のCICSリージョンから一意の顧客番号を取得するために使用できます。
