---
generated_at: 2026-01-06 00:00:00
metrics:
  claims_total: 29
  claims_with_evidence: 29
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成されたバッチ一覧.csvの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：29 / 29、根拠なし：0
- 優先レビュー（高）
  - なし（全てのバッチジョブがJCLファイルとして実在し、根拠が確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cntl/db2cre.jcl` - DB2データベース作成JCL
- E-02: `base/cntl/db2bind.jcl` - DB2バインドJCL
- E-03: `base/cntl/db2del.jcl` - DB2削除JCL
- E-04: `base/cntl/cobol.jcl` - COBOLコンパイルJCL
- E-05: `base/cntl/asmmap.jcl` - BMSマップアセンブルJCL
- E-06: `base/cntl/cdef121.jcl` - CICS CSD定義JCL
- E-07: `base/cntl/adef121.jcl` - VSAM定義JCL
- E-08: `base/cntl/samptsq.jcl` - 共有TSキューサーバーJCL
- E-09: `base/cntl/sampncs.jcl` - Named CounterサーバーJCL
- E-10: `base/cntl/sampwui.jcl` - CICS WUIサーバーJCL
- E-11: `base/cntl/sampcma.jcl` - CICS CMASサーバーJCL
- E-12: `base/cntl/defwrep.jcl` - WUIリポジトリ定義JCL
- E-13: `base/cntl/defdrep.jcl` - CMASリポジトリ定義JCL
- E-14: `base/cntl/itpll.jcl` - ITPログリストJCL
- E-15: `base/cntl/itpstl.jcl` - ITPスクリプトコンパイルJCL
- E-16: `base/cntl/itpentr.jcl` - ワークロードシミュレーションJCL
- E-17: `base/cntl/wsaic01.jcl` - 顧客照会Webサービス生成JCL
- E-18: `base/cntl/wsaac01.jcl` - 顧客追加Webサービス生成JCL
- E-19: `base/cntl/wsauc01.jcl` - 顧客更新Webサービス生成JCL
- E-20: `base/cntl/wsavp01.jcl` - ポリシー照会Webサービス生成JCL
- E-21: `base/cntl/wsaap01.jcl` - ポリシー追加Webサービス生成JCL
- E-22: `base/cntl/wsaup01.jcl` - ポリシー更新Webサービス生成JCL
- E-23: `base/cntl/wsaip01.jcl` - ポリシー詳細照会Webサービス生成JCL
- E-24: `base/cntl/wsavc01.jcl` - 商業保険照会Webサービス生成JCL
- E-25: `base/cntl/cdef122.jcl` - 追加CSD定義JCL
- E-26: `base/cntl/cdef123.jcl` - 追加CSD定義JCL
- E-27: `base/cntl/cdef124.jcl` - 追加CSD定義JCL
- E-28: `base/cntl/cdef125.jcl` - 追加CSD定義JCL
- E-29: `base/cntl/cpsmde2.jcl` - CICSPlex SM CSD定義JCL

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GENADB2 (db2cre.jcl)はDB2データベース作成バッチ | E-01 | ○ |
| C-02 | GENABIND (db2bind.jcl)はDB2バインドバッチ | E-02 | ○ |
| C-03 | GENADB2 (db2del.jcl)はDB2削除バッチ | E-03 | ○ |
| C-04 | GENACOMP (cobol.jcl)はCOBOLコンパイルバッチ | E-04 | ○ |
| C-05 | GENAMAP (asmmap.jcl)はBMSマップ生成バッチ | E-05 | ○ |
| C-06 | GENACSD (cdef121.jcl)はCICS CSD定義バッチ | E-06 | ○ |
| C-07 | GENAVSAM (adef121.jcl)はVSAM定義バッチ | E-07 | ○ |
| C-08 | CICSSTSQ (samptsq.jcl)は共有TSキューサーバー起動バッチ | E-08 | ○ |
| C-09 | CICSCNCS (sampncs.jcl)はNamed Counterサーバー起動バッチ | E-09 | ○ |
| C-10 | WUIサーバー (sampwui.jcl)はCICS WUI起動バッチ | E-10 | ○ |
| C-11 | CMASサーバー (sampcma.jcl)はCICS CMAS起動バッチ | E-11 | ○ |
| C-12 | EYUWREP (defwrep.jcl)はWUIリポジトリ定義バッチ | E-12 | ○ |
| C-13 | EYUDREP (defdrep.jcl)はCMASリポジトリ定義バッチ | E-13 | ○ |
| C-14 | GENALL (itpll.jcl)はITPログリスト出力バッチ | E-14 | ○ |
| C-15 | GENASTL (itpstl.jcl)はITPスクリプトコンパイルバッチ | E-15 | ○ |
| C-16 | GENAWSIM (itpentr.jcl)はワークロードシミュレーション実行バッチ | E-16 | ○ |
| C-17 | GENASOAP (wsaic01.jcl)は顧客照会Webサービス生成バッチ | E-17 | ○ |
| C-18 | GENASOAP (wsaac01.jcl)は顧客追加Webサービス生成バッチ | E-18 | ○ |
| C-19 | GENASOAP (wsauc01.jcl)は顧客更新Webサービス生成バッチ | E-19 | ○ |
| C-20 | GENASOAP (wsavp01.jcl)はポリシー照会Webサービス生成バッチ | E-20 | ○ |
| C-21 | GENASOAP (wsaap01.jcl)はポリシー追加Webサービス生成バッチ | E-21 | ○ |
| C-22 | GENASOAP (wsaup01.jcl)はポリシー更新Webサービス生成バッチ | E-22 | ○ |
| C-23 | GENASOAP (wsaip01.jcl)はポリシー詳細照会Webサービス生成バッチ | E-23 | ○ |
| C-24 | GENASOAP (wsavc01.jcl)は商業保険照会Webサービス生成バッチ | E-24 | ○ |
| C-25 | GENACSD (cdef122.jcl)は追加CSD定義バッチ | E-25 | ○ |
| C-26 | GENACSD (cdef123.jcl)は追加CSD定義バッチ | E-26 | ○ |
| C-27 | GENACSD (cdef124.jcl)は追加CSD定義バッチ | E-27 | ○ |
| C-28 | GENACSD (cdef125.jcl)は追加CSD定義バッチ | E-28 | ○ |
| C-29 | GENACSD (cpsmde2.jcl)はCICSPlex SM CSD定義バッチ | E-29 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのバッチジョブはJCLファイルとして`base/cntl/`ディレクトリに存在し、ジョブ名、実行プログラム、処理内容が確認できる。
- スケジュール実行情報（定期実行タイミング等）はJCL内に定義されていないため、別途運用ドキュメントで管理されている可能性がある。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのバッチジョブはソースコードから直接確認可能
- 本プロジェクトはIBM CICS GenAppサンプルアプリケーションであり、バッチジョブは環境構築・開発支援用途が中心

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ一覧の29件が全てJCLファイルとして存在することを確認
- [ ] 各バッチの説明がJCL内のコメントと整合していることを確認
- [ ] カテゴリ分類が適切であることを確認
- [ ] 本番運用で使用するバッチと開発・構築用バッチの区別が必要な場合は追記を検討
