# バッチ設計書: GENADB2 (db2cre.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENADB2 |
| JCLファイル | db2cre.jcl |
| カテゴリ | DB2データベース管理 |
| 説明 | DB2データベース、ストレージグループ、テーブルスペース、テーブル、インデックスの作成と初期データ投入 |

## 2. 処理概要

このバッチは、CICS General Insuranceアプリケーション(GENAPP)で使用するDB2データベース環境を構築します。ストレージグループ、データベース、テーブルスペース、テーブル、インデックスの作成から、初期データの投入、アクセス権限の付与まで一連のデータベースセットアップを実行します。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| CREATE | IKJEFT01 | ストレージグループ、データベース、テーブルスペースの作成 |
| CRTABS (customer) | IKJEFT01 | customerテーブルとcustomer_secureテーブル、インデックスの作成 |
| CRTABS (policy) | IKJEFT01 | policyテーブルとインデックスの作成 |
| CRTABS (endowment) | IKJEFT01 | endowmentテーブルとインデックスの作成 |
| CRTABS (house) | IKJEFT01 | houseテーブルとインデックスの作成 |
| CRTABS (motor) | IKJEFT01 | motorテーブルとインデックスの作成 |
| CRTABS (commercial) | IKJEFT01 | commercialテーブルとインデックスの作成 |
| CRTABS (claim) | IKJEFT01 | claimテーブルとインデックスの作成 |
| CRGRACC | IKJEFT01 | データベースとテーブルへのアクセス権限付与 |
| INSERT | IKJEFT01 | 初期データの投入 |

### ステップ詳細

#### CREATE ステップ

TSO/IKJEFTを使用してDB2コマンドを実行し、以下のオブジェクトを作成します。

**ストレージグループ**
- GENASG02: ボリューム '*' を使用

**データベース**
- `<DB2DBID>`: ストレージグループGENASG02を使用、バッファプールBP1、EBCDIC

**テーブルスペース**
| テーブルスペース名 | PRIQTY | SECQTY | バッファプール |
|--------------------|--------|--------|----------------|
| GENATS01 | 10000 | 5000 | BP1 |
| GENATS02 | 10000 | 5000 | BP1 |
| GENATS03 | 30000 | 12000 | BP32K |
| GENATS04 | 10000 | 5000 | BP1 |
| GENATS05 | 10000 | 5000 | BP1 |
| GENATS06 | 10000 | 5000 | BP1 |
| GENATS07 | 10000 | 5000 | BP1 |

#### CRTABS ステップ群 (テーブル・インデックス作成)

各ステップは条件コード `COND=(4,LT)` で前ステップが正常終了した場合のみ実行されます。

## 4. データベーススキーマ

### テーブル構造

#### customer テーブル (テーブルスペース: GENATS01)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| customerNumber | INTEGER | NOT NULL | 顧客番号 (主キー、自動生成) |
| firstName | CHAR(10) | - | 名 |
| lastName | CHAR(20) | - | 姓 |
| dateOfBirth | DATE | - | 生年月日 |
| houseName | CHAR(20) | - | 家名 |
| houseNumber | CHAR(4) | - | 番地 |
| postcode | CHAR(8) | - | 郵便番号 |
| phonehome | CHAR(20) | - | 自宅電話 |
| phonemobile | CHAR(20) | - | 携帯電話 |
| emailaddress | CHAR(100) | - | メールアドレス |

#### customer_secure テーブル (テーブルスペース: GENATS01)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| customerNumber | INTEGER | NOT NULL | 顧客番号 (主キー・外部キー) |
| customerPass | CHAR(32) | - | パスワード(ハッシュ) |
| state_indicator | CHAR(1) | - | 状態インジケータ |
| pass_changes | INTEGER | - | パスワード変更回数 |

#### policy テーブル (テーブルスペース: GENATS02)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| policyNumber | INTEGER | NOT NULL | 保険証券番号 (主キー、自動生成) |
| customerNumber | INTEGER | NOT NULL | 顧客番号 (外部キー) |
| issueDate | DATE | - | 発行日 |
| expiryDate | DATE | - | 有効期限 |
| policyType | CHAR(1) | - | 保険種別 (C/E/H/M) |
| lastChanged | TIMESTAMP | NOT NULL | 最終更新日時 |
| brokerId | INTEGER | - | ブローカーID |
| brokersReference | CHAR(10) | - | ブローカー参照番号 |
| payment | INTEGER | - | 支払額 |
| commission | SMALLINT | - | 手数料 |

#### endowment テーブル (テーブルスペース: GENATS03)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| policyNumber | INTEGER | NOT NULL | 保険証券番号 (主キー・外部キー) |
| equities | CHAR(1) | - | 株式型フラグ |
| withProfits | CHAR(1) | - | 利益付きフラグ |
| managedFund | CHAR(1) | - | マネージドファンドフラグ |
| fundName | CHAR(10) | - | ファンド名 |
| term | SMALLINT | - | 期間 |
| sumAssured | INTEGER | - | 保証額 |
| lifeAssured | CHAR(31) | - | 被保険者名 |
| paddingData | VARCHAR(32606) | - | パディングデータ |

#### house テーブル (テーブルスペース: GENATS04)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| policyNumber | INTEGER | NOT NULL | 保険証券番号 (主キー・外部キー) |
| propertyType | CHAR(15) | - | 物件タイプ |
| bedrooms | SMALLINT | - | 寝室数 |
| value | INTEGER | - | 価値 |
| houseName | CHAR(20) | - | 家名 |
| houseNumber | CHAR(4) | - | 番地 |
| postcode | CHAR(8) | - | 郵便番号 |

#### motor テーブル (テーブルスペース: GENATS05)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| policyNumber | INTEGER | NOT NULL | 保険証券番号 (主キー・外部キー) |
| make | CHAR(15) | - | メーカー |
| model | CHAR(15) | - | モデル |
| value | INTEGER | - | 価値 |
| regNumber | CHAR(7) | - | 登録番号 |
| colour | CHAR(8) | - | 色 |
| cc | SMALLINT | - | 排気量 |
| yearOfManufacture | DATE | - | 製造年 |
| premium | INTEGER | - | 保険料 |
| accidents | INTEGER | - | 事故回数 |

#### commercial テーブル (テーブルスペース: GENATS06)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| PolicyNumber | INTEGER | NOT NULL | 保険証券番号 (主キー・外部キー) |
| RequestDate | TIMESTAMP | - | 申請日時 |
| StartDate | DATE | - | 開始日 |
| RenewalDate | DATE | - | 更新日 |
| Address | CHAR(255) | - | 住所 |
| Zipcode | CHAR(8) | - | 郵便番号 |
| LatitudeN | CHAR(11) | - | 緯度 |
| LongitudeW | CHAR(11) | - | 経度 |
| Customer | CHAR(255) | - | 顧客名 |
| PropertyType | CHAR(255) | - | 物件タイプ |
| FirePeril | SMALLINT | - | 火災リスクレベル |
| FirePremium | INTEGER | - | 火災保険料 |
| CrimePeril | SMALLINT | - | 犯罪リスクレベル |
| CrimePremium | INTEGER | - | 犯罪保険料 |
| FloodPeril | SMALLINT | - | 洪水リスクレベル |
| FloodPremium | INTEGER | - | 洪水保険料 |
| WeatherPeril | SMALLINT | - | 気象リスクレベル |
| WeatherPremium | INTEGER | - | 気象保険料 |
| Status | SMALLINT | - | ステータス |
| RejectionReason | CHAR(255) | - | 却下理由 |

#### claim テーブル (テーブルスペース: GENATS07)

| カラム名 | データ型 | NULL | 説明 |
|----------|----------|------|------|
| ClaimNumber | INTEGER | NOT NULL | 請求番号 (主キー、自動生成) |
| PolicyNumber | INTEGER | NOT NULL | 保険証券番号 (外部キー) |
| ClaimDate | DATE | - | 請求日 |
| Paid | INTEGER | - | 支払額 |
| Value | INTEGER | - | 請求額 |
| Cause | CHAR(255) | - | 原因 |
| Observations | CHAR(255) | - | 備考 |

### インデックス

| インデックス名 | 対象テーブル | カラム | 種類 |
|----------------|--------------|--------|------|
| iCustomer | customer | customerNumber | UNIQUE CLUSTER |
| iCustomer_secure | customer_secure | customerNumber | UNIQUE CLUSTER |
| iPolicy | policy | policyNumber | UNIQUE CLUSTER |
| iPolicy2 | policy | customerNumber | NON-UNIQUE |
| iEndowment | endowment | policyNumber | UNIQUE CLUSTER |
| iHouse | house | policyNumber | UNIQUE CLUSTER |
| iMotor | motor | policyNumber | UNIQUE CLUSTER |
| iCommercial | commercial | PolicyNumber | UNIQUE CLUSTER |
| iClaim | claim | ClaimNumber | UNIQUE CLUSTER |

## 5. DD文定義

| DD名 | 説明 | データセット |
|------|------|-------------|
| JOBLIB | DB2ロードライブラリ | `<DB2HLQ>.SDSNLOAD` |
| SYSTSPRT | TSOプリント出力 | SYSOUT=* |
| SYSTSIN | TSO入力 | インライン |
| SYSPRINT | プリント出力 | SYSOUT=* |
| SYSUDUMP | ダンプ出力 | SYSOUT=* |
| SYSIN | SQL文入力 | インライン |

## 6. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<DB2HLQ>` | DB2高レベル修飾子 |
| `<DB2SSID>` | DB2サブシステムID |
| `<DB2PLAN>` | DB2プラン名 |
| `<DB2RUN>` | DB2実行ライブラリ修飾子 |
| `<DB2DBID>` | データベースID |
| `<SQLID>` | SQL作成者ID |

## 7. 初期データ

### 顧客データ (10件)

初期登録される顧客データ (customerNumber 1〜10):
- Andrew Pandy, Scott Tracey, John Noakes, Louis Pug, Graham Cuthbert
- Brian Cant, Troy Tempest, Johnny Morris, Micky Murphy, Susan Stranks

### ポリシーデータ (10件)

policyNumber 1〜10の保険証券が登録されます。
- 保険種別: C (Commercial)、E (Endowment)、H (House)、M (Motor)

### 保険詳細データ

- endowment: 2件 (policyNumber 4, 5)
- house: 3件 (policyNumber 6, 7, 8)
- motor: 3件 (policyNumber 1, 2, 3)
- commercial: 2件 (policyNumber 9, 10)

## 8. 権限設定

| オブジェクト | 権限 | 付与先 |
|--------------|------|--------|
| DATABASE | DBADM | PUBLIC |
| TABLESPACE (全7個) | USE | PUBLIC |
| TABLE (全7テーブル) | ALL PRIVILEGES | PUBLIC |

## 9. 前提条件

- DB2サブシステムが稼働していること
- DSNTIADプログラムが実行可能であること
- バッファプール BP1 および BP32K が定義済みであること

## 10. 実行後の確認事項

1. 全てのテーブルスペースが作成されていること
2. 全てのテーブルとインデックスが作成されていること
3. 初期データが正しく投入されていること
4. 権限が正しく設定されていること

## 11. 障害時の対応

- ステップが失敗した場合は、db2del.jcl を実行してオブジェクトを削除し、再実行する
- 外部キー制約違反の場合は、親テーブルのデータ存在を確認する
