# バッチ設計書: WUIサーバー (sampwui.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | WUIサーバー |
| JCLファイル | sampwui.jcl |
| カテゴリ | CICS WUI起動 |
| 説明 | CICS Web User Interfaceサーバーの起動 |

## 2. 処理概要

このバッチは、CICSPlex SM（System Manager）のWeb User Interface（WUI）サーバーを起動します。WUIサーバーは、Webブラウザを使用してCICSリージョンの管理・監視を行うためのインターフェースを提供します。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| GENAPP1 | DFHSIP | CICSリージョン（WUIサーバー）の起動 |

### ステップ詳細

#### GENAPP1 ステップ

DFHSIPを使用してCICS WUIサーバーを初期起動します。

| 項目 | 内容 |
|------|------|
| プログラム | DFHSIP (CICS System Initialization Program) |
| TIME | 1440 (24時間) |
| REGION | 0M (無制限) |
| MEMLIMIT | 10G |
| START | INITIAL |

## 4. 起動パラメータ

### EYUWUI（WUI設定）

| パラメータ | 設定値 | 説明 |
|------------|--------|------|
| TCPIPHTTPHOST | YES | TCP/IP HTTPホスト有効化 |
| TCPIPHOSTNAME | 127.0.0.1 | ホスト名（ローカルホスト） |
| TCPIPPORT | 6345 | WUIポート番号 |
| CMCIPORT | 6346 | CMCIポート番号 |
| INACTIVETIMEOUT | 3600 | 非アクティブタイムアウト（秒） |
| DEFAULTCONTEXT | GNAPPLEX | デフォルトコンテキスト |
| DEFAULTSCOPE | GNAPPLEX | デフォルトスコープ |
| DEFAULTCMASCTXT | `<CMASAPPL>` | デフォルトCMASコンテキスト |
| AUTOIMPORTDSN | `<CPSMHLQ>.SEYUVIEW` | 自動インポートデータセット |
| AUTOIMPORTMEM | EYUEA* | 自動インポートメンバー |

### EYUPARM（CPSM設定）

| パラメータ | 設定値 | 説明 |
|------------|--------|------|
| CICSPLEX | WUIP`<CMASYSID>` | CICSplex名 |
| CMASSYSID | `<CMASYSID>` | CMASシステムID |
| MASPLTWAIT | YES | MASプレイスウェイト |
| MASINITTIME | 20 | MAS初期化時間 |
| MAXHISTRECS | 50 | 最大履歴レコード数 |
| HISTRECSMSG | 10 | 履歴レコードメッセージ数 |
| HISTSECS | 10 | 履歴秒数 |

### SYSIN（CICS SIT設定）

主要なシステム初期化パラメータ:

| パラメータ | 設定値 | 説明 |
|------------|--------|------|
| GRPLIST | DFHLIST | グループリスト |
| APPLID | `<WUIAPPL>` | アプリケーションID |
| SYSIDNT | IWUI | システム識別子 |
| CPSMCONN | WUI | CPSM接続タイプ |
| TCPIP | YES | TCP/IP有効 |
| SEC | NO | セキュリティ無効 |
| MXT | 600 | 最大タスク数 |
| EDSALIM | 900M | EDSA制限 |
| MAXOPENTCBS | 400 | 最大オープンTCB数 |
| DB2CONN | NO | DB2接続無効 |
| NCPLDFT | GENA | デフォルトNamed Counterプール |
| RLS | YES | RLS有効 |

## 5. DD文定義

### ライブラリ

| DD名 | 説明 | データセット |
|------|------|-------------|
| STEPLIB | 認証ライブラリ | `<CICSHLQ>.SDFHAUTH`、`<CICSLIC>.SDFHLIC`、`<CPSMHLQ>.SEYUAUTH`、`<CEEHLQ>.SCEECICS` |
| DFHRPL | RPLライブラリ | `<CICSHLQ>.SDFHLOAD`、`<CPSMHLQ>.SEYULOAD`、`<CEEHLQ>.SCEECICS`、`<CEEHLQ>.SCEERUN`、`<LOADX>` |

### CICSPlex SM関連

| DD名 | 説明 | データセット |
|------|------|-------------|
| EYUWREP | WUIリポジトリ | `<USRHLQ>.<WUIAPPL>.EYUWREP` |
| EYULOG | ログ出力 | SYSOUT=* |
| EYUWUI | WUI設定 | インライン |
| EYUPARM | CPSM設定 | インライン |

### CICSシステム

| DD名 | 説明 | データセット |
|------|------|-------------|
| DFHCSD | CSD | `<CSDNAME>` |
| DFHDMPA | ダンプA | `<USRHLQ>.<WUIAPPL>.DFHDMPA` |
| DFHDMPB | ダンプB | `<USRHLQ>.<WUIAPPL>.DFHDMPB` |
| DFHAUXT | 補助トレースA | `<USRHLQ>.<WUIAPPL>.DFHAUXT` |
| DFHBUXT | 補助トレースB | `<USRHLQ>.<WUIAPPL>.DFHBUXT` |
| DFHGCD | グローバルカタログ | `<USRHLQ>.<WUIAPPL>.DFHGCD` |
| DFHINTRA | イントラパーティションTDQ | `<USRHLQ>.<WUIAPPL>.DFHINTRA` |
| DFHLCD | ローカルカタログ | `<USRHLQ>.<WUIAPPL>.DFHLCD` |
| DFHTEMP | 一時ストレージ | `<USRHLQ>.<WUIAPPL>.DFHTEMP` |

### 出力

| DD名 | 説明 | データセット |
|------|------|-------------|
| DFHCXRF | 相互参照 | SYSOUT=* |
| MSGFILE | メッセージファイル | SYSOUT=* |
| LOGUSR | ユーザーログ | SYSOUT=* |
| MSGUSR | ユーザーメッセージ | SYSOUT=* |
| PLIMSG | PLIメッセージ | SYSOUT=* |
| COUT | C出力 | SYSOUT=* |
| CEEMSG | LEメッセージ | SYSOUT=* |
| CEEOUT | LE出力 | SYSOUT=* |
| DFHSNAP | スナップダンプ | SYSOUT=* |
| SYSUDUMP | ダンプ | SYSOUT=* |
| SYSABEND | アベンドダンプ | SYSOUT=* |
| PRINTER | プリンター | SYSOUT=* |

## 6. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<WUIAPPL>` | WUIアプリケーションID |
| `<CICSHLQ>` | CICS高レベル修飾子 |
| `<CICSLIC>` | CICSライセンスライブラリ修飾子 |
| `<CPSMHLQ>` | CICSPlex SM高レベル修飾子 |
| `<CEEHLQ>` | Language Environment高レベル修飾子 |
| `<CSDNAME>` | CSDデータセット名 |
| `<USRHLQ>` | ユーザー高レベル修飾子 |
| `<LOADX>` | ロードライブラリ |
| `<CMASAPPL>` | CMASアプリケーションID |
| `<CMASYSID>` | CMASシステムID |
| `<SQLID>` | SQLユーザーID |

## 7. WUIサーバーのアーキテクチャ

```
┌─────────────────────────────────────────────────────────┐
│                    Web Browser                          │
│                  http://127.0.0.1:6345                  │
└─────────────────────────┬───────────────────────────────┘
                          │
                          ▼
┌─────────────────────────────────────────────────────────┐
│                 CICS WUI Server                         │
│                 (sampwui.jcl)                           │
│                                                         │
│  ┌─────────────┐  ┌─────────────┐  ┌─────────────┐     │
│  │   EYUWUI    │  │  EYUPARM    │  │    SYSIN    │     │
│  │  WUI設定    │  │  CPSM設定   │  │   SIT設定   │     │
│  └─────────────┘  └─────────────┘  └─────────────┘     │
│                                                         │
│  Port: 6345 (HTTP)  /  Port: 6346 (CMCI)               │
└─────────────────────────┬───────────────────────────────┘
                          │
                          ▼
┌─────────────────────────────────────────────────────────┐
│                  CICSPlex SM                            │
│                                                         │
│  ┌─────────────┐  ┌─────────────┐  ┌─────────────┐     │
│  │   CMAS      │  │   MAS 1     │  │   MAS 2     │     │
│  │             │  │             │  │             │     │
│  └─────────────┘  └─────────────┘  └─────────────┘     │
└─────────────────────────────────────────────────────────┘
```

## 8. 前提条件

1. CICS TSが稼働可能な環境であること
2. CICSPlex SMがインストールされていること
3. 必要なデータセット（ダンプ、トレース、カタログ等）が事前に割り当てられていること
4. WUIリポジトリ（EYUWREP）が定義済みであること
5. samptsq.jcl、sampncs.jcl が起動済みであること（NCPLDFT=GENA使用のため）

## 9. 実行後の確認事項

1. CICSリージョンが正常に起動していること
2. WUIがhttp://127.0.0.1:6345でアクセス可能であること
3. CMCIがポート6346でアクセス可能であること
4. CICSPlex SMと正常に接続されていること

## 10. 障害時の対応

### 起動失敗

- MSGFILEのエラーメッセージを確認
- データセットの割り当てエラーを確認
- STEPLIBの連結順序を確認

### WUIアクセス不可

- TCP/IP設定を確認
- ポート6345が使用可能か確認
- ファイアウォール設定を確認

### CPSM接続エラー

- CMASが起動しているか確認
- EYUPARM設定を確認
- ネットワーク接続を確認

## 11. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| sampcma.jcl | CMASサーバー起動（WUIの接続先） |
| defwrep.jcl | WUIリポジトリ定義 |
| samptsq.jcl | TSキューサーバー |
| sampncs.jcl | Named Counterサーバー |

## 12. 運用上の注意

### 常駐サーバー

- このジョブはCICSリージョンとして常駐稼働します
- 停止にはCICS シャットダウンコマンドを使用

### セキュリティ

- SEC=NO で起動しているため、テスト環境用の設定です
- 本番環境では SEC=YES を推奨

### リソース使用量

- MEMLIMIT=10G、EDSALIM=900M の大きなメモリ設定
- MXT=600 で最大600タスクまで同時実行可能
