# バッチ設計書 11-CMASサーバー起動

## 概要

本ドキュメントは、CICSPlex SM CMAS（CICSPlex SM Address Space）サーバーを起動するためのバッチジョブ（sampcma.jcl）の設計書です。

### 本バッチの処理概要

CMASサーバー起動バッチは、CICSPlex SM環境における管理サーバー（CMAS）を初期化・起動するためのジョブです。

**業務上の目的・背景**：CICSPlex SM（CICSPlex System Manager）は、複数のCICSリージョンを統合的に管理するための製品です。CMASはCICSPlex SMの中核となるコンポーネントであり、管理対象のCICSリージョン（MAS：Managed Application System）を監視・制御するために必要です。本バッチは、保険業務アプリケーション（GenApp）を運用する複数のCICS環境を一元管理するために不可欠な基盤サービスを提供します。

**バッチの実行タイミング**：システム起動時（日次または必要に応じて随時）。CICSPlex SM環境の初期化時や、CMASの再起動が必要な場合に実行されます。

**主要な処理内容**：
1. EYU9XECSプログラムを使用してCMAS環境を初期化
2. CICS関連ライブラリ（SDFHAUTH、SDFHLIC、SEYUAUTH）のロード
3. データリポジトリ（EYUDREP）への接続確立
4. セキュリティ設定（SEC=YES）の有効化
5. CICSシステム定義（CSD）の読み込み
6. TCP/IP接続の有効化とCICSPlex SM接続モード（CPSMCONN=CMAS）の設定

**前後の処理との関連**：
- 前提：データリポジトリ（EYUDREP）がdefdrep.jclで事前に定義・初期化されていること
- 後続：WUIサーバー（sampwui.jcl）やMASリージョンの起動

**影響範囲**：CICSPlex SM環境全体、管理対象の全CICSリージョン、GenAppアプリケーションの運用管理機能

## バッチ種別

システム起動 / 基盤サービス初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次/随時 |
| 実行時刻 | システム起動時 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | 手動/自動起動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データリポジトリ初期化完了 | EYUDREPがdefdrep.jclで事前に定義・初期化されていること |
| CICSライブラリ利用可能 | SDFHAUTH、SDFHLIC、SEYUAUTHライブラリがアクセス可能であること |
| CSD定義完了 | CICSシステム定義ファイルが利用可能であること |
| ユーザーデータセット準備 | DFHDMPA、DFHGCD、DFHINTRA、DFHLCD、DFHTEMPが準備されていること |

### 実行可否判定

CMASリージョンが既に起動していないことを確認。既に起動している場合は重複起動エラーとなるため、事前にステータス確認が必要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CMASAPPL | 文字列 | Yes | なし | CMASのAPPLID |
| CMASYSID | 文字列 | Yes | なし | CMASのシステムID |
| CICSHLQ | 文字列 | Yes | なし | CICS高レベル修飾子 |
| CPSMHLQ | 文字列 | Yes | なし | CICSPlex SM高レベル修飾子 |
| CEEHLQ | 文字列 | Yes | なし | Language Environment高レベル修飾子 |
| USRHLQ | 文字列 | Yes | なし | ユーザー高レベル修飾子 |
| CSDNAME | 文字列 | Yes | なし | CSDデータセット名 |
| SQLID | 文字列 | Yes | なし | デフォルトユーザーID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| EYUDREP | VSAM | CMASデータリポジトリ |
| DFHCSD | VSAM | CICSシステム定義ファイル |
| EYUPARM | インライン | CMASパラメータ設定 |
| SYSIN | インライン | CICSシステムパラメータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| EYULOG | SYSOUT | CMASログ出力 |
| DFHCXRF | SYSOUT | クロスリファレンス出力 |
| MSGFILE | SYSOUT | メッセージファイル |
| LOGUSR | SYSOUT | ユーザーログ |
| MSGUSR | SYSOUT | ユーザーメッセージ |

### 出力ファイル仕様

ログ出力はすべてSYSOUTに出力され、ファイルとしての永続化は行われません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（SYSOUT） |
| 出力先 | JESスプール |
| 文字コード | EBCDIC |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. JOBステートメント処理
   └─ ジョブ名、クラス、メッセージクラスの設定
2. EYU9XECSプログラム実行
   └─ CMAS環境の初期化と起動
3. STEPLIBライブラリロード
   └─ SDFHAUTH、SDFHLIC、SEYUAUTH、SCEECICSライブラリ
4. DFHRPLライブラリロード
   └─ SDFHLOAD、SEYULOAD、SCEERUN等の実行ライブラリ
5. データリポジトリ接続
   └─ EYUDREPへの接続確立
6. セキュリティ初期化
   └─ SEC(YES)、SECLOGMSG(YES)の設定
7. CSDファイルオープン
   └─ CICS定義の読み込み
8. システムパラメータ適用
   └─ SYSIN DDからのパラメータ読み込みと適用
9. CMAS起動完了
   └─ 管理機能のアクティブ化
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[EYU9XECSプログラム起動]
    B --> C[STEPLIBライブラリロード]
    C --> D[DFHRPLライブラリロード]
    D --> E[EYUDREPリポジトリ接続]
    E --> F{リポジトリ接続成功?}
    F -->|Yes| G[セキュリティ初期化]
    F -->|No| H[エラー終了]
    G --> I[CSD読み込み]
    I --> J[システムパラメータ適用]
    J --> K[TCP/IP有効化]
    K --> L[CMAS起動完了]
    L --> M[バッチ終了]
    H --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはDB2データベースへの直接操作は行いません。VSAMファイル（EYUDREP、CSD関連）へのアクセスのみ実行します。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | DB2操作なし |

### テーブル別操作詳細

DB2テーブルへの操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| LGCA | ABEND | COMMAREA未受信 | 呼び出し元プログラムの確認 |
| SEC ERROR | セキュリティエラー | 認証失敗 | ユーザー権限の確認 |
| OPEN ERROR | ファイルオープンエラー | EYUDREP/CSDオープン失敗 | データセットの存在・権限確認 |
| INIT ERROR | 初期化エラー | パラメータ不正 | SYSINパラメータの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. EYULOGおよびMSGFILEの内容を確認
2. エラーメッセージに基づき原因を特定
3. 必要に応じてデータリポジトリの状態を確認
4. パラメータ設定を見直し、再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | CMAS起動全体 |
| コミットタイミング | 起動完了時 |
| ロールバック条件 | 起動失敗時（自動終了） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/起動 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 10GB（MEMLIMIT=10G） |

## 排他制御

CMASは単一インスタンスとして動作するため、同一APPLIDでの重複起動は不可。起動前に既存インスタンスの停止を確認すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | CMAS起動開始時 | 初期化開始メッセージ |
| 進捗ログ | 各初期化フェーズ完了時 | フェーズ完了メッセージ |
| 終了ログ | CMAS起動完了時 | 起動完了メッセージ |
| エラーログ | エラー発生時 | エラーコード、詳細メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 起動時間 | 300秒 | 運用担当者 |
| 起動失敗 | 1回 | 運用担当者 |
| セキュリティエラー | 1回 | セキュリティ担当者 |

## 備考

- TIME=1440により、ジョブは最大1440分（24時間）実行可能
- REGION=0MおよびMEMLIMIT=10Gにより、大規模なメモリ使用が許可されている
- START=INITIALパラメータにより、初期起動モードで実行
- CPSMCONN=CMASにより、CICSPlex SM CMASモードで接続
