# バッチ設計書 13-CMASデータリポジトリ定義

## 概要

本ドキュメントは、CICSPlex SM CMASデータリポジトリを定義・初期化するバッチジョブ（defdrep.jcl）の設計書です。

### 本バッチの処理概要

CMASデータリポジトリ定義バッチは、CICSPlex SM CMAS（CICSPlex SM Address Space）が使用するデータリポジトリ（EYUDREP）を削除・再定義し、初期化するジョブです。

**業務上の目的・背景**：CMASは、CICSPlex SM環境全体を管理するための中央制御サーバーです。CMASが使用するデータリポジトリ（EYUDREP）には、CICSPlex SM構成情報、WUIサーバー接続情報、トポロジー定義などの重要な管理情報が格納されます。本バッチは、CMASのリポジトリを初期状態から構築し、WUIサーバーとの連携設定を初期化するために使用されます。GenAppアプリケーションを複数のCICSリージョンで運用管理するための基盤構成を提供します。

**バッチの実行タイミング**：環境構築時、またはリポジトリの再初期化が必要な場合に随時実行されます。

**主要な処理内容**：
1. IDCAMSユーティリティを使用して既存のEYUDREPクラスタを削除
2. 新規VSAMクラスタ（KSDS）の定義
3. EYU9XDUTプログラムによるリポジトリ初期化
4. WUIサーバー接続情報の初期設定

**前後の処理との関連**：
- 前提：特になし（独立した初期化処理）
- 後続：CMASサーバー起動（sampcma.jcl）、WUIサーバー起動（sampwui.jcl）

**影響範囲**：CMASサーバー機能全体、WUIサーバーとの連携、CICSPlex SM管理機能

## バッチ種別

データ初期化 / VSAM管理 / リポジトリ初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（環境構築時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CMASサーバー停止 | EYUDREPにアクセスするCMASが停止していること |
| ストレージ利用可能 | STANDARDストレージクラスが利用可能であること |
| CPSMライブラリ利用可能 | SEYUAUTHライブラリがアクセス可能であること |

### 実行可否判定

CMASサーバーが起動中の場合、リポジトリへの排他エラーが発生する可能性があるため、事前にサーバー停止を確認。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| USRHLQ | 文字列 | Yes | なし | ユーザー高レベル修飾子 |
| CMASAPPL | 文字列 | Yes | なし | CMASのAPPLID |
| CMASYSID | 文字列 | Yes | なし | CMASのシステムID |
| CPSMHLQ | 文字列 | Yes | なし | CICSPlex SM高レベル修飾子 |
| WUIAPPL | 文字列 | Yes | なし | WUIサーバーのAPPLID |
| WUISYSID | 文字列 | Yes | なし | WUIサーバーのシステムID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSIN | インライン | IDCAMSコマンド |
| EYUXDPRM | インライン | 初期化パラメータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| EYUDREP | VSAM KSDS | CMASデータリポジトリ |
| SYSPRINT | SYSOUT | 処理結果出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {USRHLQ}.{CMASAPPL}.EYUDREP |
| 出力先 | システムデフォルト |
| レコードサイズ | 200-6550バイト（可変長） |
| キー長 | 64バイト（オフセット0） |

## 処理フロー

### 処理シーケンス

```
1. DELWREPステップ実行
   └─ IDCAMSによる既存クラスタ削除
   └─ SET MAXCC=0で削除エラーを無視
2. DEFDREPステップ実行
   └─ IDCAMSによる新規クラスタ定義
   └─ REUSE/ERASE/SPEED属性設定
3. DREPINITステップ実行
   └─ EYU9XDUTによるリポジトリ初期化
   └─ CMASパラメータ設定
   └─ WUIサーバー情報登録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[DELWREP: 既存クラスタ削除]
    B --> C{削除成功?}
    C -->|Yes| D[DEFDREP: 新規クラスタ定義]
    C -->|No（存在しない）| D
    D --> E{定義成功?}
    E -->|Yes| F[DREPINIT: リポジトリ初期化]
    E -->|No| G[エラー終了]
    F --> H{初期化成功?}
    H -->|Yes| I[バッチ正常終了]
    H -->|No| G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはDB2データベースへの操作は行いません。VSAM操作のみです。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | DB2操作なし |

### テーブル別操作詳細

DB2テーブルへの操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IDC3012I | データセット未検出 | 削除対象が存在しない | SET MAXCC=0で継続（正常） |
| IDC3009I | クラスタ定義エラー | 領域不足、権限エラー | ボリューム/権限確認 |
| EYU9XDUT RC=8 | 初期化エラー | パラメータ不正 | EYUXDPRMの内容確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. SYSPRINTの内容を確認しエラーメッセージを特定
2. EYUXDPRMパラメータの値を確認
3. CMASNAMEとSYSIDパラメータの整合性を確認
4. 必要に応じて手動でDELETE実行後、再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ステップ単位 |
| コミットタイミング | 各ステップ完了時 |
| ロールバック条件 | N/A（VSAM定義は即時確定） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/セットアップ |
| 目標処理時間 | 2分以内 |
| メモリ使用量上限 | デフォルト |

## 排他制御

リポジトリ定義・初期化中は対象VSAMファイルに対する排他ロックが取得されます。CMASサーバーが起動中の場合は競合エラーとなります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | 処理開始メッセージ |
| 終了ログ | 各ステップ完了時 | 処理結果、コンディションコード |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ完了コード | CC > 0 | 運用担当者 |

## 備考

- RECORDS(500 3000)により、500レコードの初期割当と3000レコードの拡張が設定
- CONTROLINTERVALSIZE(8192)により、CI=8KBで定義
- SHR(2)により、リージョン間での読み取り共有が可能
- REUSEオプションにより、既存データの再利用が可能
- ERASEオプションにより、削除時にデータが消去される
- SPEEDオプションにより、事前フォーマットなしで高速定義
- COND=(8,LT)によりDREPINITは前ステップがRC<8の場合のみ実行
- TIMEZONE=B、DAYLIGHT=N、ZONEOFFSET=0はタイムゾーン設定
