# バッチ設計書 14-ITPログリスト出力

## 概要

本ドキュメントは、ワークロードシミュレーション（ITP/TPNS）のログをリスト形式で出力するバッチジョブ（itpll.jcl）の設計書です。

### 本バッチの処理概要

ITPログリスト出力バッチは、ITP（Interactive Test/Production）ワークロードシミュレーションの実行結果ログを読み取り、人間が読みやすい形式でリスト出力するジョブです。

**業務上の目的・背景**：GenAppアプリケーションの品質保証・性能検証において、端末シミュレーションツール（TPNS/ITP）を使用したワークロードシミュレーションが実施されます。シミュレーション実行後、結果の分析・問題特定のためにログファイルの内容を確認する必要があります。本バッチは、バイナリ形式のログファイルを可読性の高いテキスト形式に変換し、デバッグや性能分析を支援します。

**バッチの実行タイミング**：ワークロードシミュレーション（itpentr.jcl）実行後に随時実行されます。テスト結果の確認が必要な際に手動で実行します。

**主要な処理内容**：
1. ITPLLプログラムを使用してログファイルを読み込み
2. コンソールメッセージ（CNSL）の出力
3. SNAフォーマット（FMTSNA）での表示
4. 詳細表示（DSPLY）の有効化
5. データ内容（DATA）の出力
6. 実行結果（RUN）のサマリー出力

**前後の処理との関連**：
- 前提：ワークロードシミュレーション（itpentr.jcl）が実行済みであること
- 後続：なし（分析・レビュー作業）

**影響範囲**：テスト結果の可視化、品質分析業務

## バッチ種別

レポート生成 / ログ解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（テスト後） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ログファイル存在 | WSIMLGXデータセットにログデータが記録されていること |
| ITPライブラリ利用可能 | SITPLOADライブラリがアクセス可能であること |

### 実行可否判定

ログファイル（WSIMLGX）が存在し、読み取り可能であることを確認。ファイルが存在しないか空の場合は意味のある出力が得られません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| WSIMHLQ | 文字列 | Yes | なし | WSIMライブラリ高レベル修飾子 |
| WSIMLGX | 文字列 | Yes | なし | ログファイルデータセット名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSUT1（WSIMLGX） | バイナリ | ITPシミュレーションログファイル |
| SYSIN | インライン | 出力形式指定パラメータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| SYSPRINT | SYSOUT | フォーマット済みログリスト |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SYSPRINT（SYSOUT=A） |
| 出力先 | JESスプール |
| 文字コード | EBCDIC |
| 区切り文字 | N/A（テキスト形式） |

## 処理フロー

### 処理シーケンス

```
1. JOBステートメント処理
   └─ ジョブ名、クラス設定
2. LOGLISTステップ実行
   └─ ITPLLプログラム起動
3. ログファイル読み込み
   └─ SYSUT1からログデータ取得
4. 出力形式指定の適用
   └─ CNSL/FMTSNA/DSPLY/DATA/RUN各オプション
5. リスト出力生成
   └─ SYSPRINTへフォーマット済み出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ITPLLプログラム起動]
    B --> C[ログファイル読み込み]
    C --> D{ログデータ存在?}
    D -->|Yes| E[出力形式オプション適用]
    D -->|No| F[空出力]
    E --> G[CNSLコンソールメッセージ出力]
    G --> H[FMTSNAフォーマット出力]
    H --> I[DSPLYデータ表示]
    I --> J[DATAデータ内容出力]
    J --> K[RUNサマリー出力]
    K --> L[SYSPRINTへ出力]
    F --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースへの操作は行いません。ファイル参照のみです。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | DB操作なし |

### テーブル別操作詳細

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| S013 | ファイルオープンエラー | ログファイル不存在 | ファイルパス確認 |
| S001 | 入出力エラー | ファイル読み取り失敗 | ファイル状態確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. SYSPRINTの内容を確認しエラーメッセージを特定
2. SYSUT1（WSIMLGX）データセットの存在・権限を確認
3. SITPLOADライブラリの利用可能性を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ログファイルサイズ依存 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | デフォルト |

## 排他制御

ログファイルは読み取り専用でアクセスするため、他のプロセスとの排他制御は不要。ただし、シミュレーション実行中のログファイルにアクセスする場合は注意が必要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | プログラム開始時 | 処理開始メッセージ |
| 出力ログ | 処理中 | フォーマット済みログデータ |
| 終了ログ | プログラム終了時 | 処理完了メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ完了コード | CC > 0 | テスト担当者 |

## 備考

- ITPLLはITP（Interactive Test/Production）ログリストユーティリティ
- SYSINパラメータの意味：
  - CNSL：コンソールメッセージを出力
  - FMTSNA：SNAフォーマットでの表示を有効化
  - DSPLY：詳細表示モード
  - DATA：データ内容の出力
  - RUN：実行サマリーの出力
  - END：パラメータ終端
- SYSOUT=Aクラスへの出力でJESスプールに保存
