# バッチ設計書 15-ITPスクリプトコンパイル

## 概要

本ドキュメントは、ワークロードシミュレーション用のITP/TPNSテストスクリプトをコンパイルするバッチジョブ（itpstl.jcl）の設計書です。

### 本バッチの処理概要

ITPスクリプトコンパイルバッチは、GenAppアプリケーションのワークロードシミュレーションに使用するTPNS（Teleprocessing Network Simulator）スクリプトをコンパイルするジョブです。

**業務上の目的・背景**：GenAppアプリケーションの品質保証・性能検証において、実際の端末操作をシミュレートする自動化テストが必要です。TPNSスクリプトは、端末からの入力、画面遷移、トランザクション実行をスクリプト言語で記述したものです。本バッチは、人間が読めるスクリプトソースを、シミュレーション実行エンジン（ITPENTER）が解釈できる形式にコンパイルします。これにより、顧客管理・ポリシー管理機能の自動テストが可能になります。

**バッチの実行タイミング**：テストスクリプト新規作成時、またはスクリプト修正時に随時実行されます。

**主要な処理内容**：
1. ITPSTLプログラムを使用してスクリプトソースを読み込み
2. 各スクリプトメンバーのコンパイル処理
3. コンパイル結果の出力
4. 顧客操作スクリプト（SSC1A1, SSC1I1, WSC1A1, WSC1I1）のコンパイル
5. ポリシー操作スクリプト（SSP1A1-SSP4D1, SSP1I1-SSP4I1, SSP1U1-SSP3U1）のコンパイル

**前後の処理との関連**：
- 前提：スクリプトソースファイル（WSIMWSX）が準備されていること
- 後続：ワークロードシミュレーション実行（itpentr.jcl）

**影響範囲**：テスト自動化環境、品質検証プロセス

## バッチ種別

コンパイル処理 / テスト準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（スクリプト更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| スクリプトソース存在 | WSIMWSXデータセットにスクリプトメンバーが存在すること |
| ITPライブラリ利用可能 | SITPLOADライブラリがアクセス可能であること |
| メッセージライブラリ存在 | WSIMMSXデータセットが利用可能であること |

### 実行可否判定

スクリプトソースファイル（WSIMWSX）が存在し、コンパイル対象のメンバーが含まれていることを確認。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| WSIMHLQ | 文字列 | Yes | なし | WSIMライブラリ高レベル修飾子 |
| WSIMWSX | 文字列 | Yes | なし | スクリプトソースPDSデータセット名 |
| WSIMMSX | 文字列 | Yes | なし | メッセージPDSデータセット名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSIN（WSIMWSX） | PDS | スクリプトソースメンバー |
| SYSLIB（WSIMWSX） | PDS | インクルードライブラリ |
| MSGDD（WSIMMSX） | PDS | メッセージ定義ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| SYSPRINT | SYSOUT | コンパイル結果リスト |
| SEQOUT | SYSOUT | シーケンシャル出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SYSPRINT（SYSOUT=*） |
| 出力先 | JESスプール |
| 文字コード | EBCDIC |
| 区切り文字 | N/A（テキスト形式） |

## 処理フロー

### 処理シーケンス

```
1. JOBステートメント処理
   └─ ジョブ名、リージョン設定（7M）
2. STLプロシージャ定義
   └─ ITPSTLプログラム実行手順の定義
3. 各スクリプトメンバーのコンパイル
   └─ #ONCICS: CICS接続スクリプト
   └─ #SSVARS: 共通変数定義
   └─ SSC1A1, SSC1I1: 顧客追加・照会スクリプト
   └─ SSP1A1-SSP4D1: ポリシー追加・削除スクリプト
   └─ SSP1I1-SSP4I1: ポリシー照会スクリプト
   └─ SSP1U1-SSP3U1: ポリシー更新スクリプト
   └─ STOP: 終了スクリプト
   └─ WSC1A1, WSC1I1: Webサービス顧客スクリプト
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[STLプロシージャ初期化]
    B --> C[#ONCICS コンパイル]
    C --> D[#SSVARS コンパイル]
    D --> E[顧客スクリプト コンパイル]
    E --> F[ポリシースクリプト コンパイル]
    F --> G[終了スクリプト コンパイル]
    G --> H[Webサービススクリプト コンパイル]
    H --> I{全コンパイル成功?}
    I -->|Yes| J[バッチ正常終了]
    I -->|No| K[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースへの操作は行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | DB操作なし |

### テーブル別操作詳細

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| S013 | ファイルオープンエラー | メンバー不存在 | メンバー名確認 |
| SYNTAX | 構文エラー | スクリプト構文不正 | スクリプト修正 |
| UNRESOLVED | 未解決参照 | インクルード失敗 | SYSLIB確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. SYSPRINTの内容を確認しエラー箇所を特定
2. 構文エラーの場合、対象スクリプトを修正
3. ファイル参照エラーの場合、データセット・メンバーの存在を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（コンパイル処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約20メンバー |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 7MB（REGION=7M） |

## 排他制御

スクリプトソースファイル（WSIMWSX）への読み取りアクセスのみのため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | コンパイル開始メッセージ |
| 詳細ログ | コンパイル中 | 構文解析結果 |
| 終了ログ | 各ステップ完了時 | コンパイル結果、RC |
| エラーログ | エラー発生時 | エラーメッセージ、行番号 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ完了コード | CC > 0 | テスト担当者 |
| コンパイルエラー | 1件以上 | 開発担当者 |

## 備考

- ITPSTLはITP（Interactive Test/Production）スクリプトコンパイラ
- コンパイル対象スクリプト一覧：
  - #ONCICS: CICS接続初期化
  - #SSVARS: 共通変数定義
  - SSC1A1: 顧客追加シナリオ1
  - SSC1I1: 顧客照会シナリオ1
  - SSP1A1-SSP4A1: ポリシー追加シナリオ（タイプ1-4）
  - SSP1D1-SSP4D1: ポリシー削除シナリオ（タイプ1-4）
  - SSP1I1-SSP4I1: ポリシー照会シナリオ（タイプ1-4）
  - SSP1U1-SSP3U1: ポリシー更新シナリオ（タイプ1-3）
  - STOP: シミュレーション終了
  - WSC1A1, WSC1I1: Webサービス経由顧客操作
- REGION=7Mにより7MBのリージョンサイズが確保される
- SYSUT1にはワークファイル用のCYL(10,10,50)の領域が確保される
