# バッチ設計書 16-ワークロードシミュレーション実行

## 概要

本ドキュメントは、GenAppアプリケーションに対するワークロードシミュレーションを実行するバッチジョブ（itpentr.jcl）の設計書です。

### 本バッチの処理概要

ワークロードシミュレーション実行バッチは、TPNS（Teleprocessing Network Simulator）を使用してGenAppアプリケーションの端末シミュレーションを実行するジョブです。

**業務上の目的・背景**：GenAppアプリケーションのリリース前検証や性能テストにおいて、多数の端末からの同時アクセスをシミュレートする必要があります。人手による手動テストでは限界があるため、自動化されたワークロードシミュレーションが不可欠です。本バッチは、事前にコンパイルされたテストスクリプト（itpstl.jcl）を実行し、顧客管理・ポリシー管理機能に対する大量のトランザクションを生成します。これにより、アプリケーションの品質・性能・安定性を検証できます。

**バッチの実行タイミング**：テスト実行時に随時実行されます。性能テスト、負荷テスト、回帰テストなどで使用されます。

**主要な処理内容**：
1. ITPENTERプログラムを使用してシミュレーションを開始
2. GENAPPネットワーク定義の読み込み
3. テストスクリプトの順次実行
4. 端末操作（画面入力、トランザクション実行）のシミュレーション
5. 実行結果のログ記録

**前後の処理との関連**：
- 前提：ITPスクリプトコンパイル（itpstl.jcl）が完了していること、対象CICSが起動していること
- 後続：ITPログリスト出力（itpll.jcl）での結果確認

**影響範囲**：GenAppアプリケーション全体、DB2データベース、テスト環境

## バッチ種別

テスト実行 / シミュレーション

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（テスト時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| スクリプトコンパイル完了 | itpstl.jclによるスクリプトコンパイルが完了していること |
| CICS起動済み | 対象CICSリージョンが起動していること |
| ネットワーク定義存在 | GENAPPネットワーク定義がINITDDに存在すること |
| ITPライブラリ利用可能 | SITPLOADライブラリがアクセス可能であること |

### 実行可否判定

CICSリージョンが起動済みで、トランザクションが受付可能な状態であることを確認。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| WSIMHLQ | 文字列 | Yes | なし | WSIMライブラリ高レベル修飾子 |
| WSIMWSX | 文字列 | Yes | なし | スクリプトPDSデータセット名 |
| WSIMMSX | 文字列 | Yes | なし | メッセージPDSデータセット名 |
| WSIMLGX | 文字列 | Yes | なし | ログファイルデータセット名 |
| NTWRK | 文字列 | Yes | GENAPP | ネットワーク名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| INITDD（WSIMWSX） | PDS | ネットワーク定義・初期化スクリプト |
| MSGDD（WSIMMSX, WSIMWSX） | PDS | メッセージ定義・スクリプトライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| LOGDD（WSIMLGX） | バイナリ | シミュレーション実行ログ |
| SYSPRINT | SYSOUT | 実行結果サマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | WSIMLGX（ログファイル） |
| 出力先 | 指定データセット |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. JOBステートメント処理
   └─ ジョブ名、リージョン設定（0M=無制限）
2. ITPENTERプログラム起動
   └─ PARM='NTWRK=GENAPP'でネットワーク指定
3. ネットワーク初期化
   └─ GENAPPネットワーク定義の読み込み
4. 端末シミュレーション開始
   └─ 仮想端末の生成と接続
5. テストシナリオ実行
   └─ 顧客操作、ポリシー操作の自動実行
6. 結果記録
   └─ LOGDDへの実行ログ書き込み
7. シミュレーション終了
   └─ 仮想端末の切断とクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ITPENTERプログラム起動]
    B --> C[ネットワーク初期化]
    C --> D[仮想端末生成]
    D --> E[CICS接続]
    E --> F{接続成功?}
    F -->|Yes| G[テストシナリオ実行]
    F -->|No| H[エラーログ出力]
    G --> I[顧客操作シミュレーション]
    I --> J[ポリシー操作シミュレーション]
    J --> K[実行ログ記録]
    K --> L[仮想端末切断]
    L --> M[バッチ正常終了]
    H --> N[バッチ異常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチ自体はデータベースを直接操作しませんが、シミュレートされたトランザクションによりCICS経由でDB2が操作されます。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客追加シナリオ | CUSTOMER | INSERT | 新規顧客登録 |
| 顧客照会シナリオ | CUSTOMER | SELECT | 顧客情報取得 |
| ポリシー追加シナリオ | POLICY | INSERT | 新規ポリシー登録 |
| ポリシー照会シナリオ | POLICY | SELECT | ポリシー情報取得 |
| ポリシー更新シナリオ | POLICY | UPDATE | ポリシー情報更新 |
| ポリシー削除シナリオ | POLICY | DELETE | ポリシー削除 |

### テーブル別操作詳細

シミュレーション内容に依存します。テストシナリオの設計に基づき、実際のDB操作が発生します。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CONNECT | 接続エラー | CICS未起動 | CICS起動確認 |
| TIMEOUT | タイムアウト | 応答遅延 | CICS状態確認 |
| SCRIPT | スクリプトエラー | 実行時エラー | スクリプト修正 |
| S013 | ファイルオープンエラー | ファイル不存在 | データセット確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプト定義依存 |
| リトライ間隔 | スクリプト定義依存 |
| リトライ対象エラー | 接続エラー、タイムアウト |

### 障害時対応

1. SYSPRINTおよびLOGDDの内容を確認
2. CICS側のログでトランザクション実行状況を確認
3. ネットワーク接続状態を確認
4. 必要に応じてスクリプトを修正し再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | シナリオ単位 |
| コミットタイミング | 各トランザクション終了時 |
| ロールバック条件 | トランザクションエラー時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | シナリオ依存（数百〜数千件） |
| 目標処理時間 | テスト計画依存 |
| メモリ使用量上限 | 無制限（REGION=0M） |

## 排他制御

シミュレーション中はCICS経由でデータベースにアクセスするため、通常のトランザクション排他制御が適用されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | シミュレーション開始時 | ネットワーク名、開始時刻 |
| 進捗ログ | シナリオ実行中 | 各操作の詳細 |
| 終了ログ | シミュレーション終了時 | 完了件数、処理時間 |
| エラーログ | エラー発生時 | エラー詳細、発生箇所 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ完了コード | CC > 0 | テスト担当者 |
| エラー件数 | 1件以上 | テスト担当者 |

## 備考

- ITPENTERはITP（Interactive Test/Production）シミュレーション実行エンジン
- PARM='NTWRK=GENAPP'によりGENAPPネットワーク定義を使用
- REGION=0Mにより無制限のリージョンサイズが確保される
- AUTOLOGはDUMMYで自動ログ機能は無効化
- シミュレーション結果はitpll.jclで可読形式に変換して確認
- 本番環境での実行は禁止（テスト環境専用）
