# バッチ設計書 18-顧客追加Webサービス生成

## 概要

本ドキュメントは、顧客追加機能（LGACUS01プログラム）のWebサービス定義（WSDL/WSBIND）を生成するバッチジョブ（wsaac01.jcl）の設計書です。

### 本バッチの処理概要

顧客追加Webサービス生成バッチは、COBOLプログラム（LGACUS01）の言語構造からWSDL（Web Services Description Language）とWSBIND（Web Service Binding）ファイルを自動生成するジョブです。

**業務上の目的・背景**：GenAppアプリケーションの顧客追加機能を外部システムから呼び出し可能なWebサービスとして公開するために、WSDLとWSBINDファイルが必要です。顧客追加機能は、新規顧客をDB2データベースに登録するビジネスロジックを提供します。本バッチは、既存のCOBOLプログラムをコード変更なしでWebサービス化するためのCICS Web Services機能をサポートします。

**バッチの実行タイミング**：Webサービス初期構築時、またはCOBOLプログラムのデータ構造変更時に随時実行されます。

**主要な処理内容**：
1. DFHLS2WSプロシージャの実行
2. COBOLコピーブック（SOAIC01）の解析
3. WSDL（Webサービス記述）ファイルの生成
4. WSBIND（バインディング情報）ファイルの生成
5. USS（Unix System Services）上へのファイル出力

**前後の処理との関連**：
- 前提：COBOLプログラム（LGACUS01）がコンパイル済みであること
- 後続：CICS CSD定義（Webサービス用Pipeline、Webservice定義）

**影響範囲**：Webサービスインターフェース、外部システム連携、顧客追加API

## バッチ種別

Webサービス生成 / コード変換

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（構築・変更時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| COBOLソース存在 | SOURCEXデータセットにSOAIC01コピーブックが存在すること |
| Java環境利用可能 | USS上にJava 6.0.1 64bit環境が利用可能であること |
| CICS TS環境 | CICS TS 6.6.0（cics660）がインストールされていること |
| zFS出力先存在 | ZFSHOMEパスが存在し書き込み可能であること |

### 実行可否判定

必要なライブラリとUSS環境が利用可能であることを確認。HTTPプロキシ設定が正しいことを確認。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CICSHLQ | 文字列 | Yes | なし | CICS高レベル修飾子 |
| SOURCEX | 文字列 | Yes | なし | COBOLソースPDSデータセット名 |
| ZFSHOME | 文字列 | Yes | なし | zFSルートパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PDSLIB（SOURCEX） | PDS | COBOLコピーブック |
| INPUT.SYSUT1 | インライン | LS2WS制御パラメータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| WSDL | XML | Webサービス定義ファイル |
| WSBIND | バイナリ | Webサービスバインディングファイル |
| LOGFILE | テキスト | 処理ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| WSDLファイル名 | {ZFSHOME}/genapp/wsdir/LGACUS01.wsdl |
| WSBINDファイル名 | {ZFSHOME}/genapp/wsdir/LGACUS01.wsbind |
| ログファイル名 | {ZFSHOME}/genapp/logs/LS2WS_LGACUS01.LOG |
| 文字コード | UTF-8（WSDL） |

## 処理フロー

### 処理シーケンス

```
1. JOBステートメント処理
   └─ ジョブ名、リージョン設定（900M）
2. JOBPROCライブラリ設定
   └─ CICS SDFHINSTライブラリ参照
3. DFHLS2WSプロシージャ実行
   └─ Java環境初期化
   └─ COBOLコピーブック解析
4. WSDL生成
   └─ サービス定義、オペレーション定義、データ型定義
5. WSBIND生成
   └─ CICSバインディング情報
6. ファイル出力
   └─ zFS上にファイル書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[DFHLS2WSプロシージャ起動]
    B --> C[Java環境初期化]
    C --> D[COBOLコピーブック読み込み]
    D --> E[データ構造解析]
    E --> F{解析成功?}
    F -->|Yes| G[WSDL生成]
    F -->|No| H[エラーログ出力]
    G --> I[WSBIND生成]
    I --> J[zFSへファイル出力]
    J --> K{出力成功?}
    K -->|Yes| L[バッチ正常終了]
    K -->|No| H
    H --> M[バッチ異常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースへの操作は行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | DB操作なし |

### テーブル別操作詳細

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| DFHPI8501 | コピーブックエラー | データ構造不正 | コピーブック確認 |
| DFHPI8530 | Java環境エラー | JVM起動失敗 | Java設定確認 |
| DFHPI8540 | 出力エラー | zFS書き込み失敗 | パス・権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. LOGFILEの内容を確認しエラー詳細を特定
2. コピーブック（SOAIC01）の構文を確認
3. zFSパスの存在・権限を確認
4. Java環境設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル生成処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/構築 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 900MB（REGION=900M） |

## 排他制御

出力ファイルへの書き込み時のみ排他制御が必要。同一ファイルへの同時書き込みは不可。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | 入力パラメータ情報 |
| 詳細ログ | 変換処理中 | データ構造解析結果 |
| 終了ログ | 処理完了時 | 出力ファイルパス |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ完了コード | CC > 0 | 開発担当者 |

## 備考

- DFHLS2WS（Language Structure to Web Service）はCICS提供のWebサービス生成ユーティリティ
- 生成パラメータ詳細：
  - PDSLIB: COBOLコピーブック格納PDS
  - LANG=COBOL: 言語指定
  - PGMNAME=LGACUS01: 対象プログラム名
  - REQMEM=SOAIC01: リクエストデータ構造メンバー
  - RESPMEM=SOAIC01: レスポンスデータ構造メンバー
  - URI=GENAPP/LGACUS01: サービスURI
  - PGMINT=COMMAREA: プログラムインターフェース（COMMAREA）
  - HTTPPROXY: プロキシサーバー設定
- Java環境: java601_bit64_ga/J6.0.1_64（64bit Java 6）
- CICS環境: cics660（CICS TS 6.6.0）
- REGION=900Mにより900MBのメモリが確保される
- 対象プログラムLGACUS01は顧客追加（Add Customer）機能を提供
- LGACDB01プログラムを呼び出してDB2にINSERT処理を実行
