# バッチ設計書: GENABIND (db2bind.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENABIND |
| JCLファイル | db2bind.jcl |
| カテゴリ | DB2データベース管理 |
| 説明 | DB2パッケージとプランのバインド処理 |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用するDB2パッケージとプランをバインドします。COBOLプログラムから生成されたDBRM（Database Request Module）をDB2システムに登録し、実行可能なパッケージとプランを作成します。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| BIND | IKJEFT01 | パッケージおよびプランのバインドと権限付与 |

### ステップ詳細

#### BIND ステップ

TSO/IKJEFTを使用してDB2バインドコマンドを実行します。

## 4. バインド対象パッケージ

### パッケージ一覧

| パッケージ名 | コレクションID | メンバー名 | 説明 |
|--------------|----------------|------------|------|
| GENASA1 | GENASA1 | LGICDB01 | 顧客情報照会(DB2) |
| GENASA1 | GENASA1 | LGIPDB01 | ポリシー情報照会(DB2) |
| GENASA1 | GENASA1 | LGDPDB01 | ポリシー削除(DB2) |
| GENASA1 | GENASA1 | LGAPDB01 | ポリシー追加(DB2) |
| GENASA1 | GENASA1 | LGACDB01 | 顧客追加(DB2) - パート1 |
| GENASA1 | GENASA1 | LGACDB02 | 顧客追加(DB2) - パート2 |
| GENASA1 | GENASA1 | LGUCDB01 | 顧客更新(DB2) |
| GENASA1 | GENASA1 | LGUPDB01 | ポリシー更新(DB2) |

### パッケージバインドオプション

各パッケージに共通で適用されるオプション:

| オプション | 設定値 | 説明 |
|------------|--------|------|
| ISO | CS | 分離レベル (Cursor Stability) |
| CURRENTDATA | NO | カレントデータアクセス |
| DEGREE | 1 | 並列度 |
| DYNAMICRULES | BIND | 動的SQL規則 |
| ACTION | REPLACE | 既存パッケージの置換 |
| EXPLAIN | NO | 実行計画の保存なし |
| OWNER | `<SQLID>` | オーナーID |
| QUALIFIER | `<DB2DBID>` | 修飾子 |
| ENABLE | BATCH,CICS | 有効化対象環境 |
| REL | DEALLOCATE | リリースタイミング |
| VALIDATE | BIND | 検証タイミング |

## 5. バインド対象プラン

### プラン情報

| プラン名 | 説明 |
|----------|------|
| GENAONE | GENAPPアプリケーション用統合プラン |

### プランバインドオプション

| オプション | 設定値 | 説明 |
|------------|--------|------|
| PKLIST | NULLID.*, *.GENASA1.* | パッケージリスト |
| CURRENTDATA | NO | カレントデータアクセス |
| ISO | CS | 分離レベル |
| ACTION | REP | 既存プランの置換 |
| OWNER | `<SQLID>` | オーナーID |
| QUALIFIER | `<DB2DBID>` | 修飾子 |
| REL | DEALLOCATE | リリースタイミング |
| ACQUIRE | USE | 取得タイミング |
| RETAIN | - | リソース保持 |
| NOREOPT | VARS | 再最適化抑止 |
| VALIDATE | BIND | 検証タイミング |

## 6. 権限付与

バインド後、以下の権限が付与されます:

| オブジェクト | 権限 | 付与先 |
|--------------|------|--------|
| PLAN GENAONE | EXECUTE | PUBLIC |

## 7. DD文定義

| DD名 | 説明 | データセット |
|------|------|-------------|
| STEPLIB | DB2ロードライブラリ | `<DB2HLQ>.SDSNLOAD` |
| DBRMLIB | DBRMライブラリ | `<DBRMLIX>` |
| SYSPRINT | プリント出力 | SYSOUT=* |
| SYSTSPRT | TSOプリント出力 | SYSOUT=* |
| SYSUDUMP | ダンプ出力 | SYSOUT=* |
| SYSTSIN | TSO入力(BINDコマンド) | インライン |
| SYSIN | SQL入力(GRANT文) | インライン |

## 8. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<DB2HLQ>` | DB2高レベル修飾子 |
| `<DB2SSID>` | DB2サブシステムID |
| `<DB2PLAN>` | DB2プラン名(DSNTIAD用) |
| `<DB2RUN>` | DB2実行ライブラリ修飾子 |
| `<DB2DBID>` | データベースID |
| `<DBRMLIX>` | DBRMライブラリ名 |
| `<SQLID>` | SQL作成者ID |

## 9. 前提条件

1. db2cre.jcl が正常に実行され、データベースとテーブルが作成済みであること
2. cobol.jcl が正常に実行され、DBRMが生成済みであること
3. DBRMライブラリに以下のメンバーが存在すること:
   - LGICDB01、LGIPDB01、LGDPDB01、LGAPDB01
   - LGACDB01、LGACDB02、LGUCDB01、LGUPDB01

## 10. 実行後の確認事項

1. 全てのパッケージが正常にバインドされていること
2. GENAONEプランが正常にバインドされていること
3. プランのEXECUTE権限がPUBLICに付与されていること

## 11. 障害時の対応

### パッケージバインドエラー

- DBRMが存在しない場合: cobol.jcl を再実行してDBRMを生成
- テーブルが存在しない場合: db2cre.jcl を実行してテーブルを作成

### プランバインドエラー

- パッケージが存在しない場合: 先にパッケージのバインドを完了させる
- 権限エラーの場合: SQLID のDB2権限を確認

## 12. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| db2cre.jcl | 事前実行必須（テーブル作成） |
| cobol.jcl | 事前実行必須（DBRM生成） |
| db2del.jcl | バインド解除時に実行 |
