# バッチ設計書 21-GENASOAP (wsaap01.jcl)

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるポリシー追加機能のWebサービス生成バッチ（wsaap01.jcl）の設計内容を記載する。

### 本バッチの処理概要

本バッチは、CICS環境で動作するポリシー追加プログラム（LGAPOL01）をWebサービスとして公開するためのWSDLファイルとWSBINDファイルを生成する。これにより、外部システムからSOAPプロトコルを通じてポリシー追加機能を呼び出すことが可能となる。

**業務上の目的・背景**：保険業務において、新規ポリシー（保険契約）の追加は基幹業務の一つである。従来はCICSトランザクションを通じてのみアクセス可能であったが、Webサービス化することで、Webアプリケーション、モバイルアプリ、外部パートナーシステムなど多様なチャネルからポリシー追加機能を利用できるようになる。これにより、業務効率の向上と顧客サービスの拡充が実現される。

**バッチの実行タイミング**：システム構築時または機能追加時に手動で実行する。Webサービスインターフェースの変更が必要な場合に再実行する。

**主要な処理内容**：
1. Motor Policy（自動車保険）用のWSDL/WSBINDファイル生成（LGAPOLM1）
2. House Policy（住宅保険）用のWSDL/WSBINDファイル生成（LGAPOLH1）
3. Endowment Policy（養老保険）用のWSDL/WSBINDファイル生成（LGAPOLE1）
4. Commercial Policy（商業保険）用のWSDL/WSBINDファイル生成（LGAPOLB1）

**前後の処理との関連**：COBOLプログラムのコンパイル（cobol.jcl）が事前に完了している必要がある。生成されたWebサービスはCSD定義（cdef124.jcl）により有効化される。

**影響範囲**：USS上のwsdirディレクトリにWSDL/WSBINDファイルが配置される。CICSのWebサービスパイプラインからこれらのファイルが参照される。

## バッチ種別

Webサービス生成 / システム構築支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| COBOLプログラムコンパイル完了 | LGAPOL01プログラムがコンパイルされていること |
| COPYBOOKの存在 | SOAIPM1、SOAIPH1、SOAIPE1、SOAIPB1が存在すること |
| USS環境準備 | /tmp、wsdir、logsディレクトリが存在すること |
| Java環境 | Java 6.0.1が利用可能であること |
| CICS TS環境 | CICS TS 6.6がインストールされていること |

### 実行可否判定

プログラムソースとCOPYBOOKが存在し、USS上の必要なディレクトリがアクセス可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PDSLIB | DSN | Yes | なし | COPYBOOKが格納されたPDSライブラリ |
| LANG | 文字列 | Yes | COBOL | プログラミング言語 |
| PGMNAME | 文字列 | Yes | LGAPOL01 | 対象プログラム名 |
| REQMEM | 文字列 | Yes | 各保険種別用 | リクエストCOPYBOOK名 |
| RESPMEM | 文字列 | Yes | 各保険種別用 | レスポンスCOPYBOOK名 |
| URI | 文字列 | Yes | GENAPP/LGAPOLx1 | Webサービスのエンドポイント |
| PGMINT | 文字列 | Yes | COMMAREA | プログラムインターフェース |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| LGAPOL01 | COBOLプログラム | ポリシー追加ビジネスロジックプログラム |
| SOAIPM1 | COPYBOOK | Motor Policy用コミュニケーションエリア定義 |
| SOAIPH1 | COPYBOOK | House Policy用コミュニケーションエリア定義 |
| SOAIPE1 | COPYBOOK | Endowment Policy用コミュニケーションエリア定義 |
| SOAIPB1 | COPYBOOK | Commercial Policy用コミュニケーションエリア定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| LGAPOLM1.wsdl | WSDL | Motor Policy追加WebサービスのWSDL定義 |
| LGAPOLM1.wsbind | WSBIND | Motor Policy追加WebサービスのWSBINDファイル |
| LGAPOLH1.wsdl | WSDL | House Policy追加WebサービスのWSDL定義 |
| LGAPOLH1.wsbind | WSBIND | House Policy追加WebサービスのWSBINDファイル |
| LGAPOLE1.wsdl | WSDL | Endowment Policy追加WebサービスのWSDL定義 |
| LGAPOLE1.wsbind | WSBIND | Endowment Policy追加WebサービスのWSBINDファイル |
| LGAPOLB1.wsdl | WSDL | Commercial Policy追加WebサービスのWSDL定義 |
| LGAPOLB1.wsbind | WSBIND | Commercial Policy追加WebサービスのWSBINDファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | LGAPOLx1.wsdl / LGAPOLx1.wsbind |
| 出力先 | {ZFSHOME}/genapp/wsdir/ |
| 文字コード | UTF-8 |
| 区切り文字 | XML形式 |

## 処理フロー

### 処理シーケンス

```
1. Motor Policy Webサービス生成
   └─ DFHLS2WSプロシージャでLGAPOLM1のWSDL/WSBINDを生成
2. House Policy Webサービス生成
   └─ DFHLS2WSプロシージャでLGAPOLH1のWSDL/WSBINDを生成
3. Endowment Policy Webサービス生成
   └─ DFHLS2WSプロシージャでLGAPOLE1のWSDL/WSBINDを生成
4. Commercial Policy Webサービス生成
   └─ DFHLS2WSプロシージャでLGAPOLB1のWSDL/WSBINDを生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Motor Policy WSDL/WSBIND生成]
    B --> C[House Policy WSDL/WSBIND生成]
    C --> D[Endowment Policy WSDL/WSBIND生成]
    D --> E[Commercial Policy WSDL/WSBIND生成]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | 本バッチはWebサービス定義の生成のみでDB操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RC=8 | 変換エラー | COPYBOOKの構文エラー | COPYBOOKの内容を確認し修正 |
| RC=12 | 環境エラー | USS環境へのアクセス失敗 | USSパーミッションを確認 |
| RC=16 | 入力エラー | 入力パラメータ不正 | JCLのパラメータを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. JOBLOGおよびログファイル（{ZFSHOME}/genapp/logs/LS2WS_LGAPOLx1.LOG）を確認
2. エラー内容に応じてCOPYBOOKまたはJCLパラメータを修正
3. バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（オフラインバッチ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4サービス定義 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 900MB（REGION指定） |

## 排他制御

本バッチは他バッチとの同時実行は可能だが、同一JCLの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | 処理開始メッセージ |
| 処理ログ | 変換処理中 | 変換進捗情報 |
| 終了ログ | 各ステップ終了時 | 処理完了メッセージとリターンコード |
| エラーログ | エラー発生時 | エラー詳細情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | システム運用担当 |
| エラー件数 | 1件以上 | システム運用担当 |

## 備考

- DFHLS2WSはCICS TSが提供するLanguage Structure to Web Service変換ユーティリティである
- HTTPPROXYパラメータはWSDL生成時の外部スキーマ参照用（必要に応じて設定）
- 生成されたWSDLはCICSのWebサービスパイプライン（GENAPIP1）から参照される
