# バッチ設計書 24-GENASOAP (wsavc01.jcl)

## 概要

本ドキュメントは、GENAPPアプリケーションにおける商業保険照会機能のWebサービス生成バッチ（wsavc01.jcl）の設計内容を記載する。

### 本バッチの処理概要

本バッチは、CICS環境で動作する顧客照会プログラム（LGICVS01）をWebサービスとして公開するためのWSDLファイルとWSBINDファイルを生成する。このプログラムはVSAMファイルから顧客番号を取得する機能を提供する。

**業務上の目的・背景**：保険業務において、顧客情報の照会は頻繁に発生する基本的なオペレーションである。特にVSAMベースの顧客データにアクセスする機能をWebサービス化することで、既存のVSAMデータ資産を活用しながら、現代的なWebサービスインターフェースを通じて外部システムやアプリケーションからアクセス可能にする。これにより、レガシーシステムのモダナイゼーションと新規システムとの統合が容易になる。

**バッチの実行タイミング**：システム構築時または機能追加時に手動で実行する。Webサービスインターフェースの変更が必要な場合に再実行する。

**主要な処理内容**：
1. VSAM顧客照会サービス（LGICVS01）のWSDL/WSBINDファイル生成

**前後の処理との関連**：COBOLプログラムのコンパイル（cobol.jcl）が事前に完了している必要がある。VSAMファイルの定義（adef121.jcl）が事前に実行されている必要がある。生成されたWebサービスはCSD定義により有効化される。

**影響範囲**：USS上のwsdirディレクトリにWSDL/WSBINDファイルが配置される。CICSのWebサービスパイプラインからこれらのファイルが参照される。

## バッチ種別

Webサービス生成 / システム構築支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| COBOLプログラムコンパイル完了 | LGICVS01プログラムがコンパイルされていること |
| COPYBOOKの存在 | SOAVCII（リクエスト用）、SOAVCIO（レスポンス用）が存在すること |
| USS環境準備 | /tmp、wsdir、logsディレクトリが存在すること |
| Java環境 | Java 6.0.1が利用可能であること |
| CICS TS環境 | CICS TS 6.6がインストールされていること |
| VSAMファイル定義完了 | KSDSCUSTファイルが定義されていること |

### 実行可否判定

プログラムソースとCOPYBOOKが存在し、USS上の必要なディレクトリがアクセス可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PDSLIB | DSN | Yes | なし | COPYBOOKが格納されたPDSライブラリ |
| LANG | 文字列 | Yes | COBOL | プログラミング言語 |
| PGMNAME | 文字列 | Yes | LGICVS01 | 対象プログラム名 |
| REQMEM | 文字列 | Yes | SOAVCII | リクエストCOPYBOOK名 |
| RESPMEM | 文字列 | Yes | SOAVCIO | レスポンスCOPYBOOK名 |
| URI | 文字列 | Yes | GENAPP/LGICVS01 | Webサービスのエンドポイント |
| PGMINT | 文字列 | Yes | COMMAREA | プログラムインターフェース |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| LGICVS01 | COBOLプログラム | VSAM顧客照会プログラム |
| SOAVCII | COPYBOOK | リクエスト用コミュニケーションエリア定義 |
| SOAVCIO | COPYBOOK | レスポンス用コミュニケーションエリア定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| LGICVS01.wsdl | WSDL | VSAM顧客照会WebサービスのWSDL定義 |
| LGICVS01.wsbind | WSBIND | VSAM顧客照会WebサービスのWSBINDファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | LGICVS01.wsdl / LGICVS01.wsbind |
| 出力先 | {ZFSHOME}/genapp/wsdir/ |
| 文字コード | UTF-8 |
| 区切り文字 | XML形式 |

## 処理フロー

### 処理シーケンス

```
1. VSAM顧客照会Webサービス生成
   └─ DFHLS2WSプロシージャでLGICVS01のWSDL/WSBINDを生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[VSAM顧客照会 WSDL/WSBIND生成]
    B --> C[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | 本バッチはWebサービス定義の生成のみでDB操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。生成されるWebサービスはVSAMファイル（KSDSCUST）にアクセスする。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RC=8 | 変換エラー | COPYBOOKの構文エラー | COPYBOOKの内容を確認し修正 |
| RC=12 | 環境エラー | USS環境へのアクセス失敗 | USSパーミッションを確認 |
| RC=16 | 入力エラー | 入力パラメータ不正 | JCLのパラメータを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. JOBLOGおよびログファイル（{ZFSHOME}/genapp/logs/LS2WS_LGICVS01.LOG）を確認
2. エラー内容に応じてCOPYBOOKまたはJCLパラメータを修正
3. バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（オフラインバッチ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1サービス定義 |
| 目標処理時間 | 2分以内 |
| メモリ使用量上限 | 900MB（REGION指定） |

## 排他制御

本バッチは他バッチとの同時実行は可能だが、同一JCLの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ステップ開始時 | 処理開始メッセージ |
| 処理ログ | 変換処理中 | 変換進捗情報 |
| 終了ログ | ステップ終了時 | 処理完了メッセージとリターンコード |
| エラーログ | エラー発生時 | エラー詳細情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分 | システム運用担当 |
| エラー件数 | 1件以上 | システム運用担当 |

## 備考

- DFHLS2WSはCICS TSが提供するLanguage Structure to Web Service変換ユーティリティである
- LGICVS01はVSAMファイル（KSDSCUST）からランダムに顧客番号を取得するプログラムである
- 顧客番号の範囲はTSキュー（GENACNTL）で管理される
- リクエスト用（SOAVCII）とレスポンス用（SOAVCIO）で異なるCOPYBOOKを使用する
- HTTPPROXYパラメータはWSDL生成時の外部スキーマ参照用（必要に応じて設定）
- バッチ一覧では「商業保険照会」と記載されているが、実際のJCLコメントは「Obtain CUSTOMER number from VSAM file」であり、VSAMからの顧客番号取得機能である
