# バッチ設計書 25-GENACSD (cdef122.jcl)

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるCICS System Definition (CSD)への追加リソース定義バッチ（cdef122.jcl）の設計内容を記載する。これはTOR-AOR-DOR（Terminal Owning Region - Application Owning Region - Data Owning Region）構成用のCSD定義バージョン2である。

### 本バッチの処理概要

本バッチは、CICS環境で動作するGENAPPアプリケーションのリソース定義をCSD（CICS System Definition）に登録する。cdef121.jclのバージョン2として、既存の定義を削除した上で再定義を行い、トランザクション、プログラム、DB2接続、ファイル定義などを設定する。

**業務上の目的・背景**：CICSアプリケーションを稼働させるためには、トランザクション、プログラム、DB2接続などのリソースをCSDに定義する必要がある。本バッチは、GENAPPアプリケーションの運用に必要な全てのリソース定義を一括で登録し、動的プログラム呼び出しやMIRORトランザクションによる分散処理を可能にする。

**バッチの実行タイミング**：システム初期構築時、またはCICS環境の再構築時に手動で実行する。リソース定義の変更が必要な場合に再実行する。

**主要な処理内容**：
1. 既存グループ定義の削除（GENATORT, GENATORP, GENAAORP, GENADORP, GENADORD, GENA）
2. グループのリストへの追加（TORLIST, AORLIST, DORLIST）
3. TOR用トランザクション定義（SSC1, SSP1-4, LGSE, LGCF, LGPF）
4. TOR用プログラム定義（LGICVS01, LGIPVS01等、Dynamic指定あり）
5. AOR用プログラム定義（ビジネスロジック、Dynamic/TransID指定あり）
6. DOR用トランザクション定義（MIRORトランザクション、DSCA, DSCI等）
7. DOR用プログラム定義（DBアクセス、VSAMアクセス）
8. DB2接続定義（DB2Conn, DB2Entry）
9. VSAMファイル定義（KSDSCUST, KSDSPOLY）
10. ENQモデル定義（GENAMOD）

**前後の処理との関連**：cdef121.jclが先に実行されている場合は、本バッチで定義が置き換えられる。COBOLプログラムのコンパイル（cobol.jcl）とDB2のバインド（db2bind.jcl）が事前に完了している必要がある。

**影響範囲**：CSDデータセットにリソース定義が登録される。CICS起動時にこれらの定義がインストールされる。

## バッチ種別

CSD定義 / システム構築支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CSDデータセット存在 | CSDデータセットが存在すること |
| CICS TSインストール | CICS TSがインストールされていること |
| COBOLプログラムコンパイル完了 | 定義するプログラムがコンパイル済みであること |
| DB2バインド完了 | DB2プラン（GENAONE）がバインド済みであること |
| VSAMファイル定義完了 | KSDSCUST, KSDSPOLYが定義済みであること |

### 実行可否判定

CSDデータセットへのアクセス権限があり、必要なプログラムとDBプランが準備されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CICSHLQ | DSN | Yes | なし | CICS TSの高位修飾子 |
| CSDNAME | DSN | Yes | なし | CSDデータセット名 |
| DB2SSID | 文字列 | Yes | なし | DB2サブシステムID |
| SQLID | 文字列 | Yes | なし | SQL認証ID |
| USRHLQ | DSN | Yes | なし | ユーザーデータセット高位修飾子 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSIN | DD文 | CSDコマンド入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CSD | データセット | CICSリソース定義 |
| SYSPRINT | SYSOUT | 処理ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CSDデータセット |
| 出力先 | 指定されたCSDデータセット |
| 文字コード | EBCDIC |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 既存グループの削除
   └─ GENATORT, GENATORP, GENAAORP, GENADORP, GENADORD, GENA を削除
2. グループのリストへの追加
   └─ TORLIST, AORLIST, DORLIST に各グループを追加
3. TOR用トランザクション定義
   └─ SSC1, SSP1-4, LGSE, LGCF, LGPF を定義
4. TOR用プログラム定義
   └─ Dynamic指定でプログラムを定義
5. AOR用プログラム定義
   └─ Dynamic/TransID指定でプログラムを定義
6. DOR用トランザクション定義
   └─ DFHMIRS（MIROR）を使用するトランザクションを定義
7. DOR用プログラム定義
   └─ DBアクセス、VSAMアクセス用プログラムを定義
8. DB2接続定義
   └─ DB2Conn, DB2Entry を定義
9. ファイル定義
   └─ KSDSCUST, KSDSPOLY を定義
10. ENQモデル定義
    └─ GENAMOD を定義
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[既存グループ削除]
    B --> C[グループをリストに追加]
    C --> D[TOR定義]
    D --> E[AOR定義]
    E --> F[DOR定義]
    F --> G[DB2接続定義]
    G --> H[ファイル定義]
    H --> I[ENQモデル定義]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | 本バッチはCSD定義のみでDB操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。DB2接続定義を登録するが、実際のDB接続は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RC=4 | 警告 | 削除対象が存在しない | 通常は無視可能 |
| RC=8 | エラー | 定義構文エラー | SYSINの定義内容を確認 |
| RC=12 | 重大エラー | CSDアクセスエラー | CSDデータセットの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. SYSPRINTの出力を確認
2. エラーメッセージに応じてSYSINの定義を修正
3. CSDデータセットの排他制御状態を確認
4. バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（オフラインバッチ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約80定義 |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | 1MB（REGION指定） |

## 排他制御

CSDデータセットへの排他アクセスが必要。他のCSDユーティリティやCICSリージョンとの同時アクセスは避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | 各コマンド実行時 | 実行されたCSDコマンドと結果 |
| エラーログ | エラー発生時 | エラーメッセージとリターンコード |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分 | システム運用担当 |
| リターンコード | RC>=8 | システム運用担当 |

## 備考

- DFHCSUDPはCICS TSが提供するCSD操作ユーティリティである
- cdef121.jclとの違い：Dynamic指定、TransID指定が追加されている
- TOR用プログラムはDynamic(Yes)とTransIDが設定され、動的呼び出しに対応
- AOR用プログラムはDynamic(Yes)とTransIDが設定され、DOR連携に対応
- DOR用トランザクションはDFHMIRS（MIROR）プログラムを使用し、分散処理を実現
- ENQmodel（GENAMOD）はGRS（Global Resource Serialization）用の定義
