# バッチ設計書 26-GENACSD (cdef123.jcl)

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるWebサービス用CSD定義バッチ（cdef123.jcl）の設計内容を記載する。これはCSD定義バージョン3として、SOAPベースのWebサービス機能に必要なリソースを定義する。

### 本バッチの処理概要

本バッチは、CICS環境でSOAP Webサービスを提供するために必要なリソース定義をCSD（CICS System Definition）に登録する。TCPIPサービスとパイプライン定義を行い、外部からのHTTPリクエストを受け付けてCOBOLプログラムを呼び出す基盤を構築する。

**業務上の目的・背景**：GENAPPアプリケーションの機能をWebサービスとして外部公開するためには、CICSにおけるWebサービス基盤の構築が必要である。本バッチは、TCPIPサービスとパイプラインを定義することで、SOAP 1.1プロトコルに準拠したWebサービスの受付環境を構築する。これにより、既存のCOBOLプログラムを変更せずにWebサービスとして公開可能になる。

**バッチの実行タイミング**：システム初期構築時、またはWebサービス環境の構築・変更時に手動で実行する。

**主要な処理内容**：
1. Webサービス用グループ（GENAWSRV）のAORリストへの追加
2. TCPIPサービス定義（GENATCP1）- ポート4321でHTTPリクエストを受付
3. パイプライン定義（GENAPIP1）- SOAP 1.1プロバイダー用パイプライン設定

**前後の処理との関連**：cdef121.jclまたはcdef122.jclで基本のCSD定義が完了している必要がある。Webサービス生成バッチ（wsaic01.jcl等）で生成されたWSBINDファイルがWSdirに配置されている必要がある。

**影響範囲**：CSDデータセットにWebサービス関連のリソース定義が登録される。CICS起動後、指定ポートでHTTPリクエストの受付が開始される。

## バッチ種別

CSD定義 / Webサービス基盤構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CSDデータセット存在 | CSDデータセットが存在すること |
| 基本CSD定義完了 | cdef121/122でGENAPP基本定義が完了していること |
| パイプライン設定ファイル | basicsoap11provider.xmlがCICSサンプルに存在すること |
| USS環境準備 | shelfディレクトリ、wsdirディレクトリが存在すること |

### 実行可否判定

CSDデータセットへのアクセス権限があり、パイプライン設定ファイルとWSDL/WSBINDファイルが準備されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CICSHLQ | DSN | Yes | なし | CICS TSの高位修飾子 |
| CSDNAME | DSN | Yes | なし | CSDデータセット名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSIN | DD文 | CSDコマンド入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CSD | データセット | CICSリソース定義（TCPIPSERVICE、PIPELINE） |
| SYSPRINT | SYSOUT | 処理ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CSDデータセット |
| 出力先 | 指定されたCSDデータセット |
| 文字コード | EBCDIC |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. グループのリストへの追加
   └─ GENAWSRV グループを AORLIST に追加
2. TCPIPサービス定義
   └─ GENATCP1: ポート4321、HTTPプロトコル、CWXNトランザクション
3. パイプライン定義
   └─ GENAPIP1: SOAP 1.1プロバイダー用パイプライン
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GENAWSRVをAORLISTに追加]
    B --> C[TCPIPサービス定義]
    C --> D[パイプライン定義]
    D --> E[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | 本バッチはCSD定義のみでDB操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RC=4 | 警告 | グループが既に存在 | 通常は無視可能 |
| RC=8 | エラー | 定義構文エラー | SYSINの定義内容を確認 |
| RC=12 | 重大エラー | CSDアクセスエラー | CSDデータセットの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. SYSPRINTの出力を確認
2. エラーメッセージに応じてSYSINの定義を修正
3. USS上のパイプライン設定ファイルとwsdirの存在を確認
4. バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（オフラインバッチ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 3定義 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 1MB（REGION指定） |

## 排他制御

CSDデータセットへの排他アクセスが必要。他のCSDユーティリティやCICSリージョンとの同時アクセスは避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | 各コマンド実行時 | 実行されたCSDコマンドと結果 |
| エラーログ | エラー発生時 | エラーメッセージとリターンコード |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 2分 | システム運用担当 |
| リターンコード | RC>=8 | システム運用担当 |

## 備考

- DFHCSUDPはCICS TSが提供するCSD操作ユーティリティである
- TCPIPサービス（GENATCP1）の設定詳細：
  - ポート番号: 4321
  - プロトコル: HTTP
  - トランザクション: CWXN（CICS Web Services handler）
  - URM: NONE
- パイプライン（GENAPIP1）の設定詳細：
  - 設定ファイル: /usr/lpp/cicsts/cics660/samples/pipelines/basicsoap11provider.xml
  - Shelf: /var/cicstsge/
  - WSdir: /u/s8smith/genapp/wsdir（環境に応じて変更）
- SOAP 1.1プロバイダー用パイプラインはCICSサンプルとして提供されている
- Webサービスのエンドポイントは http://{hostname}:4321/GENAPP/{サービス名} となる
