# バッチ設計書 28-GENACSD (cdef125.jcl)

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるイベント処理およびトランザクションスループット用CSD定義バッチ（cdef125.jcl）の設計内容を記載する。これはCSD定義バージョン5である。

> **注意**: cdef125.jclの内容はcdef124.jclと同一です。これは環境や構成の違いに応じて使い分けるための複製、または将来の拡張用として準備されている可能性があります。

### 本バッチの処理概要

本バッチは、CICS環境でビジネスイベント処理を行うために必要なリソース定義をCSD（CICS System Definition）に登録する。イベント統計プログラム、Webベースの統計表示プログラム、およびビジネスイベントバンドルを定義し、トランザクションスループットの監視と分析を可能にする。

**業務上の目的・背景**：GENAPPアプリケーションの運用において、トランザクションの実行状況を監視し、ビジネスイベントを検知・処理することは、業務効率の向上とシステム品質の維持に不可欠である。本バッチは、イベント駆動型アーキテクチャに必要なリソースを定義し、リアルタイムな統計情報の取得とビジネスイベントの発行を実現する。

**バッチの実行タイミング**：システム初期構築時、またはイベント処理環境の構築・変更時に手動で実行する。cdef124.jclの代替として、または追加環境用として使用される可能性がある。

**主要な処理内容**：
1. イベント処理用グループ（GENAEVNT）のTORリストへの追加
2. 統計プログラム定義（LGASTAT1）- トランザクションスループット統計収集
3. Web統計表示プログラム定義（LGWEBST5）- Webブラウザでの統計表示
4. トランザクション定義（LGST, SSST）- 統計関連トランザクション
5. ビジネスイベントバンドル定義（GENAEV01）- CICSビジネスイベント設定

**前後の処理との関連**：基本のCSD定義（cdef121/122）が完了している必要がある。ビジネスイベント用のバンドルファイルがUSS上に配置されている必要がある。

**影響範囲**：CSDデータセットにイベント処理関連のリソース定義が登録される。CICS起動後、ビジネスイベントの発行と統計収集が可能になる。

## バッチ種別

CSD定義 / イベント処理基盤構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CSDデータセット存在 | CSDデータセットが存在すること |
| 基本CSD定義完了 | cdef121/122でGENAPP基本定義が完了していること |
| プログラムコンパイル完了 | LGASTAT1, LGWEBST5がコンパイル済みであること |
| バンドルファイル配置 | /u/s8smith/genapp/genapp にバンドルが配置されていること |

### 実行可否判定

CSDデータセットへのアクセス権限があり、統計プログラムとバンドルファイルが準備されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CICSHLQ | DSN | Yes | なし | CICS TSの高位修飾子 |
| CSDNAME | DSN | Yes | なし | CSDデータセット名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSIN | DD文 | CSDコマンド入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CSD | データセット | CICSリソース定義（PROGRAM、TRANSACTION、BUNDLE） |
| SYSPRINT | SYSOUT | 処理ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CSDデータセット |
| 出力先 | 指定されたCSDデータセット |
| 文字コード | EBCDIC |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. グループのリストへの追加
   └─ GENAEVNT グループを TORLIST に追加
2. プログラム定義
   └─ LGASTAT1: トランザクションスループット統計プログラム
   └─ LGWEBST5: Web統計表示プログラム
3. トランザクション定義
   └─ LGST: LGASTAT1を呼び出すトランザクション
   └─ SSST: LGWEBST5を呼び出すトランザクション
4. バンドル定義
   └─ GENAEV01: ビジネスイベント用バンドル
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GENAEVNTをTORLISTに追加]
    B --> C[プログラム定義]
    C --> D[トランザクション定義]
    D --> E[バンドル定義]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | 本バッチはCSD定義のみでDB操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RC=4 | 警告 | グループが既に存在 | 通常は無視可能 |
| RC=8 | エラー | 定義構文エラー | SYSINの定義内容を確認 |
| RC=12 | 重大エラー | CSDアクセスエラー | CSDデータセットの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. SYSPRINTの出力を確認
2. エラーメッセージに応じてSYSINの定義を修正
3. USS上のバンドルディレクトリの存在を確認
4. バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（オフラインバッチ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 5定義 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 1MB（REGION指定） |

## 排他制御

CSDデータセットへの排他アクセスが必要。他のCSDユーティリティやCICSリージョンとの同時アクセスは避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | 各コマンド実行時 | 実行されたCSDコマンドと結果 |
| エラーログ | エラー発生時 | エラーメッセージとリターンコード |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 2分 | システム運用担当 |
| リターンコード | RC>=8 | システム運用担当 |

## 備考

- DFHCSUDPはCICS TSが提供するCSD操作ユーティリティである
- **重要**: 本JCL（cdef125.jcl）はcdef124.jclと同一内容である。これは以下の目的で存在する可能性がある：
  - 異なる環境への適用用（本番/テスト環境の分離）
  - 将来の拡張用予約
  - バージョン管理上の理由
- 定義されるリソースの詳細：
  - LGASTAT1: トランザクションスループット統計を収集するプログラム
  - LGWEBST5: Webブラウザで統計情報を表示するプログラム
  - LGST: 端末から統計収集を実行するトランザクション
  - SSST: Web経由で統計表示を実行するトランザクション
  - GENAEV01: ビジネスイベントを発行するためのCICSバンドル
- バンドルディレクトリ（/u/s8smith/genapp/genapp）にはビジネスイベント定義ファイルが配置される
- cdef124.jclとcdef125.jclのどちらを使用するかは、環境構成に応じて決定すること
