# バッチ設計書 29-GENACSD (cpsmde2.jcl)

## 概要

本ドキュメントは、GENAPPアプリケーションにおけるCICSPlex SM（System Manager）関連のリソース定義バッチ（cpsmde2.jcl）の設計内容を記載する。このバッチは、CICSPlex SMを使用したワークロード管理（WLM）の定義を行う。

### 本バッチの処理概要

本バッチは、CICSPlex SMのバッチユーティリティ（EYU9XDBT）を使用して、GENAPPアプリケーションのワークロード管理に必要なリソース定義を行う。CICSplex、リージョン、CICSグループ、リソースグループ、ワークロード定義などを一括で設定し、複数CICSリージョン間でのトランザクションルーティングと負荷分散を実現する。

**業務上の目的・背景**：大規模なCICS環境では、複数のCICSリージョンを効率的に管理し、ワークロードを適切に分散させることが重要である。本バッチは、CICSPlex SMを使用してTOR-AOR-DOR構成のワークロード管理を定義し、トランザクションの動的ルーティングと負荷分散を可能にする。これにより、システムの可用性向上とパフォーマンス最適化が実現される。

**バッチの実行タイミング**：CICSPlex SM環境の初期構築時、またはワークロード管理設定の変更時に手動で実行する。

**主要な処理内容**：
1. CICSplex（GNAPPLEX）の定義
2. CICSリージョン（TOR、AOR、DOR）の登録
3. CICSグループの定義（GENATOR、GENAAOR、GENADOR、GENAALL）
4. リソースグループとリソース記述の定義
5. トランザクショングループの定義（GENAWLMT）
6. ワークロード定義（GENAWLMD）の設定
7. ワークロード仕様（GENAWLM、GENBWLM）の設定
8. トランザクションルーティングの設定

**前後の処理との関連**：CICSPlex SM CMASが起動している必要がある。基本のCSD定義（cdef121/122/123）が完了している必要がある。CMASデータリポジトリ（defdrep.jcl）が初期化されている必要がある。

**影響範囲**：CICSPlex SMデータリポジトリにワークロード管理定義が登録される。CICSPlex SM管理下の全リージョンに設定が反映される。

## バッチ種別

CICSPlex SM定義 / ワークロード管理構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CMAS起動 | CICSPlex SM CMASが稼働していること |
| データリポジトリ初期化完了 | CMASデータリポジトリが初期化されていること |
| CICSリージョン定義 | TOR、AOR、DORリージョンがCICSPlex SMに認識されていること |
| CSD定義完了 | 基本のCSD定義が完了していること |

### 実行可否判定

CMASデータリポジトリへのアクセス権限があり、CICSPlex SM環境が正常に稼働していること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CPSMHLQ | DSN | Yes | なし | CICSPlex SMの高位修飾子 |
| CMASAPPL | 文字列 | Yes | なし | CMASアプリケーションID |
| TORAPPL | 文字列 | Yes | なし | TORアプリケーションID |
| AORAPPL | 文字列 | Yes | なし | AORアプリケーションID |
| DORAPPL | 文字列 | Yes | なし | DORアプリケーションID |
| TORSYSID | 文字列 | Yes | なし | TORシステムID |
| AORSYSID | 文字列 | Yes | なし | AORシステムID |
| DORSYSID | 文字列 | Yes | なし | DORシステムID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSIN | DD文 | CICSPlex SM定義コマンド |
| RESDEFS | DD文 | リソース定義入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CMASリポジトリ | データセット | CICSPlex SM定義 |
| SYSPRINT | SYSOUT | 処理ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CMASデータリポジトリ |
| 出力先 | CICSPlex SM管理下 |
| 文字コード | EBCDIC |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. CICSplex定義
   └─ GNAPPLEX として CICSplex を定義
2. リージョン登録
   └─ TOR、AOR、DOR の各リージョンを登録
3. CICSグループ定義
   └─ GENATOR、GENAAOR、GENADOR、GENAALL を定義
4. グループへのリージョン追加
   └─ 各リージョンを適切なグループに追加
5. リソースグループ/記述定義
   └─ GENAPP リソースグループ、RDGENAPP リソース記述を定義
6. トランザクショングループ定義
   └─ GENAWLMT でDOR実行トランザクションを定義
7. ワークロード定義
   └─ GENAWLMD でAORスコープのルーティングを定義
8. ワークロード仕様定義
   └─ GENAWLM（AOR）、GENBWLM（DOR）を定義
9. トランザクションのグループへの追加
   └─ DS*、VS* トランザクションをトランザクショングループに追加
10. ワークロード仕様とリージョンのリンク
    └─ GENAWLM を TOR に、GENBWLM を AOR にリンク
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CICSplex定義]
    B --> C[リージョン登録]
    C --> D[CICSグループ定義]
    D --> E[リソース定義]
    E --> F[トランザクショングループ定義]
    F --> G[ワークロード定義]
    G --> H[ワークロード仕様定義]
    H --> I[リンク設定]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | 本バッチはCICSPlex SM定義のみでDB操作なし |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。CICSPlex SMデータリポジトリへの定義登録のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RC=4 | 警告 | 定義が既に存在 | 通常は無視可能 |
| RC=8 | エラー | 定義構文エラー | SYSIN/RESDEFSの内容を確認 |
| RC=12 | 重大エラー | CMASリポジトリアクセスエラー | CMASの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

1. SYSPRINTの出力を確認
2. エラーメッセージに応じてSYSIN/RESDEFSの定義を修正
3. CMASの稼働状態を確認
4. バッチを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（オフラインバッチ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約30定義 |
| 目標処理時間 | 2分以内 |
| メモリ使用量上限 | なし |

## 排他制御

CMASデータリポジトリへの排他アクセスが必要。他のCICSPlex SM定義ジョブとの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 処理ログ | 各コマンド実行時 | 実行されたCICSPlex SMコマンドと結果 |
| エラーログ | エラー発生時 | エラーメッセージとリターンコード |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分 | システム運用担当 |
| リターンコード | RC>=8 | システム運用担当 |

## 備考

- EYU9XDBTはCICSPlex SMが提供するバッチデータベースユーティリティである
- 主要な定義オブジェクトの詳細：
  - **CICSPLEX (GNAPPLEX)**: GENAPPアプリケーション用のCICSplex
  - **REGION**: TOR、AOR、DORの各CICSリージョン
  - **CICSGRP**: リージョンをグループ化（GENATOR、GENAAOR、GENADOR、GENAALL）
  - **RESGROUP (GENAPP)**: リソースグループ定義
  - **RESDESC (RDGENAPP)**: リソース記述（自動インストール、ローカルスコープ設定）
  - **TRANGRP (GENAWLMT)**: DOR実行トランザクションのグループ（DS*、VS*トランザクション）
  - **WLMDEF (GENAWLMD)**: ワークロード定義（AORスコープ:GENADOR）
  - **WLMGROUP (GENAWLMG)**: ワークロードグループ
  - **WLMSPEC (GENAWLM, GENBWLM)**: ワークロード仕様（QUEUEアルゴリズム、DB2監視イベント）
- ワークロード管理の動作：
  - TORからのトランザクションはGENAWLMを通じてAORにルーティング
  - AORからのトランザクションはGENBWLMを通じてDORにルーティング
  - アルゴリズムはQUEUE（キュー長に基づく負荷分散）
  - DB2モニタリングイベント（DB2MOND）と連携
