# バッチ設計書: GENADB2 (db2del.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENADB2 |
| JCLファイル | db2del.jcl |
| カテゴリ | DB2データベース管理 |
| 説明 | DB2データベースオブジェクトの削除 |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用するDB2データベース環境をクリーンアップします。テーブル、テーブルスペース、データベース、ストレージグループを順次削除し、バインドされたパッケージとプランも解放します。db2cre.jcl で作成したオブジェクトを完全に削除するためのバッチです。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| DELETE | IKJEFT01 | DB2オブジェクトの削除およびパッケージ/プランの解放 |

### ステップ詳細

#### DELETE ステップ

TSO/IKJEFTを使用してDB2コマンドとSQL文を実行します。

**実行順序:**

1. DSN SYSTEM接続
2. DSNTIADプログラム実行
3. パッケージの解放 (FREE PACKAGE)
4. プランの解放 (FREE PLAN)
5. テーブルの削除 (DROP TABLE)
6. テーブルスペースの削除 (DROP TABLESPACE)
7. データベースの削除 (DROP DATABASE)
8. ストレージグループの削除 (DROP STOGROUP)

## 4. 削除対象オブジェクト

### パッケージ/プラン解放

| オブジェクト種別 | オブジェクト名 |
|------------------|----------------|
| PACKAGE | GENASA1.* (全パッケージ) |
| PLAN | GENAONE |

### テーブル削除

| テーブル名 | 説明 |
|------------|------|
| customer | 顧客情報テーブル |
| customer_secure | 顧客セキュリティテーブル |
| policy | 保険証券テーブル |
| house | 住宅保険テーブル |
| endowment | 養老保険テーブル |
| motor | 自動車保険テーブル |
| commercial | 商業保険テーブル |
| claim | 請求テーブル |

### テーブルスペース削除

| テーブルスペース名 |
|--------------------|
| GENATS01 |
| GENATS02 |
| GENATS03 |
| GENATS04 |
| GENATS05 |
| GENATS06 |
| GENATS07 |

### データベース/ストレージグループ削除

| オブジェクト種別 | オブジェクト名 |
|------------------|----------------|
| DATABASE | `<DB2DBID>` |
| STOGROUP | GENASG02 |

## 5. 削除順序の重要性

DB2オブジェクトには依存関係があるため、以下の順序で削除する必要があります:

```
1. パッケージ/プラン解放
   ↓
2. テーブル削除 (外部キー制約のあるテーブルから)
   ↓
3. テーブルスペース削除
   ↓
4. データベース削除
   ↓
5. ストレージグループ削除
```

**注意:** テーブル間の外部キー制約により、削除順序が重要です。

## 6. DD文定義

| DD名 | 説明 | データセット |
|------|------|-------------|
| JOBLIB | DB2ロードライブラリ | `<DB2HLQ>.SDSNLOAD` |
| SYSTSPRT | TSOプリント出力 | SYSOUT=* |
| SYSTSIN | TSO入力(DSNコマンド) | インライン |
| SYSPRINT | プリント出力 | SYSOUT=* |
| SYSUDUMP | ダンプ出力 | SYSOUT=* |
| SYSIN | SQL入力(DROP文) | インライン |

## 7. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<DB2HLQ>` | DB2高レベル修飾子 |
| `<DB2SSID>` | DB2サブシステムID |
| `<DB2PLAN>` | DB2プラン名(DSNTIAD用) |
| `<DB2RUN>` | DB2実行ライブラリ修飾子 |
| `<DB2DBID>` | データベースID |

## 8. 処理フロー

```
┌─────────────────────────────────────────┐
│ START: GENADB2 (db2del.jcl)            │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DB2接続: DSN SYSTEM(<DB2SSID>)         │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ FREE PACKAGE(GENASA1.*)                 │
│ FREE PLAN(GENAONE)                      │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DROP TABLE (8テーブル)                  │
│ - customer, customer_secure, policy     │
│ - house, endowment, motor               │
│ - commercial, claim                     │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DROP TABLESPACE (7テーブルスペース)      │
│ GENATS01 ～ GENATS07                    │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ COMMIT                                   │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DROP DATABASE <DB2DBID>                 │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ COMMIT                                   │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DROP STOGROUP GENASG02                  │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ END                                      │
└─────────────────────────────────────────┘
```

## 9. 前提条件

1. DB2サブシステムが稼働していること
2. DSNTIADプログラムが実行可能であること
3. db2cre.jcl で作成されたオブジェクトが存在すること（存在しない場合はエラーとなるが継続可能）

## 10. 実行後の確認事項

1. 全てのパッケージとプランが解放されていること
2. 全てのテーブルが削除されていること
3. 全てのテーブルスペースが削除されていること
4. データベースが削除されていること
5. ストレージグループが削除されていること

## 11. 障害時の対応

### オブジェクトが存在しない場合

- DB2は存在しないオブジェクトへのDROP実行時にエラーを返しますが、JCL実行は継続されます

### 参照整合性制約エラー

- 依存するオブジェクトが残っている場合は、手動で削除するか、順序を確認して再実行

### アクティブなセッションがある場合

- データベースを使用中のセッションがある場合、削除に失敗します
- 全てのセッションを終了させてから再実行してください

## 12. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| db2cre.jcl | このバッチで削除するオブジェクトを作成 |
| db2bind.jcl | このバッチで解放するパッケージ/プランを作成 |

## 13. 使用上の注意

- **本番環境での実行には十分な注意が必要です**
- 実行前にデータのバックアップを取得してください
- テスト環境での検証を推奨します
