# バッチ設計書: GENACOMP (cobol.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENACOMP |
| JCLファイル | cobol.jcl |
| カテゴリ | COBOLコンパイル |
| 説明 | COBOLプログラムのコンパイルとリンケージエディット |

## 2. 処理概要

このバッチは、GENAPPアプリケーションを構成する全てのCOBOLプログラムをコンパイルし、実行可能なロードモジュールを生成します。DB2プリコンパイラを使用してSQL文を含むCOBOLソースを処理し、CICS環境で実行可能なプログラムを作成します。

## 3. プロシージャ定義

### DB2PROC プロシージャ

COBOLコンパイルとリンケージエディットを実行する再利用可能なプロシージャです。

#### プロシージャ内ステップ

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| COBL | IGYCRCTL | COBOLコンパイル(DB2/CICS対応) |
| COPYLINK | IEBGENER | DFHEILICのリブロック |
| LKED | HEWL | リンケージエディット |

## 4. コンパイル対象プログラム

### プログラム一覧 (全27プログラム)

| プログラム名 | 機能分類 | 説明 |
|--------------|----------|------|
| LGACDB01 | 顧客管理(DB2) | 顧客追加処理 パート1 |
| LGACDB02 | 顧客管理(DB2) | 顧客追加処理 パート2 |
| LGACUS01 | 顧客管理 | 顧客追加メイン処理 |
| LGACVS01 | 顧客管理(VSAM) | 顧客追加VSAM処理 |
| LGAPDB01 | ポリシー管理(DB2) | ポリシー追加DB2処理 |
| LGAPOL01 | ポリシー管理 | ポリシー追加メイン処理 |
| LGAPVS01 | ポリシー管理(VSAM) | ポリシー追加VSAM処理 |
| LGASTAT1 | 統計 | 統計処理 |
| LGDPDB01 | ポリシー管理(DB2) | ポリシー削除DB2処理 |
| LGDPOL01 | ポリシー管理 | ポリシー削除メイン処理 |
| LGDPVS01 | ポリシー管理(VSAM) | ポリシー削除VSAM処理 |
| LGICDB01 | 顧客管理(DB2) | 顧客照会DB2処理 |
| LGICUS01 | 顧客管理 | 顧客照会メイン処理 |
| LGICVS01 | 顧客管理(VSAM) | 顧客照会VSAM処理 |
| LGIPDB01 | ポリシー管理(DB2) | ポリシー照会DB2処理 |
| LGIPOL01 | ポリシー管理 | ポリシー照会メイン処理 |
| LGIPVS01 | ポリシー管理(VSAM) | ポリシー照会VSAM処理 |
| LGSETUP | セットアップ | TSキュー初期設定 |
| LGSTSQ | キュー管理 | TSキューメッセージ出力 |
| LGTESTC1 | テスト | 顧客メニュープログラム |
| LGTESTP1 | テスト | 自動車保険メニュープログラム |
| LGTESTP2 | テスト | 生命保険メニュープログラム |
| LGTESTP3 | テスト | 住宅保険メニュープログラム |
| LGTESTP4 | テスト | 商業保険メニュープログラム |
| LGUCDB01 | 顧客管理(DB2) | 顧客更新DB2処理 |
| LGUCUS01 | 顧客管理 | 顧客更新メイン処理 |
| LGUCVS01 | 顧客管理(VSAM) | 顧客更新VSAM処理 |
| LGUPDB01 | ポリシー管理(DB2) | ポリシー更新DB2処理 |
| LGUPOL01 | ポリシー管理 | ポリシー更新メイン処理 |
| LGUPVS01 | ポリシー管理(VSAM) | ポリシー更新VSAM処理 |
| LGWEBST5 | Webサービス | Webサービス処理 |

## 5. コンパイラオプション

### SYSOPTFで指定されるオプション

| オプション | 設定値 | 説明 |
|------------|--------|------|
| NODYNAM | - | 動的CALLを使用しない |
| RENT | - | リエントラントコード生成 |
| APOST | - | アポストロフィをリテラル区切りに使用 |
| CICS | - | CICSトランスレータ統合 |
| CODEPAGE | `<DB2CCSID>` | コードページ指定 |

## 6. ステップ詳細

### COBL ステップ (COBOLコンパイル)

| 項目 | 内容 |
|------|------|
| プログラム | IGYCRCTL (Enterprise COBOL) |
| パラメータ | OPTFILE |
| リージョン | 128M (JOBレベル) |

**入力DD:**

| DD名 | 説明 |
|------|------|
| STEPLIB | COBOL、CICS、DB2ライブラリ |
| SYSLIB | コピーブック、マクロライブラリ |
| SYSIN | ソースメンバー |

**出力DD:**

| DD名 | 説明 |
|------|------|
| SYSLIN | オブジェクトモジュール (&&LOADSET) |
| DBRMLIB | DBRMモジュール |
| SYSPRINT | コンパイルリスト |

### COPYLINK ステップ (DFHEILICリブロック)

| 項目 | 内容 |
|------|------|
| プログラム | IEBGENER |
| 条件 | COND=(7,LT,COBL) |
| 入力 | DFHEILIC (CICS言語インターフェース) |
| 出力 | &&COPYLINK (一時データセット) |

### LKED ステップ (リンケージエディット)

| 項目 | 内容 |
|------|------|
| プログラム | HEWL (Linkage Editor) |
| 条件 | COND=(7,LT,COBL) |
| パラメータ | LIST,XREF,RENT,NAME=&MEM |

**入力DD:**

| DD名 | 説明 |
|------|------|
| SYSLIB | CICS、DB2、LE、ロードライブラリ |
| SYSLIN | &&COPYLINK、&&LOADSET、LINKPARM |

**出力DD:**

| DD名 | 説明 |
|------|------|
| SYSLMOD | ロードモジュール出力先 |
| SYSPRINT | リンクエディットリスト |

## 7. DD文定義

### JOBレベル

| DD名 | 説明 | データセット |
|------|------|-------------|
| (なし) | - | - |

### プロシージャレベル (COBL)

| DD名 | 説明 | データセット |
|------|------|-------------|
| STEPLIB | コンパイラ・ライブラリ | `<COBOLHLQ>.SIGYCOMP`、`<CICSHLQ>.SDFHLOAD`、`<DB2HLQ>.SDSNEXIT`、`<DB2HLQ>.SDSNLOAD` |
| SYSLIB | コピーブック | `<CICSHLQ>.SDFHCOB`、`<CICSHLQ>.SDFHMAC`、`<CICSHLQ>.SDFHSAMP`、`<DB2HLQ>.SDSNSAMP`、`<DB2HLQ>.SDSNMACS`、`<MAPCOPX>`、`<SOURCEX>` |
| SYSIN | ソースコード | `<SOURCEX>(&MEM)` |
| DBRMLIB | DBRM出力 | `<DBRMLIX>(&MEM)` |
| SYSLIN | オブジェクト | &&LOADSET |
| SYSUT1-15 | ワークファイル | SYSDA |
| SYSMDECK | デッキ出力 | SYSDA |
| SYSOPTF | オプションファイル | インライン |
| SYSPRINT | 出力リスト | SYSOUT=* |

### プロシージャレベル (LKED)

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSLIB | リンクライブラリ | `<CICSHLQ>.SDFHLOAD`、`<DB2HLQ>.SDSNLOAD`、`<CEEHLQ>.SCEELKED`、`<LOADX>` |
| SYSLMOD | ロードモジュール | `<LOADX>(&MEM)` |
| SYSUT1 | ワークファイル | SYSDA |
| SYSPRINT | リンクリスト | SYSOUT=* |
| SYSLIN | 入力 | &&COPYLINK、&&LOADSET、`<SOURCEX>(LINKPARM)` |

## 8. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<COBOLHLQ>` | COBOLコンパイラ高レベル修飾子 |
| `<CICSHLQ>` | CICS高レベル修飾子 |
| `<DB2HLQ>` | DB2高レベル修飾子 |
| `<CEEHLQ>` | Language Environment高レベル修飾子 |
| `<SOURCEX>` | ソースライブラリ |
| `<MAPCOPX>` | マップコピーブックライブラリ |
| `<DBRMLIX>` | DBRMライブラリ |
| `<LOADX>` | ロードライブラリ |
| `<DB2CCSID>` | DB2コードページ |

## 9. 処理フロー

```
┌─────────────────────────────────────────┐
│ START: GENACOMP (cobol.jcl)            │
└─────────────────┬───────────────────────┘
                  │
       ┌──────────┴──────────┐
       ▼                     ▼
┌──────────────┐      ┌──────────────┐
│ LGACDB01     │      │ LGACDB02     │  ... (27プログラム)
│  ↓ COBL      │      │  ↓ COBL      │
│  ↓ COPYLINK  │      │  ↓ COPYLINK  │
│  ↓ LKED      │      │  ↓ LKED      │
└──────────────┘      └──────────────┘
       │                     │
       └──────────┬──────────┘
                  ▼
┌─────────────────────────────────────────┐
│ END: 全プログラムのコンパイル完了        │
│ 出力: ロードモジュール → <LOADX>        │
│       DBRM → <DBRMLIX>                  │
└─────────────────────────────────────────┘
```

## 10. 前提条件

1. Enterprise COBOL for z/OS がインストールされていること
2. CICSライブラリが利用可能であること
3. DB2ライブラリが利用可能であること
4. Language Environmentライブラリが利用可能であること
5. ソースライブラリにすべてのプログラムメンバーが存在すること
6. asmmap.jcl でBMSマップが生成済みであること（SSMAPを参照するプログラムのため）

## 11. 実行後の確認事項

1. 全27プログラムのコンパイルが成功していること (RC=0 または RC=4)
2. ロードモジュールが`<LOADX>`に生成されていること
3. DBRMが`<DBRMLIX>`に生成されていること
4. 重大なコンパイルエラーがないこと

## 12. 障害時の対応

### コンパイルエラー (RC=8以上)

- SYSPRINTを確認し、ソースコードのエラーを修正
- コピーブックが見つからない場合は、SYSLIB連結を確認

### リンクエディットエラー

- 未解決外部参照: SYSLIBの連結順序を確認
- 重複シンボル: SYSLIN入力の順序を確認

### DBRM生成エラー

- DBRMLIB のスペース不足を確認
- メンバー名の重複を確認

## 13. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| asmmap.jcl | 事前実行推奨（BMSマップ生成） |
| db2bind.jcl | 事後実行必須（DBRMバインド） |
| cdef121.jcl | 事後実行必須（CSD定義） |
