# バッチ設計書: GENAMAP (asmmap.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENAMAP |
| JCLファイル | asmmap.jcl |
| カテゴリ | BMS画面生成 |
| 説明 | BMSマップ(SSMAP)のアセンブルとリンケージエディット |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用するBMS（Basic Mapping Support）マップを生成します。BMS定義ソース(SSMAP)をアセンブルして、実行可能なマップモジュールとDSECT（データ構造定義）を生成します。生成されたマップはCICS端末画面の入出力に使用されます。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| COPY | IEBGENER | マップソースを一時データセットにコピー |
| ASMMAP | ASMA90 | マップ(物理マップ)のアセンブル |
| LINKMAP | IEWL | マップモジュールのリンケージエディット |
| ASMDSECT | ASMA90 | DSECT(シンボリックマップ)のアセンブル |

## 4. ステップ詳細

### COPY ステップ

マップソースを一時データセットにコピーします。

| 項目 | 内容 |
|------|------|
| プログラム | IEBGENER |
| 入力 | `<SOURCEX>(SSMAP)` |
| 出力 | &&TEMPM (一時データセット) |
| DCB | LRECL=80, BLKSIZE=3120, RECFM=FB |

### ASMMAP ステップ (物理マップ生成)

アセンブラでBMSマップソースを処理し、物理マップ(実行可能モジュール)を生成します。

| 項目 | 内容 |
|------|------|
| プログラム | ASMA90 (High Level Assembler) |
| リージョン | 7500K |
| パラメータ | SYSPARM(MAP),DECK,NOOBJECT |

**SYSPARM=MAP の意味:**
- BMSマクロに対して物理マップを生成するよう指示

**入力DD:**

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSLIB | マクロライブラリ | `<CICSHLQ>.SDFHMAC`、`<SOURCEX>`、SYS1.MODGEN、SYS1.MACLIB |
| SYSIN | マップソース | &&TEMPM |

**出力DD:**

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | アセンブルリスト | SYSOUT=* |
| SYSPUNCH | オブジェクトデッキ | &&MAP |

### LINKMAP ステップ (リンケージエディット)

アセンブルされたマップをリンケージエディットし、ロードモジュールを生成します。

| 項目 | 内容 |
|------|------|
| プログラム | IEWL (Linkage Editor) |
| 条件 | COND=(7,LT,ASMMAP) |
| パラメータ | LIST,LET,XREF |

**入力DD:**

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSLIN | オブジェクト | &&MAP |

**出力DD:**

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSLMOD | ロードモジュール | `<LOADX>(SSMAP)` |
| SYSPRINT | リンクリスト | SYSOUT=* |

### ASMDSECT ステップ (シンボリックマップ生成)

アセンブラでBMSマップソースを処理し、シンボリックマップ(DSECT)を生成します。

| 項目 | 内容 |
|------|------|
| プログラム | ASMA90 (High Level Assembler) |
| リージョン | 7500K |
| パラメータ | SYSPARM(DSECT),DECK,NOOBJECT |

**SYSPARM=DSECT の意味:**
- BMSマクロに対してシンボリックマップ(DSECT)を生成するよう指示

**入力DD:**

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSLIB | マクロライブラリ | `<CICSHLQ>.SDFHMAC`、`<SOURCEX>`、SYS1.MODGEN、SYS1.MACLIB |
| SYSIN | マップソース | &&TEMPM |

**出力DD:**

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | アセンブルリスト | SYSOUT=* |
| SYSPUNCH | DSECTコピーブック | `<MAPCOPX>(SSMAP)` |

## 5. 生成される成果物

### 物理マップ (SSMAP)

| 項目 | 内容 |
|------|------|
| 出力先 | `<LOADX>(SSMAP)` |
| 種類 | ロードモジュール |
| 用途 | CICS端末画面の表示制御 |

### シンボリックマップ (SSMAP DSECT)

| 項目 | 内容 |
|------|------|
| 出力先 | `<MAPCOPX>(SSMAP)` |
| 種類 | コピーブック |
| 用途 | COBOLプログラムからの参照 |

## 6. DD文定義

### JOBレベル

| DD名 | 説明 | データセット |
|------|------|-------------|
| (なし) | - | - |

### COPYステップ

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | 出力(ダミー) | DUMMY |
| SYSIN | 入力(ダミー) | DUMMY |
| SYSUT1 | 入力ソース | `<SOURCEX>(SSMAP)` |
| SYSUT2 | 出力 | &&TEMPM |

### ASMMAPステップ

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | アセンブルリスト | SYSOUT=* |
| SYSLIB | マクロライブラリ | `<CICSHLQ>.SDFHMAC`、`<SOURCEX>`、SYS1.MODGEN、SYS1.MACLIB |
| SYSUT1 | ワークファイル | SYSDA, CYL(10,10) |
| SYSUT2 | ワークファイル | SYSDA, CYL(10,10) |
| SYSUT3 | ワークファイル | SYSDA, CYL(10,10) |
| SYSPUNCH | オブジェクト出力 | &&MAP |
| SYSIN | ソース入力 | &&TEMPM |

### LINKMAPステップ

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | リンクリスト | SYSOUT=* |
| SYSLMOD | ロードモジュール出力 | `<LOADX>(SSMAP)` |
| SYSUT1 | ワークファイル | SYSDA, BLKSIZE=1024, CYL(1,1) |
| SYSLIN | オブジェクト入力 | &&MAP |

### ASDSECTステップ

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | アセンブルリスト | SYSOUT=* |
| SYSLIB | マクロライブラリ | `<CICSHLQ>.SDFHMAC`、`<SOURCEX>`、SYS1.MODGEN、SYS1.MACLIB |
| SYSUT1 | ワークファイル | SYSDA, CYL(10,10) |
| SYSUT2 | ワークファイル | SYSDA, CYL(10,10) |
| SYSUT3 | ワークファイル | SYSDA, CYL(10,10) |
| SYSPUNCH | DSECT出力 | `<MAPCOPX>(SSMAP)` |
| SYSIN | ソース入力 | &&TEMPM |

## 7. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<CICSHLQ>` | CICS高レベル修飾子 |
| `<SOURCEX>` | ソースライブラリ |
| `<LOADX>` | ロードライブラリ |
| `<MAPCOPX>` | マップコピーブックライブラリ |

## 8. 処理フロー

```
┌─────────────────────────────────────────┐
│ START: GENAMAP (asmmap.jcl)            │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ COPY: IEBGENER                          │
│ <SOURCEX>(SSMAP) → &&TEMPM              │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ ASMMAP: ASMA90 SYSPARM(MAP)            │
│ &&TEMPM → &&MAP (オブジェクト)          │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ LINKMAP: IEWL                           │
│ &&MAP → <LOADX>(SSMAP) (ロードモジュール) │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ ASMDSECT: ASMA90 SYSPARM(DSECT)        │
│ &&TEMPM → <MAPCOPX>(SSMAP) (DSECT)      │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ END                                      │
└─────────────────────────────────────────┘
```

## 9. 前提条件

1. High Level Assembler (ASMA90) がインストールされていること
2. CICSマクロライブラリが利用可能であること
3. ソースライブラリにSSMAPメンバーが存在すること
4. ロードライブラリとマップコピーブックライブラリが事前に割り当てられていること

## 10. 実行後の確認事項

1. `<LOADX>(SSMAP)` にロードモジュールが生成されていること
2. `<MAPCOPX>(SSMAP)` にDSECTコピーブックが生成されていること
3. アセンブルエラー(重大度8以上)がないこと

## 11. 障害時の対応

### アセンブルエラー

- SYSPRINTを確認し、エラーメッセージを分析
- BMSマクロの構文エラーを修正
- マクロライブラリの連結順序を確認

### リンクエディットエラー

- 未解決参照がないことを確認
- SYSUT1のスペース不足を確認

### DSECT生成エラー

- 出力先`<MAPCOPX>`の権限とスペースを確認
- 同名メンバーの上書き可否を確認

## 12. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| cobol.jcl | 事後実行（SSMAPコピーブックを参照） |
| cdef121.jcl | 事後実行（SSMAPプログラムをCSD定義） |

## 13. BMSマップの役割

### 物理マップ

- 画面レイアウト情報を保持
- フィールド属性（保護、輝度、色など）を定義
- CICSのBMS処理で使用

### シンボリックマップ (DSECT)

- COBOLプログラムで使用するデータ構造
- 画面フィールドへのアクセスを提供
- COPY文でプログラムに取り込み
