# バッチ設計書: GENACSD (cdef121.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENACSD |
| JCLファイル | cdef121.jcl |
| カテゴリ | CICS CSD定義 |
| 説明 | CICS System Definition (CSD)へのリソース定義 |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用するCICSリソースをCSD（CICS System Definition）に定義します。トランザクション、プログラム、DB2接続、ファイル定義などのリソースをCSDに登録し、CICSリージョンで使用可能にします。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| CSDDEFS | DFHCSDUP | CSDリソース定義 |

### ステップ詳細

#### CSDDEFS ステップ

DFHCSDUPユーティリティを使用してCSDリソースを定義します。

| 項目 | 内容 |
|------|------|
| プログラム | DFHCSDUP |
| リージョン | 1M |

## 4. 定義されるリソースグループ

### グループ一覧

| グループ名 | 用途 | リスト |
|------------|------|--------|
| GENASAT | トランザクション定義 | GENALIST |
| GENASAP | プログラム定義 | GENALIST |
| GENASAD | DB2接続定義 | GENALIST |
| GENASAF | ファイル定義 | GENALIST |
| GENA | 共通定義 | GENALIST |

## 5. トランザクション定義 (GENASAT グループ)

| トランザクションID | プログラム | 説明 |
|--------------------|------------|------|
| SSC1 | LGTESTC1 | 顧客メニュー |
| SSP1 | LGTESTP1 | 自動車保険メニュー |
| SSP2 | LGTESTP2 | 生命保険メニュー |
| SSP3 | LGTESTP3 | 住宅保険メニュー |
| SSP4 | LGTESTP4 | 商業保険メニュー |
| LGSE | LGSETUP | 初期セットアップ |
| LGCF | LGICVS01 | 顧客照会(VSAM) |
| LGPF | LGIPVS01 | ポリシー照会(VSAM) |

### トランザクション属性

全トランザクションに共通の属性:

| 属性 | 設定値 |
|------|--------|
| TaskDataLoc | Any |
| TaskDataKey | User |

## 6. プログラム定義 (GENASAP グループ)

### メニュープログラム

| プログラム名 | 説明 |
|--------------|------|
| LGTESTC1 | 顧客メニュー |
| LGTESTP1 | 自動車保険メニュー |
| LGTESTP2 | 生命保険メニュー |
| LGTESTP3 | 住宅保険メニュー |
| LGTESTP4 | 商業保険メニュー |
| SSMAP | BMSマップ |

### 顧客管理プログラム

| プログラム名 | 説明 |
|--------------|------|
| LGACUS01 | 顧客追加 |
| LGICUS01 | 顧客照会 |
| LGUCUS01 | 顧客更新 |
| LGACDB01 | 顧客追加(DB2) |
| LGACDB02 | 顧客追加(DB2-2) |
| LGICDB01 | 顧客照会(DB2) |
| LGUCDB01 | 顧客更新(DB2) |
| LGACVS01 | 顧客追加(VSAM) |
| LGICVS01 | 顧客照会(VSAM) |
| LGUCVS01 | 顧客更新(VSAM) |

### ポリシー管理プログラム

| プログラム名 | 説明 |
|--------------|------|
| LGAPOL01 | ポリシー追加 |
| LGDPOL01 | ポリシー削除 |
| LGIPOL01 | ポリシー照会 |
| LGUPOL01 | ポリシー更新 |
| LGAPDB01 | ポリシー追加(DB2) |
| LGDPDB01 | ポリシー削除(DB2) |
| LGIPDB01 | ポリシー照会(DB2) |
| LGUPDB01 | ポリシー更新(DB2) |
| LGAPVS01 | ポリシー追加(VSAM) |
| LGDPVS01 | ポリシー削除(VSAM) |
| LGIPVS01 | ポリシー照会(VSAM) |
| LGUPVS01 | ポリシー更新(VSAM) |

### ユーティリティプログラム

| プログラム名 | 説明 |
|--------------|------|
| LGSETUP | TSキュー初期設定 |
| LGSTSQ | TSキューメッセージ出力 |
| LGAPBR01 | ブローカー処理 |

### プログラム属性

全プログラムに共通の属性:

| 属性 | 設定値 |
|------|--------|
| Language | Cobol |
| DataLocation | Any |
| Execkey | User |

## 7. DB2接続定義 (GENASAD グループ)

### DB2Conn定義

| 属性 | 設定値 |
|------|--------|
| 名前 | `<DB2SSID>` |
| DB2ID | `<DB2SSID>` |
| NONtermrel | No |
| ResyncMember | No |
| MSGqueue1 | CSMT |
| StatsQueue | CSMT |
| TCBlimit | 400 |
| ThreadError | Abend |
| AccountRec | Txid |
| AuthType | Userid |
| Drollback | Yes |
| ThreadLimit | 250 |

### DB2Entry定義

| 属性 | 設定値 |
|------|--------|
| 名前 | `<DB2SSID>LU2` |
| Transid | SS* |
| AccountRec | Txid |
| Plan | GENAONE |
| ThreadLimit | 250 |

## 8. ファイル定義 (GENASAF グループ)

### KSDSCUST (顧客マスタ)

| 属性 | 設定値 |
|------|--------|
| DSname | `<USRHLQ>.GENAPP.KSDSCUST` |
| Recordsize | 82 |
| Keylength | 10 |
| Status | Enabled |
| Opentime | Firstref |
| Add | Yes |
| Browse | Yes |
| Read | Yes |
| Delete | No |
| Update | Yes |

### KSDSPOLY (ポリシーマスタ)

| 属性 | 設定値 |
|------|--------|
| DSname | `<USRHLQ>.GENAPP.KSDSPOLY` |
| Recordsize | 64 |
| Keylength | 21 |
| Status | Enabled |
| Opentime | Firstref |
| Add | Yes |
| Browse | Yes |
| Read | Yes |
| Delete | Yes |
| Update | Yes |

## 9. ENQモデル定義 (GENA グループ)

| 属性 | 設定値 |
|------|--------|
| 名前 | GENAMOD |
| 説明 | GRS for GENAPP |
| ENQscope | GENA |
| ENQname | GENACNTL |

## 10. DD文定義

| DD名 | 説明 | データセット |
|------|------|-------------|
| STEPLIB | CICSロードライブラリ | `<CICSHLQ>.SDFHLOAD` |
| DFHCSD | CSD | `<CSDNAME>` |
| SYSUT1 | ワークファイル | SYSDA, 1024,(100,100) |
| SYSPRINT | 出力リスト | SYSOUT=* |
| SYSIN | 定義入力 | インライン |

## 11. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<CICSHLQ>` | CICS高レベル修飾子 |
| `<CSDNAME>` | CSDデータセット名 |
| `<DB2SSID>` | DB2サブシステムID |
| `<USRHLQ>` | ユーザー高レベル修飾子 |

## 12. 処理フロー

```
┌─────────────────────────────────────────┐
│ START: GENACSD (cdef121.jcl)           │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ グループをリストに追加                   │
│ Add Group(GENASAT) List(GENALIST)       │
│ Add Group(GENASAP) List(GENALIST)       │
│ Add Group(GENASAD) List(GENALIST)       │
│ Add Group(GENASAF) List(GENALIST)       │
│ Add Group(GENA)    List(GENALIST)       │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ トランザクション定義 (8件)               │
│ SSC1, SSP1, SSP2, SSP3, SSP4            │
│ LGSE, LGCF, LGPF                        │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ プログラム定義 (25件以上)               │
│ LGTESTC1, LGTESTP1-4, SSMAP            │
│ LGACUS01, LGICUS01, LGUCUS01, ...      │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DB2接続定義                              │
│ DB2Conn, DB2Entry                       │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ ファイル定義                             │
│ KSDSCUST, KSDSPOLY                      │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ ENQモデル定義                            │
│ GENAMOD                                  │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ END                                      │
└─────────────────────────────────────────┘
```

## 13. 前提条件

1. CSDデータセットが存在し、アクセス可能であること
2. cobol.jcl でプログラムがコンパイル済みであること
3. asmmap.jcl でBMSマップが生成済みであること
4. adef121.jcl でVSAMファイルが定義済みであること

## 14. 実行後の確認事項

1. 全てのグループがGENALISTに追加されていること
2. 全てのトランザクションが定義されていること
3. 全てのプログラムが定義されていること
4. DB2接続が正しく定義されていること
5. ファイル定義が正しく設定されていること

## 15. 障害時の対応

### リソースが既に存在する場合

- JCLのコメントアウトされた Delete コマンドを有効にして、既存リソースを削除してから再実行

### CSDアクセスエラー

- CSDデータセットの排他制御を確認
- 他のCICSリージョンがCSDを使用中でないことを確認

## 16. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| cobol.jcl | 事前実行必須（プログラム生成） |
| asmmap.jcl | 事前実行必須（BMSマップ生成） |
| adef121.jcl | 事前実行推奨（VSAMファイル定義） |
| db2cre.jcl | 事前実行必須（DB2テーブル作成） |
| db2bind.jcl | 事前実行必須（プランバインド） |

## 17. CICSリージョンへの適用

CSD定義後、CICSリージョンで以下のコマンドを実行してリソースをインストールします:

```
CEDA INSTALL GROUP(GENASAT)
CEDA INSTALL GROUP(GENASAP)
CEDA INSTALL GROUP(GENASAD)
CEDA INSTALL GROUP(GENASAF)
CEDA INSTALL GROUP(GENA)
```

または、GENALISTを使用:

```
CEDA INSTALL LIST(GENALIST)
```
