# バッチ設計書: GENAVSAM (adef121.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | GENAVSAM |
| JCLファイル | adef121.jcl |
| カテゴリ | VSAM管理 |
| 説明 | VSAMファイルの定義とデータ投入 |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用するVSAMファイル（KSDS: Key Sequenced Data Set）を定義し、初期データを投入します。顧客マスタ（KSDSCUST）とポリシーマスタ（KSDSPOLY）の2つのVSAMクラスタを作成します。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| DELETE1 | IDCAMS | 顧客VSAMクラスタの削除 |
| DEFINE1 | IDCAMS | 顧客VSAMクラスタの定義 |
| DELETE2 | IDCAMS | ポリシーVSAMクラスタの削除 |
| DEFINE2 | IDCAMS | ポリシーVSAMクラスタの定義 |
| CUSTDATA | IDCAMS | 顧客データの投入 |
| POLYDATA | IDCAMS | ポリシーデータの投入 |

## 4. ステップ詳細

### DELETE1 ステップ (顧客クラスタ削除)

既存の顧客VSAMクラスタを削除します。

| 項目 | 内容 |
|------|------|
| プログラム | IDCAMS |
| 削除対象 | `<USRHLQ>.GENAPP.KSDSCUST` |
| エラー処理 | MAXCC=8 の場合は MAXCC=0 に設定 |

**注意:** クラスタが存在しない場合でもエラーを無視して継続します。

### DEFINE1 ステップ (顧客クラスタ定義)

顧客情報を格納するVSAMクラスタを定義します。

**クラスタ定義:**

| 属性 | 設定値 |
|------|--------|
| クラスタ名 | `<USRHLQ>.GENAPP.KSDSCUST` |
| データセット種別 | INDEXED (KSDS) |
| ボリューム | SYSDAV |
| 一次スペース | 100 CYL |
| 二次スペース | 30 CYL |
| 共用オプション | SHR(3) |
| ログオプション | UNDO |
| フリースペース | (10 10) |
| 再利用 | REUSE |

**DATAコンポーネント:**

| 属性 | 設定値 |
|------|--------|
| 名前 | `<USRHLQ>.GENAPP.KSDSCUST.DATA` |
| キー長 | 10 |
| キー位置 | 0 |
| レコードサイズ | 225 |
| CISZ | 8000 |

**INDEXコンポーネント:**

| 属性 | 設定値 |
|------|--------|
| 名前 | `<USRHLQ>.GENAPP.KSDSCUST.INDEX` |

### DELETE2 ステップ (ポリシークラスタ削除)

既存のポリシーVSAMクラスタを削除します。

| 項目 | 内容 |
|------|------|
| プログラム | IDCAMS |
| 削除対象 | `<USRHLQ>.GENAPP.KSDSPOLY` |
| エラー処理 | MAXCC=8 の場合は MAXCC=0 に設定 |

### DEFINE2 ステップ (ポリシークラスタ定義)

ポリシー情報を格納するVSAMクラスタを定義します。

**クラスタ定義:**

| 属性 | 設定値 |
|------|--------|
| クラスタ名 | `<USRHLQ>.GENAPP.KSDSPOLY` |
| データセット種別 | INDEXED (KSDS) |
| ボリューム | SYSDAV |
| 一次スペース | 100 CYL |
| 二次スペース | 30 CYL |
| 共用オプション | SHR(3) |
| ログオプション | UNDO |
| フリースペース | (10 10) |
| 再利用 | REUSE |

**DATAコンポーネント:**

| 属性 | 設定値 |
|------|--------|
| 名前 | `<USRHLQ>.GENAPP.KSDSPOLY.DATA` |
| キー長 | 21 |
| キー位置 | 0 |
| レコードサイズ | 64 |
| CISZ | 8000 |

**INDEXコンポーネント:**

| 属性 | 設定値 |
|------|--------|
| 名前 | `<USRHLQ>.GENAPP.KSDSPOLY.INDEX` |

### CUSTDATA ステップ (顧客データ投入)

初期顧客データをVSAMクラスタにロードします。

| 項目 | 内容 |
|------|------|
| プログラム | IDCAMS |
| 条件 | COND=(7,LT,DEFINE1) |
| コマンド | REPRO |
| 入力 | `<KSDSCUS>` |
| 出力 | `<USRHLQ>.GENAPP.KSDSCUST` |

### POLYDATA ステップ (ポリシーデータ投入)

初期ポリシーデータをVSAMクラスタにロードします。

| 項目 | 内容 |
|------|------|
| プログラム | IDCAMS |
| 条件 | COND=(7,LT,DEFINE2) |
| コマンド | REPRO |
| 入力 | `<KSDSPOL>` |
| 出力 | `<USRHLQ>.GENAPP.KSDSPOLY` |

## 5. VSAMクラスタ仕様

### KSDSCUST (顧客マスタ)

| 項目 | 仕様 |
|------|------|
| 組織 | KSDS (Key Sequenced Data Set) |
| キー長 | 10バイト |
| キー位置 | オフセット0 |
| レコード長 | 225バイト (固定長) |
| 用途 | 顧客情報の格納 |

### KSDSPOLY (ポリシーマスタ)

| 項目 | 仕様 |
|------|------|
| 組織 | KSDS (Key Sequenced Data Set) |
| キー長 | 21バイト |
| キー位置 | オフセット0 |
| レコード長 | 64バイト (固定長) |
| 用途 | ポリシー情報の格納 |

## 6. DD文定義

### 全ステップ共通

| DD名 | 説明 | データセット |
|------|------|-------------|
| SYSPRINT | 出力リスト | SYSOUT=* |
| SYSIN | IDCAMSコマンド | インライン |

### CUSTDATAステップ

| DD名 | 説明 | データセット |
|------|------|-------------|
| DDIN | 入力データ | `<KSDSCUS>` |
| DDOUT | 出力VSAM | `<USRHLQ>.GENAPP.KSDSCUST` |

### POLYDATAステップ

| DD名 | 説明 | データセット |
|------|------|-------------|
| DDIN | 入力データ | `<KSDSPOL>` |
| DDOUT | 出力VSAM | `<USRHLQ>.GENAPP.KSDSPOLY` |

## 7. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<USRHLQ>` | ユーザー高レベル修飾子 |
| `<KSDSCUS>` | 顧客初期データセット |
| `<KSDSPOL>` | ポリシー初期データセット |

## 8. 処理フロー

```
┌─────────────────────────────────────────┐
│ START: GENAVSAM (adef121.jcl)          │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DELETE1: IDCAMS                         │
│ DELETE <USRHLQ>.GENAPP.KSDSCUST        │
│ (存在しなければ無視)                     │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DEFINE1: IDCAMS                         │
│ DEFINE CLUSTER(KSDSCUST)               │
│ KSDS, KEY(10,0), RECSIZE(225)          │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DELETE2: IDCAMS                         │
│ DELETE <USRHLQ>.GENAPP.KSDSPOLY        │
│ (存在しなければ無視)                     │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ DEFINE2: IDCAMS                         │
│ DEFINE CLUSTER(KSDSPOLY)               │
│ KSDS, KEY(21,0), RECSIZE(64)           │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ CUSTDATA: IDCAMS REPRO                  │
│ <KSDSCUS> → KSDSCUST                    │
│ (DEFINE1成功時のみ実行)                  │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ POLYDATA: IDCAMS REPRO                  │
│ <KSDSPOL> → KSDSPOLY                    │
│ (DEFINE2成功時のみ実行)                  │
└─────────────────┬───────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────┐
│ END                                      │
└─────────────────────────────────────────┘
```

## 9. 前提条件

1. ボリューム SYSDAV が利用可能であること
2. 初期データファイル(`<KSDSCUS>`, `<KSDSPOL>`)が存在すること
3. IDCAMSが利用可能であること
4. 十分なディスクスペースがあること (顧客: 100+30 CYL、ポリシー: 100+30 CYL)

## 10. 実行後の確認事項

1. KSDSCUSTクラスタが正常に定義されていること
2. KSDSPOLYクラスタが正常に定義されていること
3. 初期データが正しくロードされていること
4. IDCAMS LISTCAT でクラスタ情報を確認

## 11. 障害時の対応

### DELETE失敗 (存在しない場合)

- 正常動作: MAXCC=8 → MAXCC=0 に変換されるため問題なし

### DEFINE失敗

- ボリュームスペース不足: ボリュームを変更または拡張
- カタログエラー: カタログ管理者に連絡

### REPRO失敗

- 入力データが存在しない: 入力データセットの作成が必要
- キー重複: 入力データのキー値を確認
- レコード長不一致: 入力データのレコード形式を確認

## 12. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| cdef121.jcl | 事後実行（CSDファイル定義でこのVSAMを参照） |

## 13. 使用上の注意

### REUSE属性

- VSAMクラスタにREUSE属性が設定されているため、OPENするとデータが消去される可能性があります
- 本番環境ではREUSE属性の使用に注意が必要です

### SHR(3)オプション

- 複数のジョブ/タスクからの同時読み取りを許可
- 更新時の整合性はアプリケーションで管理が必要
