# バッチ設計書: CICSSTSQ (samptsq.jcl)

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| バッチ名 | CICSSTSQ |
| JCLファイル | samptsq.jcl |
| カテゴリ | CICSサーバー起動 |
| 説明 | 共有TSキューサーバーの起動 |

## 2. 処理概要

このバッチは、GENAPPアプリケーションで使用する共有Temporary Storage（TS）キューサーバーを起動します。TSキューサーバーは、複数のCICSリージョン間で一時ストレージキューを共有するためのサーバープロセスです。

## 3. 実行ステップ

### ステップ一覧

| ステップ名 | 実行プログラム | 処理内容 |
|------------|----------------|----------|
| SHARETSQ | DFHXQMN | 共有TSキューサーバーの起動 |

### ステップ詳細

#### SHARETSQ ステップ

DFHXQMNプログラムを使用して共有TSキューサーバーを起動します。

| 項目 | 内容 |
|------|------|
| プログラム | DFHXQMN |
| 機能 | 共有TSキュー管理サーバー |

## 4. 起動パラメータ

| パラメータ | 設定値 | 説明 |
|------------|--------|------|
| POOLNAME | GENA | TSキュープール名 |
| MAXQUEUES | 500 | 最大キュー数 |
| BUFFERS | 750 | バッファ数 |

### パラメータ詳細

#### POOLNAME

- GENAPPアプリケーション用のTSキュープール識別子
- CICSリージョンからこのプール名を指定してアクセス

#### MAXQUEUES

- サーバーが管理可能な最大キュー数
- 500キューまでの同時管理が可能

#### BUFFERS

- データバッファの数
- キューデータのキャッシュに使用

## 5. DD文定義

| DD名 | 説明 | データセット |
|------|------|-------------|
| STEPLIB | CICSライブラリ | `<CICSHLQ>.SDFHAUTH`、`<CICSLIC>.SDFHLIC` |
| SYSPRINT | 出力リスト | SYSOUT=* |
| SYSIN | 入力(ダミー) | DUMMY |

## 6. 置換変数

| 変数名 | 説明 |
|--------|------|
| `<CICSHLQ>` | CICS高レベル修飾子 |
| `<CICSLIC>` | CICSライセンスライブラリ修飾子 |

## 7. 共有TSキューの仕組み

```
┌─────────────┐     ┌─────────────┐     ┌─────────────┐
│  CICS       │     │  CICS       │     │  CICS       │
│ Region A    │     │ Region B    │     │ Region C    │
└──────┬──────┘     └──────┬──────┘     └──────┬──────┘
       │                   │                   │
       └───────────────────┼───────────────────┘
                           │
                           ▼
            ┌─────────────────────────────┐
            │  DFHXQMN                    │
            │  共有TSキューサーバー        │
            │  POOLNAME=GENA             │
            │  MAXQUEUES=500             │
            │  BUFFERS=750               │
            └─────────────────────────────┘
```

## 8. 前提条件

1. CICSライブラリ(`<CICSHLQ>.SDFHAUTH`)が利用可能であること
2. CICSライセンスライブラリ(`<CICSLIC>.SDFHLIC`)が利用可能であること
3. APF認証が設定されていること(SDFHAUTHはAPF認証が必要)

## 9. 実行後の確認事項

1. サーバーが正常に起動していること
2. SYSPRINTに起動完了メッセージが出力されていること
3. 指定されたプール名でCICSリージョンからアクセス可能であること

## 10. CICSリージョンでの設定

CICSリージョンがこの共有TSキューサーバーを使用するには、以下の設定が必要です:

### システム初期化パラメータ

```
TSPOOL=GENA
```

または

```
TS=SHARED
```

### TSモデル定義（CSD）

```
Define TSmodel(モデル名) Group(グループ名)
       Poolname(GENA)
       Prefix(キュー名プレフィックス)
```

## 11. 障害時の対応

### サーバー起動失敗

- STEPLIBのライブラリパスを確認
- APF認証の設定を確認
- SYSPRINTのエラーメッセージを確認

### メモリ不足

- MAXQUEUESまたはBUFFERSの値を削減
- リージョンサイズを拡大

### プール名競合

- 同じPOOLNAMEで既にサーバーが起動していないか確認
- 既存のサーバーを停止してから再起動

## 12. 関連バッチ

| バッチ名 | 関係 |
|----------|------|
| sampwui.jcl | TSキューを使用するCICSリージョン（NCPLDFT=GENA設定） |

## 13. 運用上の注意

### 起動順序

1. 共有TSキューサーバー（このジョブ）を先に起動
2. その後、このサーバーを使用するCICSリージョンを起動

### 停止順序

1. CICSリージョンを先に停止
2. その後、共有TSキューサーバーを停止

### 常駐サーバー

- このジョブは常駐サーバーとして継続稼働します
- ジョブ終了 = サーバー停止となります
- 停止する場合は P (STOP) コマンドまたはキャンセルを使用

## 14. パフォーマンス考慮事項

| パラメータ | 影響 |
|------------|------|
| MAXQUEUES | 多すぎるとメモリ消費が増加 |
| BUFFERS | 多いほどI/O削減、ただしメモリ消費増加 |
